/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;

public class HopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    public static final int MOVE_ITEM_SPEED = 8;
    public static final int HOPPER_CONTAINER_SIZE = 5;
    private NonNullList<ItemStack> items = NonNullList.withSize(5, ItemStack.EMPTY);
    private int cooldownTime = -1;
    private long tickedGameTime;

    public HopperBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(BlockEntityType.HOPPER, pWorldPosition, pBlockState);
    }

    @Override
    public void load(CompoundTag pTag) {
        super.load(pTag);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(pTag)) {
            ContainerHelper.loadAllItems(pTag, this.items);
        }
        this.cooldownTime = pTag.getInt("TransferCooldown");
    }

    @Override
    protected void saveAdditional(CompoundTag p_187502_) {
        super.saveAdditional(p_187502_);
        if (!this.trySaveLootTable(p_187502_)) {
            ContainerHelper.saveAllItems(p_187502_, this.items);
        }
        p_187502_.putInt("TransferCooldown", this.cooldownTime);
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public ItemStack removeItem(int pIndex, int pCount) {
        this.unpackLootTable(null);
        return ContainerHelper.removeItem(this.getItems(), pIndex, pCount);
    }

    @Override
    public void setItem(int pIndex, ItemStack pStack) {
        this.unpackLootTable(null);
        this.getItems().set(pIndex, pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
    }

    @Override
    protected Component getDefaultName() {
        return new TranslatableComponent("container.hopper");
    }

    public static void pushItemsTick(Level pLevel, BlockPos pPos, BlockState pState, HopperBlockEntity pBlockEntity) {
        --pBlockEntity.cooldownTime;
        pBlockEntity.tickedGameTime = pLevel.getGameTime();
        if (!pBlockEntity.isOnCooldown()) {
            pBlockEntity.setCooldown(0);
            HopperBlockEntity.tryMoveItems(pLevel, pPos, pState, pBlockEntity, () -> HopperBlockEntity.suckInItems(pLevel, pBlockEntity));
        }
    }

    private static boolean tryMoveItems(Level p_155579_, BlockPos p_155580_, BlockState p_155581_, HopperBlockEntity p_155582_, BooleanSupplier p_155583_) {
        if (p_155579_.isClientSide) {
            return false;
        }
        if (!p_155582_.isOnCooldown() && p_155581_.getValue(HopperBlock.ENABLED).booleanValue()) {
            boolean flag = false;
            if (!p_155582_.isEmpty()) {
                flag = HopperBlockEntity.ejectItems(p_155579_, p_155580_, p_155581_, p_155582_);
            }
            if (!p_155582_.inventoryFull()) {
                flag |= p_155583_.getAsBoolean();
            }
            if (flag) {
                p_155582_.setCooldown(8);
                HopperBlockEntity.setChanged(p_155579_, p_155580_, p_155581_);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private static boolean ejectItems(Level pLevel, BlockPos pPos, BlockState pState, Container pSourceContainer) {
        Container container = HopperBlockEntity.getAttachedContainer(pLevel, pPos, pState);
        if (container == null) {
            return false;
        }
        Direction direction = pState.getValue(HopperBlock.FACING).getOpposite();
        if (HopperBlockEntity.isFullContainer(container, direction)) {
            return false;
        }
        int i = 0;
        while (i < pSourceContainer.getContainerSize()) {
            if (!pSourceContainer.getItem(i).isEmpty()) {
                ItemStack itemstack = pSourceContainer.getItem(i).copy();
                ItemStack itemstack1 = HopperBlockEntity.addItem(pSourceContainer, container, pSourceContainer.removeItem(i, 1), direction);
                if (itemstack1.isEmpty()) {
                    container.setChanged();
                    return true;
                }
                pSourceContainer.setItem(i, itemstack);
            }
            ++i;
        }
        return false;
    }

    private static IntStream getSlots(Container p_59340_, Direction p_59341_) {
        return p_59340_ instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)p_59340_).getSlotsForFace(p_59341_)) : IntStream.range(0, p_59340_.getContainerSize());
    }

    private static boolean isFullContainer(Container pContainer, Direction pDirection) {
        return HopperBlockEntity.getSlots(pContainer, pDirection).allMatch(p_59379_ -> {
            ItemStack itemstack = pContainer.getItem(p_59379_);
            return itemstack.getCount() >= itemstack.getMaxStackSize();
        });
    }

    private static boolean isEmptyContainer(Container pContainer, Direction pDirection) {
        return HopperBlockEntity.getSlots(pContainer, pDirection).allMatch(p_59319_ -> pContainer.getItem(p_59319_).isEmpty());
    }

    public static boolean suckInItems(Level p_155553_, Hopper p_155554_) {
        Container container = HopperBlockEntity.getSourceContainer(p_155553_, p_155554_);
        if (container != null) {
            Direction direction = Direction.DOWN;
            return HopperBlockEntity.isEmptyContainer(container, direction) ? false : HopperBlockEntity.getSlots(container, direction).anyMatch(p_59363_ -> HopperBlockEntity.tryTakeInItemFromSlot(p_155554_, container, p_59363_, direction));
        }
        for (ItemEntity itementity : HopperBlockEntity.getItemsAtAndAbove(p_155553_, p_155554_)) {
            if (!HopperBlockEntity.addItem(p_155554_, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(Hopper pHopper, Container pContainer, int pSlot, Direction pDirection) {
        ItemStack itemstack = pContainer.getItem(pSlot);
        if (!itemstack.isEmpty() && HopperBlockEntity.canTakeItemFromContainer(pContainer, itemstack, pSlot, pDirection)) {
            ItemStack itemstack1 = itemstack.copy();
            ItemStack itemstack2 = HopperBlockEntity.addItem(pContainer, pHopper, pContainer.removeItem(pSlot, 1), null);
            if (itemstack2.isEmpty()) {
                pContainer.setChanged();
                return true;
            }
            pContainer.setItem(pSlot, itemstack1);
        }
        return false;
    }

    public static boolean addItem(Container p_59332_, ItemEntity p_59333_) {
        boolean flag = false;
        ItemStack itemstack = p_59333_.getItem().copy();
        ItemStack itemstack1 = HopperBlockEntity.addItem(null, p_59332_, itemstack, null);
        if (itemstack1.isEmpty()) {
            flag = true;
            p_59333_.discard();
        } else {
            p_59333_.setItem(itemstack1);
        }
        return flag;
    }

    public static ItemStack addItem(@Nullable Container pSource, Container pDestination, ItemStack pStack, @Nullable Direction pDirection) {
        if (pDestination instanceof WorldlyContainer && pDirection != null) {
            WorldlyContainer worldlycontainer = (WorldlyContainer)pDestination;
            int[] aint = worldlycontainer.getSlotsForFace(pDirection);
            int k = 0;
            while (k < aint.length && !pStack.isEmpty()) {
                pStack = HopperBlockEntity.tryMoveInItem(pSource, pDestination, pStack, aint[k], pDirection);
                ++k;
            }
        } else {
            int i = pDestination.getContainerSize();
            int j = 0;
            while (j < i && !pStack.isEmpty()) {
                pStack = HopperBlockEntity.tryMoveInItem(pSource, pDestination, pStack, j, pDirection);
                ++j;
            }
        }
        return pStack;
    }

    private static boolean canPlaceItemInContainer(Container pContainer, ItemStack pStack, int pSlot, @Nullable Direction pDirection) {
        if (!pContainer.canPlaceItem(pSlot, pStack)) {
            return false;
        }
        return !(pContainer instanceof WorldlyContainer) || ((WorldlyContainer)pContainer).canPlaceItemThroughFace(pSlot, pStack, pDirection);
    }

    private static boolean canTakeItemFromContainer(Container pContainer, ItemStack pStack, int pSlot, Direction pDirection) {
        return !(pContainer instanceof WorldlyContainer) || ((WorldlyContainer)pContainer).canTakeItemThroughFace(pSlot, pStack, pDirection);
    }

    private static ItemStack tryMoveInItem(@Nullable Container pSource, Container pDestination, ItemStack pStack, int pSlot, @Nullable Direction pDirection) {
        ItemStack itemstack = pDestination.getItem(pSlot);
        if (HopperBlockEntity.canPlaceItemInContainer(pDestination, pStack, pSlot, pDirection)) {
            boolean flag = false;
            boolean flag1 = pDestination.isEmpty();
            if (itemstack.isEmpty()) {
                pDestination.setItem(pSlot, pStack);
                pStack = ItemStack.EMPTY;
                flag = true;
            } else if (HopperBlockEntity.canMergeItems(itemstack, pStack)) {
                int i = pStack.getMaxStackSize() - itemstack.getCount();
                int j = Math.min(pStack.getCount(), i);
                pStack.shrink(j);
                itemstack.grow(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                HopperBlockEntity hopperblockentity1;
                if (flag1 && pDestination instanceof HopperBlockEntity && !(hopperblockentity1 = (HopperBlockEntity)pDestination).isOnCustomCooldown()) {
                    int k = 0;
                    if (pSource instanceof HopperBlockEntity) {
                        HopperBlockEntity hopperblockentity = (HopperBlockEntity)pSource;
                        if (hopperblockentity1.tickedGameTime >= hopperblockentity.tickedGameTime) {
                            k = 1;
                        }
                    }
                    hopperblockentity1.setCooldown(8 - k);
                }
                pDestination.setChanged();
            }
        }
        return pStack;
    }

    @Nullable
    private static Container getAttachedContainer(Level p_155593_, BlockPos p_155594_, BlockState p_155595_) {
        Direction direction = p_155595_.getValue(HopperBlock.FACING);
        return HopperBlockEntity.getContainerAt(p_155593_, p_155594_.relative(direction));
    }

    @Nullable
    private static Container getSourceContainer(Level p_155597_, Hopper p_155598_) {
        return HopperBlockEntity.getContainerAt(p_155597_, p_155598_.getLevelX(), p_155598_.getLevelY() + 1.0, p_155598_.getLevelZ());
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level p_155590_, Hopper p_155591_) {
        return p_155591_.getSuckShape().toAabbs().stream().flatMap(p_155558_ -> p_155590_.getEntitiesOfClass(ItemEntity.class, p_155558_.move(p_155591_.getLevelX() - 0.5, p_155591_.getLevelY() - 0.5, p_155591_.getLevelZ() - 0.5), EntitySelector.ENTITY_STILL_ALIVE).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static Container getContainerAt(Level p_59391_, BlockPos p_59392_) {
        return HopperBlockEntity.getContainerAt(p_59391_, (double)p_59392_.getX() + 0.5, (double)p_59392_.getY() + 0.5, (double)p_59392_.getZ() + 0.5);
    }

    @Nullable
    private static Container getContainerAt(Level pLevel, double pX, double p_59350_, double pY) {
        List<Entity> list;
        BlockEntity blockentity;
        Container container = null;
        BlockPos blockpos = new BlockPos(pX, p_59350_, pY);
        BlockState blockstate = pLevel.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            container = ((WorldlyContainerHolder)((Object)block)).getContainer(blockstate, pLevel, blockpos);
        } else if (blockstate.hasBlockEntity() && (blockentity = pLevel.getBlockEntity(blockpos)) instanceof Container && (container = (Container)((Object)blockentity)) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            container = ChestBlock.getContainer((ChestBlock)block, blockstate, pLevel, blockpos, true);
        }
        if (container == null && !(list = pLevel.getEntities((Entity)null, new AABB(pX - 0.5, p_59350_ - 0.5, pY - 0.5, pX + 0.5, p_59350_ + 0.5, pY + 0.5), (Predicate<? super Entity>)EntitySelector.CONTAINER_ENTITY_SELECTOR)).isEmpty()) {
            container = (Container)((Object)list.get(pLevel.random.nextInt(list.size())));
        }
        return container;
    }

    private static boolean canMergeItems(ItemStack pStack1, ItemStack pStack2) {
        if (!pStack1.is(pStack2.getItem())) {
            return false;
        }
        if (pStack1.getDamageValue() != pStack2.getDamageValue()) {
            return false;
        }
        if (pStack1.getCount() > pStack1.getMaxStackSize()) {
            return false;
        }
        return ItemStack.tagMatches(pStack1, pStack2);
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    private void setCooldown(int pCooldownTime) {
        this.cooldownTime = pCooldownTime;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    private boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    public static void entityInside(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity, HopperBlockEntity pBlockEntity) {
        if (pEntity instanceof ItemEntity && Shapes.joinIsNotEmpty(Shapes.create(pEntity.getBoundingBox().move(-pPos.getX(), -pPos.getY(), -pPos.getZ())), pBlockEntity.getSuckShape(), BooleanOp.AND)) {
            HopperBlockEntity.tryMoveItems(pLevel, pPos, pState, pBlockEntity, () -> HopperBlockEntity.addItem(pBlockEntity, (ItemEntity)pEntity));
        }
    }

    @Override
    protected AbstractContainerMenu createMenu(int pId, Inventory pPlayer) {
        return new HopperMenu(pId, pPlayer, this);
    }
}

