/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class JigsawBlockEntity
extends BlockEntity {
    public static final String TARGET = "target";
    public static final String POOL = "pool";
    public static final String JOINT = "joint";
    public static final String NAME = "name";
    public static final String FINAL_STATE = "final_state";
    private ResourceLocation name = new ResourceLocation("empty");
    private ResourceLocation target = new ResourceLocation("empty");
    private ResourceLocation pool = new ResourceLocation("empty");
    private JointType joint = JointType.ROLLABLE;
    private String finalState = "minecraft:air";

    public JigsawBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(BlockEntityType.JIGSAW, pWorldPosition, pBlockState);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public ResourceLocation getTarget() {
        return this.target;
    }

    public ResourceLocation getPool() {
        return this.pool;
    }

    public String getFinalState() {
        return this.finalState;
    }

    public JointType getJoint() {
        return this.joint;
    }

    public void setName(ResourceLocation pName) {
        this.name = pName;
    }

    public void setTarget(ResourceLocation pTarget) {
        this.target = pTarget;
    }

    public void setPool(ResourceLocation pPool) {
        this.pool = pPool;
    }

    public void setFinalState(String pFinalState) {
        this.finalState = pFinalState;
    }

    public void setJoint(JointType pJoint) {
        this.joint = pJoint;
    }

    @Override
    protected void saveAdditional(CompoundTag p_187504_) {
        super.saveAdditional(p_187504_);
        p_187504_.putString(NAME, this.name.toString());
        p_187504_.putString(TARGET, this.target.toString());
        p_187504_.putString(POOL, this.pool.toString());
        p_187504_.putString(FINAL_STATE, this.finalState);
        p_187504_.putString(JOINT, this.joint.getSerializedName());
    }

    @Override
    public void load(CompoundTag pTag) {
        super.load(pTag);
        this.name = new ResourceLocation(pTag.getString(NAME));
        this.target = new ResourceLocation(pTag.getString(TARGET));
        this.pool = new ResourceLocation(pTag.getString(POOL));
        this.finalState = pTag.getString(FINAL_STATE);
        this.joint = JointType.byName(pTag.getString(JOINT)).orElseGet(() -> JigsawBlock.getFrontFacing(this.getBlockState()).getAxis().isHorizontal() ? JointType.ALIGNED : JointType.ROLLABLE);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public void generate(ServerLevel p_59421_, int p_59422_, boolean p_59423_) {
        ChunkGenerator chunkgenerator = p_59421_.getChunkSource().getGenerator();
        StructureManager structuremanager = p_59421_.getStructureManager();
        StructureFeatureManager structurefeaturemanager = p_59421_.structureFeatureManager();
        Random random = p_59421_.getRandom();
        BlockPos blockpos = this.getBlockPos();
        ArrayList list = Lists.newArrayList();
        StructureTemplate structuretemplate = new StructureTemplate();
        structuretemplate.fillFromWorld(p_59421_, blockpos, new Vec3i(1, 1, 1), false, null);
        SinglePoolElement structurepoolelement = new SinglePoolElement(structuretemplate);
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuremanager, structurepoolelement, blockpos, 1, Rotation.NONE, new BoundingBox(blockpos));
        JigsawPlacement.addPieces(p_59421_.registryAccess(), poolelementstructurepiece, p_59422_, PoolElementStructurePiece::new, chunkgenerator, structuremanager, list, random, p_59421_);
        for (PoolElementStructurePiece poolelementstructurepiece1 : list) {
            poolelementstructurepiece1.place(p_59421_, structurefeaturemanager, chunkgenerator, random, BoundingBox.infinite(), blockpos, p_59423_);
        }
    }

    public static enum JointType implements StringRepresentable
    {
        ROLLABLE("rollable"),
        ALIGNED("aligned");

        private final String name;

        private JointType(String p_59455_) {
            this.name = p_59455_;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static Optional<JointType> byName(String pName) {
            return Arrays.stream(JointType.values()).filter(p_59461_ -> p_59461_.getSerializedName().equals(pName)).findFirst();
        }

        public Component getTranslatedName() {
            return new TranslatableComponent("jigsaw_block.joint." + this.name);
        }
    }
}

