/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class JukeboxBlockEntity
extends BlockEntity
implements Clearable {
    private ItemStack record = ItemStack.EMPTY;

    public JukeboxBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(BlockEntityType.JUKEBOX, pWorldPosition, pBlockState);
    }

    @Override
    public void load(CompoundTag pTag) {
        super.load(pTag);
        if (pTag.contains("RecordItem", 10)) {
            this.setRecord(ItemStack.of(pTag.getCompound("RecordItem")));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag p_187507_) {
        super.saveAdditional(p_187507_);
        if (!this.getRecord().isEmpty()) {
            p_187507_.put("RecordItem", this.getRecord().save(new CompoundTag()));
        }
    }

    public ItemStack getRecord() {
        return this.record;
    }

    public void setRecord(ItemStack pRecord) {
        this.record = pRecord;
        this.setChanged();
    }

    @Override
    public void clearContent() {
        this.setRecord(ItemStack.EMPTY);
    }
}

