/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SkullBlockEntity
extends BlockEntity {
    public static final String TAG_SKULL_OWNER = "SkullOwner";
    @Nullable
    private static GameProfileCache profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;
    @Nullable
    private GameProfile owner;
    private int mouthTickCount;
    private boolean isMovingMouth;

    public SkullBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(BlockEntityType.SKULL, pWorldPosition, pBlockState);
    }

    public static void setup(GameProfileCache p_196701_, MinecraftSessionService p_196702_, Executor p_196703_) {
        profileCache = p_196701_;
        sessionService = p_196702_;
        mainThreadExecutor = p_196703_;
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }

    @Override
    protected void saveAdditional(CompoundTag p_187518_) {
        super.saveAdditional(p_187518_);
        if (this.owner != null) {
            CompoundTag compoundtag = new CompoundTag();
            NbtUtils.writeGameProfile(compoundtag, this.owner);
            p_187518_.put(TAG_SKULL_OWNER, compoundtag);
        }
    }

    @Override
    public void load(CompoundTag pTag) {
        String s;
        super.load(pTag);
        if (pTag.contains(TAG_SKULL_OWNER, 10)) {
            this.setOwner(NbtUtils.readGameProfile(pTag.getCompound(TAG_SKULL_OWNER)));
        } else if (pTag.contains("ExtraType", 8) && !StringUtil.isNullOrEmpty(s = pTag.getString("ExtraType"))) {
            this.setOwner(new GameProfile(null, s));
        }
    }

    public static void dragonHeadAnimation(Level pLevel, BlockPos pPos, BlockState pState, SkullBlockEntity pBlockEntity) {
        if (pLevel.hasNeighborSignal(pPos)) {
            pBlockEntity.isMovingMouth = true;
            ++pBlockEntity.mouthTickCount;
        } else {
            pBlockEntity.isMovingMouth = false;
        }
    }

    public float getMouthAnimation(float pPartialTicks) {
        return this.isMovingMouth ? (float)this.mouthTickCount + pPartialTicks : (float)this.mouthTickCount;
    }

    @Nullable
    public GameProfile getOwnerProfile() {
        return this.owner;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile pOwner) {
        SkullBlockEntity skullBlockEntity = this;
        synchronized (skullBlockEntity) {
            this.owner = pOwner;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        SkullBlockEntity.updateGameprofile(this.owner, p_155747_ -> {
            this.owner = p_155747_;
            this.setChanged();
        });
    }

    public static void updateGameprofile(@Nullable GameProfile p_155739_, Consumer<GameProfile> p_155740_) {
        if (!(p_155739_ == null || StringUtil.isNullOrEmpty(p_155739_.getName()) || p_155739_.isComplete() && p_155739_.getProperties().containsKey((Object)"textures") || profileCache == null || sessionService == null)) {
            profileCache.getAsync(p_155739_.getName(), p_182470_ -> Util.backgroundExecutor().execute(() -> Util.ifElse(p_182470_, p_182479_ -> {
                Property property = (Property)Iterables.getFirst((Iterable)p_182479_.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    p_182479_ = sessionService.fillProfileProperties(p_182479_, true);
                }
                GameProfile gameprofile = p_182479_;
                mainThreadExecutor.execute(() -> {
                    profileCache.add(gameprofile);
                    p_155740_.accept(gameprofile);
                });
            }, () -> mainThreadExecutor.execute(() -> p_155740_.accept(p_155739_)))));
        } else {
            p_155740_.accept(p_155739_);
        }
    }
}

