/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class TheEndGatewayBlockEntity
extends TheEndPortalBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SPAWN_TIME = 200;
    private static final int COOLDOWN_TIME = 40;
    private static final int ATTENTION_INTERVAL = 2400;
    private static final int EVENT_COOLDOWN = 1;
    private static final int GATEWAY_HEIGHT_ABOVE_SURFACE = 10;
    private long age;
    private int teleportCooldown;
    @Nullable
    private BlockPos exitPortal;
    private boolean exactTeleport;

    public TheEndGatewayBlockEntity(BlockPos p_155813_, BlockState p_155814_) {
        super(BlockEntityType.END_GATEWAY, p_155813_, p_155814_);
    }

    @Override
    protected void saveAdditional(CompoundTag p_187527_) {
        super.saveAdditional(p_187527_);
        p_187527_.putLong("Age", this.age);
        if (this.exitPortal != null) {
            p_187527_.put("ExitPortal", NbtUtils.writeBlockPos(this.exitPortal));
        }
        if (this.exactTeleport) {
            p_187527_.putBoolean("ExactTeleport", true);
        }
    }

    @Override
    public void load(CompoundTag pTag) {
        BlockPos blockpos;
        super.load(pTag);
        this.age = pTag.getLong("Age");
        if (pTag.contains("ExitPortal", 10) && Level.isInSpawnableBounds(blockpos = NbtUtils.readBlockPos(pTag.getCompound("ExitPortal")))) {
            this.exitPortal = blockpos;
        }
        this.exactTeleport = pTag.getBoolean("ExactTeleport");
    }

    public static void beamAnimationTick(Level pLevel, BlockPos pPos, BlockState pState, TheEndGatewayBlockEntity pBlockEntity) {
        ++pBlockEntity.age;
        if (pBlockEntity.isCoolingDown()) {
            --pBlockEntity.teleportCooldown;
        }
    }

    public static void teleportTick(Level pLevel, BlockPos pPos, BlockState pState, TheEndGatewayBlockEntity pBlockEntity) {
        boolean flag = pBlockEntity.isSpawning();
        boolean flag1 = pBlockEntity.isCoolingDown();
        ++pBlockEntity.age;
        if (flag1) {
            --pBlockEntity.teleportCooldown;
        } else {
            List<Entity> list = pLevel.getEntitiesOfClass(Entity.class, new AABB(pPos), TheEndGatewayBlockEntity::canEntityTeleport);
            if (!list.isEmpty()) {
                TheEndGatewayBlockEntity.teleportEntity(pLevel, pPos, pState, list.get(pLevel.random.nextInt(list.size())), pBlockEntity);
            }
            if (pBlockEntity.age % 2400L == 0L) {
                TheEndGatewayBlockEntity.triggerCooldown(pLevel, pPos, pState, pBlockEntity);
            }
        }
        if (flag != pBlockEntity.isSpawning() || flag1 != pBlockEntity.isCoolingDown()) {
            TheEndGatewayBlockEntity.setChanged(pLevel, pPos, pState);
        }
    }

    public static boolean canEntityTeleport(Entity p_59941_) {
        return EntitySelector.NO_SPECTATORS.test(p_59941_) && !p_59941_.getRootVehicle().isOnPortalCooldown();
    }

    public boolean isSpawning() {
        return this.age < 200L;
    }

    public boolean isCoolingDown() {
        return this.teleportCooldown > 0;
    }

    public float getSpawnPercent(float pPartialTicks) {
        return Mth.clamp(((float)this.age + pPartialTicks) / 200.0f, 0.0f, 1.0f);
    }

    public float getCooldownPercent(float pPartialTicks) {
        return 1.0f - Mth.clamp(((float)this.teleportCooldown - pPartialTicks) / 40.0f, 0.0f, 1.0f);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    private static void triggerCooldown(Level pLevel, BlockPos pPos, BlockState pState, TheEndGatewayBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide) {
            pBlockEntity.teleportCooldown = 40;
            pLevel.blockEvent(pPos, pState.getBlock(), 1, 0);
            TheEndGatewayBlockEntity.setChanged(pLevel, pPos, pState);
        }
    }

    @Override
    public boolean triggerEvent(int pId, int pType) {
        if (pId == 1) {
            this.teleportCooldown = 40;
            return true;
        }
        return super.triggerEvent(pId, pType);
    }

    public static void teleportEntity(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity, TheEndGatewayBlockEntity pBlockEntity) {
        if (pLevel instanceof ServerLevel && !pBlockEntity.isCoolingDown()) {
            ServerLevel serverlevel = (ServerLevel)pLevel;
            pBlockEntity.teleportCooldown = 100;
            if (pBlockEntity.exitPortal == null && pLevel.dimension() == Level.END) {
                BlockPos blockpos = TheEndGatewayBlockEntity.findOrCreateValidTeleportPos(serverlevel, pPos);
                blockpos = blockpos.above(10);
                LOGGER.debug("Creating portal at {}", (Object)blockpos);
                TheEndGatewayBlockEntity.spawnGatewayPortal(serverlevel, blockpos, EndGatewayConfiguration.knownExit(pPos, false));
                pBlockEntity.exitPortal = blockpos;
            }
            if (pBlockEntity.exitPortal != null) {
                Entity entity;
                BlockPos blockpos1;
                BlockPos blockPos = blockpos1 = pBlockEntity.exactTeleport ? pBlockEntity.exitPortal : TheEndGatewayBlockEntity.findExitPosition(pLevel, pBlockEntity.exitPortal);
                if (pEntity instanceof ThrownEnderpearl) {
                    Entity entity1 = ((ThrownEnderpearl)pEntity).getOwner();
                    if (entity1 instanceof ServerPlayer) {
                        CriteriaTriggers.ENTER_BLOCK.trigger((ServerPlayer)entity1, pState);
                    }
                    if (entity1 != null) {
                        entity = entity1;
                        pEntity.discard();
                    } else {
                        entity = pEntity;
                    }
                } else {
                    entity = pEntity.getRootVehicle();
                }
                entity.setPortalCooldown();
                entity.teleportToWithTicket((double)blockpos1.getX() + 0.5, blockpos1.getY(), (double)blockpos1.getZ() + 0.5);
            }
            TheEndGatewayBlockEntity.triggerCooldown(pLevel, pPos, pState, pBlockEntity);
        }
    }

    private static BlockPos findExitPosition(Level pLevel, BlockPos pPos) {
        BlockPos blockpos = TheEndGatewayBlockEntity.findTallestBlock(pLevel, pPos.offset(0, 2, 0), 5, false);
        LOGGER.debug("Best exit position for portal at {} is {}", (Object)pPos, (Object)blockpos);
        return blockpos.above();
    }

    private static BlockPos findOrCreateValidTeleportPos(ServerLevel pLevel, BlockPos pPos) {
        Vec3 vec3 = TheEndGatewayBlockEntity.findExitPortalXZPosTentative(pLevel, pPos);
        LevelChunk levelchunk = TheEndGatewayBlockEntity.getChunk(pLevel, vec3);
        BlockPos blockpos = TheEndGatewayBlockEntity.findValidSpawnInChunk(levelchunk);
        if (blockpos == null) {
            blockpos = new BlockPos(vec3.x + 0.5, 75.0, vec3.z + 0.5);
            LOGGER.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockpos);
            EndFeatures.END_ISLAND.value().place(pLevel, pLevel.getChunkSource().getGenerator(), new Random(blockpos.asLong()), blockpos);
        } else {
            LOGGER.debug("Found suitable block to teleport to: {}", (Object)blockpos);
        }
        return TheEndGatewayBlockEntity.findTallestBlock(pLevel, blockpos, 16, true);
    }

    private static Vec3 findExitPortalXZPosTentative(ServerLevel pLevel, BlockPos pPos) {
        Vec3 vec3 = new Vec3(pPos.getX(), 0.0, pPos.getZ()).normalize();
        int i = 1024;
        Vec3 vec31 = vec3.scale(1024.0);
        int j = 16;
        while (!TheEndGatewayBlockEntity.isChunkEmpty(pLevel, vec31) && j-- > 0) {
            LOGGER.debug("Skipping backwards past nonempty chunk at {}", (Object)vec31);
            vec31 = vec31.add(vec3.scale(-16.0));
        }
        int k = 16;
        while (TheEndGatewayBlockEntity.isChunkEmpty(pLevel, vec31) && k-- > 0) {
            LOGGER.debug("Skipping forward past empty chunk at {}", (Object)vec31);
            vec31 = vec31.add(vec3.scale(16.0));
        }
        LOGGER.debug("Found chunk at {}", (Object)vec31);
        return vec31;
    }

    private static boolean isChunkEmpty(ServerLevel p_155816_, Vec3 p_155817_) {
        return TheEndGatewayBlockEntity.getChunk(p_155816_, p_155817_).getHighestSectionPosition() <= p_155816_.getMinBuildHeight();
    }

    private static BlockPos findTallestBlock(BlockGetter pLevel, BlockPos pPos, int pRadius, boolean pAllowBedrock) {
        Vec3i blockpos = null;
        int i = -pRadius;
        while (i <= pRadius) {
            int j = -pRadius;
            while (j <= pRadius) {
                if (i != 0 || j != 0 || pAllowBedrock) {
                    int k = pLevel.getMaxBuildHeight() - 1;
                    while (k > (blockpos == null ? pLevel.getMinBuildHeight() : blockpos.getY())) {
                        BlockPos blockpos1 = new BlockPos(pPos.getX() + i, k, pPos.getZ() + j);
                        BlockState blockstate = pLevel.getBlockState(blockpos1);
                        if (blockstate.isCollisionShapeFullBlock(pLevel, blockpos1) && (pAllowBedrock || !blockstate.is(Blocks.BEDROCK))) {
                            blockpos = blockpos1;
                            break;
                        }
                        --k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return blockpos == null ? pPos : blockpos;
    }

    private static LevelChunk getChunk(Level p_59948_, Vec3 p_59949_) {
        return p_59948_.getChunk(Mth.floor(p_59949_.x / 16.0), Mth.floor(p_59949_.z / 16.0));
    }

    @Nullable
    private static BlockPos findValidSpawnInChunk(LevelChunk pChunk) {
        ChunkPos chunkpos = pChunk.getPos();
        BlockPos blockpos = new BlockPos(chunkpos.getMinBlockX(), 30, chunkpos.getMinBlockZ());
        int i = pChunk.getHighestSectionPosition() + 16 - 1;
        BlockPos blockpos1 = new BlockPos(chunkpos.getMaxBlockX(), i, chunkpos.getMaxBlockZ());
        BlockPos blockpos2 = null;
        double d0 = 0.0;
        for (BlockPos blockpos3 : BlockPos.betweenClosed(blockpos, blockpos1)) {
            BlockState blockstate = pChunk.getBlockState(blockpos3);
            BlockPos blockpos4 = blockpos3.above();
            BlockPos blockpos5 = blockpos3.above(2);
            if (!blockstate.is(Blocks.END_STONE) || pChunk.getBlockState(blockpos4).isCollisionShapeFullBlock(pChunk, blockpos4) || pChunk.getBlockState(blockpos5).isCollisionShapeFullBlock(pChunk, blockpos5)) continue;
            double d1 = blockpos3.distToCenterSqr(0.0, 0.0, 0.0);
            if (blockpos2 != null && !(d1 < d0)) continue;
            blockpos2 = blockpos3;
            d0 = d1;
        }
        return blockpos2;
    }

    private static void spawnGatewayPortal(ServerLevel p_155822_, BlockPos p_155823_, EndGatewayConfiguration p_155824_) {
        Feature.END_GATEWAY.place(p_155824_, p_155822_, p_155822_.getChunkSource().getGenerator(), new Random(), p_155823_);
    }

    @Override
    public boolean shouldRenderFace(Direction pFace) {
        return Block.shouldRenderFace(this.getBlockState(), this.level, this.getBlockPos(), pFace, this.getBlockPos().relative(pFace));
    }

    public int getParticleAmount() {
        int i = 0;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            i += this.shouldRenderFace(direction) ? 1 : 0;
            ++n2;
        }
        return i;
    }

    public void setExitPosition(BlockPos p_59956_, boolean p_59957_) {
        this.exactTeleport = p_59957_;
        this.exitPortal = p_59956_;
    }
}

