/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PistonBaseBlock
extends DirectionalBlock {
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;
    public static final int TRIGGER_EXTEND = 0;
    public static final int TRIGGER_CONTRACT = 1;
    public static final int TRIGGER_DROP = 2;
    public static final float PLATFORM_THICKNESS = 4.0f;
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape WEST_AABB = Block.box(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape UP_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean isSticky;

    public PistonBaseBlock(boolean pIsSticky, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(EXTENDED, false));
        this.isSticky = pIsSticky;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue(EXTENDED).booleanValue()) {
            switch (pState.getValue(FACING)) {
                case DOWN: {
                    return DOWN_AABB;
                }
                default: {
                    return UP_AABB;
                }
                case NORTH: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }
        return Shapes.block();
    }

    @Override
    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        if (!pLevel.isClientSide) {
            this.checkIfExtend(pLevel, pPos, pState);
        }
    }

    @Override
    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            this.checkIfExtend(pLevel, pPos, pState);
        }
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.is(pState.getBlock()) && !pLevel.isClientSide && pLevel.getBlockEntity(pPos) == null) {
            this.checkIfExtend(pLevel, pPos, pState);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, pContext.getNearestLookingDirection().getOpposite())).setValue(EXTENDED, false);
    }

    private void checkIfExtend(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = pState.getValue(FACING);
        boolean flag = this.getNeighborSignal(pLevel, pPos, direction);
        if (flag && !pState.getValue(EXTENDED).booleanValue()) {
            if (new PistonStructureResolver(pLevel, pPos, direction, true).resolve()) {
                pLevel.blockEvent(pPos, this, 0, direction.get3DDataValue());
            }
        } else if (!flag && pState.getValue(EXTENDED).booleanValue()) {
            PistonMovingBlockEntity pistonmovingblockentity;
            BlockEntity blockentity;
            BlockPos blockpos = pPos.relative(direction, 2);
            BlockState blockstate = pLevel.getBlockState(blockpos);
            int i = 1;
            if (blockstate.is(Blocks.MOVING_PISTON) && blockstate.getValue(FACING) == direction && (blockentity = pLevel.getBlockEntity(blockpos)) instanceof PistonMovingBlockEntity && (pistonmovingblockentity = (PistonMovingBlockEntity)blockentity).isExtending() && (pistonmovingblockentity.getProgress(0.0f) < 0.5f || pLevel.getGameTime() == pistonmovingblockentity.getLastTicked() || ((ServerLevel)pLevel).isHandlingTick())) {
                i = 2;
            }
            pLevel.blockEvent(pPos, this, i, direction.get3DDataValue());
        }
    }

    private boolean getNeighborSignal(Level pLevel, BlockPos pPos, Direction pFacing) {
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (direction != pFacing && pLevel.hasSignal(pPos.relative(direction), direction)) {
                return true;
            }
            ++n2;
        }
        if (pLevel.hasSignal(pPos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pPos.above();
        Direction[] directionArray2 = Direction.values();
        int n3 = directionArray2.length;
        n = 0;
        while (n < n3) {
            Direction direction1 = directionArray2[n];
            if (direction1 != Direction.DOWN && pLevel.hasSignal(blockpos.relative(direction1), direction1)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean triggerEvent(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        Direction direction = pState.getValue(FACING);
        if (!pLevel.isClientSide) {
            boolean flag = this.getNeighborSignal(pLevel, pPos, direction);
            if (flag && (pId == 1 || pId == 2)) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(EXTENDED, true), 2);
                return false;
            }
            if (!flag && pId == 0) {
                return false;
            }
        }
        if (pId == 0) {
            if (!this.moveBlocks(pLevel, pPos, direction, true)) {
                return false;
            }
            pLevel.setBlock(pPos, (BlockState)pState.setValue(EXTENDED, true), 67);
            pLevel.playSound(null, pPos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, pLevel.random.nextFloat() * 0.25f + 0.6f);
            pLevel.gameEvent(GameEvent.PISTON_EXTEND, pPos);
        } else if (pId == 1 || pId == 2) {
            BlockEntity blockentity1 = pLevel.getBlockEntity(pPos.relative(direction));
            if (blockentity1 instanceof PistonMovingBlockEntity) {
                ((PistonMovingBlockEntity)blockentity1).finalTick();
            }
            BlockState blockstate = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, direction)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            pLevel.setBlock(pPos, blockstate, 20);
            pLevel.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(pPos, blockstate, (BlockState)this.defaultBlockState().setValue(FACING, Direction.from3DDataValue(pParam & 7)), direction, false, true));
            pLevel.blockUpdated(pPos, blockstate.getBlock());
            blockstate.updateNeighbourShapes(pLevel, pPos, 2);
            if (this.isSticky) {
                PistonMovingBlockEntity pistonmovingblockentity;
                BlockEntity blockentity;
                BlockPos blockpos = pPos.offset(direction.getStepX() * 2, direction.getStepY() * 2, direction.getStepZ() * 2);
                BlockState blockstate1 = pLevel.getBlockState(blockpos);
                boolean flag1 = false;
                if (blockstate1.is(Blocks.MOVING_PISTON) && (blockentity = pLevel.getBlockEntity(blockpos)) instanceof PistonMovingBlockEntity && (pistonmovingblockentity = (PistonMovingBlockEntity)blockentity).getDirection() == direction && pistonmovingblockentity.isExtending()) {
                    pistonmovingblockentity.finalTick();
                    flag1 = true;
                }
                if (!flag1) {
                    if (pId != 1 || blockstate1.isAir() || !PistonBaseBlock.isPushable(blockstate1, pLevel, blockpos, direction.getOpposite(), false, direction) || blockstate1.getPistonPushReaction() != PushReaction.NORMAL && !blockstate1.is(Blocks.PISTON) && !blockstate1.is(Blocks.STICKY_PISTON)) {
                        pLevel.removeBlock(pPos.relative(direction), false);
                    } else {
                        this.moveBlocks(pLevel, pPos, direction, false);
                    }
                }
            } else {
                pLevel.removeBlock(pPos.relative(direction), false);
            }
            pLevel.playSound(null, pPos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, pLevel.random.nextFloat() * 0.15f + 0.6f);
            pLevel.gameEvent(GameEvent.PISTON_CONTRACT, pPos);
        }
        return true;
    }

    public static boolean isPushable(BlockState pBlockState, Level pLevel, BlockPos pPos, Direction pFacing, boolean pDestroyBlocks, Direction pDirection) {
        if (pPos.getY() >= pLevel.getMinBuildHeight() && pPos.getY() <= pLevel.getMaxBuildHeight() - 1 && pLevel.getWorldBorder().isWithinBounds(pPos)) {
            if (pBlockState.isAir()) {
                return true;
            }
            if (!(pBlockState.is(Blocks.OBSIDIAN) || pBlockState.is(Blocks.CRYING_OBSIDIAN) || pBlockState.is(Blocks.RESPAWN_ANCHOR))) {
                if (pFacing == Direction.DOWN && pPos.getY() == pLevel.getMinBuildHeight()) {
                    return false;
                }
                if (pFacing == Direction.UP && pPos.getY() == pLevel.getMaxBuildHeight() - 1) {
                    return false;
                }
                if (!pBlockState.is(Blocks.PISTON) && !pBlockState.is(Blocks.STICKY_PISTON)) {
                    if (pBlockState.getDestroySpeed(pLevel, pPos) == -1.0f) {
                        return false;
                    }
                    switch (pBlockState.getPistonPushReaction()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return pDestroyBlocks;
                        }
                        case PUSH_ONLY: {
                            return pFacing == pDirection;
                        }
                    }
                } else if (pBlockState.getValue(EXTENDED).booleanValue()) {
                    return false;
                }
                return !pBlockState.hasBlockEntity();
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean moveBlocks(Level pLevel, BlockPos pPos, Direction pDirection, boolean pExtending) {
        void var15_31;
        void var15_29;
        PistonStructureResolver pistonstructureresolver;
        BlockPos blockpos = pPos.relative(pDirection);
        if (!pExtending && pLevel.getBlockState(blockpos).is(Blocks.PISTON_HEAD)) {
            pLevel.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 20);
        }
        if (!(pistonstructureresolver = new PistonStructureResolver(pLevel, pPos, pDirection, pExtending)).resolve()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPos> list = pistonstructureresolver.getToPush();
        ArrayList list1 = Lists.newArrayList();
        int i = 0;
        while (i < list.size()) {
            BlockPos blockpos1 = list.get(i);
            BlockState blockstate = pLevel.getBlockState(blockpos1);
            list1.add(blockstate);
            map.put(blockpos1, blockstate);
            ++i;
        }
        List<BlockPos> list2 = pistonstructureresolver.getToDestroy();
        BlockState[] ablockstate = new BlockState[list.size() + list2.size()];
        Direction direction = pExtending ? pDirection : pDirection.getOpposite();
        int j = 0;
        int k = list2.size() - 1;
        while (k >= 0) {
            BlockPos blockPos = list2.get(k);
            BlockState blockstate1 = pLevel.getBlockState(blockPos);
            BlockEntity blockentity = blockstate1.hasBlockEntity() ? pLevel.getBlockEntity(blockPos) : null;
            PistonBaseBlock.dropResources(blockstate1, pLevel, blockPos, blockentity);
            pLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 18);
            if (!blockstate1.is(BlockTags.FIRE)) {
                pLevel.addDestroyBlockEffect(blockPos, blockstate1);
            }
            ablockstate[j++] = blockstate1;
            --k;
        }
        int l = list.size() - 1;
        while (l >= 0) {
            BlockPos blockPos = list.get(l);
            BlockState blockstate5 = pLevel.getBlockState(blockPos);
            BlockPos blockPos2 = blockPos.relative(direction);
            map.remove(blockPos2);
            BlockState blockstate8 = (BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(FACING, pDirection);
            pLevel.setBlock(blockPos2, blockstate8, 68);
            pLevel.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(blockPos2, blockstate8, (BlockState)list1.get(l), pDirection, pExtending, false));
            ablockstate[j++] = blockstate5;
            --l;
        }
        if (pExtending) {
            PistonType pistontype = this.isSticky ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState blockState = (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.FACING, pDirection)).setValue(PistonHeadBlock.TYPE, pistontype);
            BlockState blockstate6 = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, pDirection)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            map.remove(blockpos);
            pLevel.setBlock(blockpos, blockstate6, 68);
            pLevel.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(blockpos, blockstate6, blockState, pDirection, true, true));
        }
        BlockState blockstate3 = Blocks.AIR.defaultBlockState();
        for (BlockPos blockPos : map.keySet()) {
            pLevel.setBlock(blockPos, blockstate3, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos5 = (BlockPos)entry.getKey();
            BlockState blockstate2 = (BlockState)entry.getValue();
            blockstate2.updateIndirectNeighbourShapes(pLevel, blockpos5, 2);
            blockstate3.updateNeighbourShapes(pLevel, blockpos5, 2);
            blockstate3.updateIndirectNeighbourShapes(pLevel, blockpos5, 2);
        }
        j = 0;
        int n = list2.size() - 1;
        while (var15_29 >= 0) {
            BlockState blockstate7 = ablockstate[j++];
            BlockPos blockpos6 = list2.get((int)var15_29);
            blockstate7.updateIndirectNeighbourShapes(pLevel, blockpos6, 2);
            pLevel.updateNeighborsAt(blockpos6, blockstate7.getBlock());
            --var15_29;
        }
        int n2 = list.size() - 1;
        while (var15_31 >= 0) {
            pLevel.updateNeighborsAt(list.get((int)var15_31), ablockstate[j++].getBlock());
            --var15_31;
        }
        if (pExtending) {
            pLevel.updateNeighborsAt(blockpos, Blocks.PISTON_HEAD);
        }
        return true;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue(FACING, pRot.rotate(pState.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation(pState.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.a(FACING, EXTENDED);
    }

    @Override
    public boolean useShapeForLightOcclusion(BlockState pState) {
        return pState.getValue(EXTENDED);
    }

    @Override
    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

