/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public class StateDefinition<O, S extends StateHolder<O, S>> {
    static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    private final O owner;
    private final ImmutableSortedMap<String, Property<?>> propertiesByName;
    private final ImmutableList<S> states;

    protected StateDefinition(Function<O, S> p_61052_, O p_61053_, Factory<O, S> p_61054_, Map<String, Property<?>> p_61055_) {
        this.owner = p_61053_;
        this.propertiesByName = ImmutableSortedMap.copyOf(p_61055_);
        Supplier<StateHolder> supplier = () -> (StateHolder)p_61052_.apply(p_61053_);
        MapCodec<StateHolder> mapcodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(supplier));
        for (Map.Entry entry : this.propertiesByName.entrySet()) {
            mapcodec = StateDefinition.appendPropertyCodec(mapcodec, supplier, (String)entry.getKey(), (Property)entry.getValue());
        }
        MapCodec<StateHolder> mapcodec1 = mapcodec;
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList list = Lists.newArrayList();
        Stream<List<List<Object>>> stream = Stream.of(Collections.emptyList());
        for (Property property : this.propertiesByName.values()) {
            stream = stream.flatMap(p_61072_ -> property.getPossibleValues().stream().map(p_155961_ -> {
                ArrayList list1 = Lists.newArrayList((Iterable)p_61072_);
                list1.add(Pair.of((Object)property, (Object)((Comparable)p_155961_)));
                return list1;
            }));
        }
        stream.forEach(p_61063_ -> {
            ImmutableMap immutablemap = (ImmutableMap)p_61063_.stream().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
            StateHolder s1 = (StateHolder)p_61054_.create(p_61053_, immutablemap, mapcodec1);
            map.put(immutablemap, s1);
            list.add(s1);
        });
        for (StateHolder s : list) {
            s.populateNeighbours(map);
        }
        this.states = ImmutableList.copyOf((Collection)list);
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> MapCodec<S> appendPropertyCodec(MapCodec<S> p_61077_, Supplier<S> p_61078_, String p_61079_, Property<T> p_61080_) {
        return Codec.mapPair(p_61077_, (MapCodec)p_61080_.valueCodec().fieldOf(p_61079_).orElseGet(p_187541_ -> {}, () -> p_61080_.value((StateHolder)p_61078_.get()))).xmap(p_187536_ -> (StateHolder)((StateHolder)p_187536_.getFirst()).setValue(p_61080_, ((Property.Value)p_187536_.getSecond()).value()), p_187533_ -> Pair.of((Object)p_187533_, p_61080_.value((StateHolder<?, ?>)p_187533_)));
    }

    public ImmutableList<S> getPossibleStates() {
        return this.states;
    }

    public S any() {
        return (S)((StateHolder)this.states.get(0));
    }

    public O getOwner() {
        return this.owner;
    }

    public Collection<Property<?>> getProperties() {
        return this.propertiesByName.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.owner).add("properties", this.propertiesByName.values().stream().map(Property::getName).collect(Collectors.toList())).toString();
    }

    @Nullable
    public Property<?> getProperty(String pPropertyName) {
        return (Property)this.propertiesByName.get((Object)pPropertyName);
    }

    public static class Builder<O, S extends StateHolder<O, S>> {
        private final O owner;
        private final Map<String, Property<?>> properties = Maps.newHashMap();

        public Builder(O pOwner) {
            this.owner = pOwner;
        }

        public Builder<O, S> a(Property<?> ... p_61105_) {
            Property<?>[] propertyArray = p_61105_;
            int n = p_61105_.length;
            int n2 = 0;
            while (n2 < n) {
                Property<?> property = propertyArray[n2];
                this.validateProperty(property);
                this.properties.put(property.getName(), property);
                ++n2;
            }
            return this;
        }

        private <T extends Comparable<T>> void validateProperty(Property<T> pProperty) {
            String s = pProperty.getName();
            if (!NAME_PATTERN.matcher(s).matches()) {
                throw new IllegalArgumentException(this.owner + " has invalidly named property: " + s);
            }
            Collection<T> collection = pProperty.getPossibleValues();
            if (collection.size() <= 1) {
                throw new IllegalArgumentException(this.owner + " attempted use property " + s + " with <= 1 possible values");
            }
            for (Comparable t : collection) {
                String s1 = pProperty.getName(t);
                if (NAME_PATTERN.matcher(s1).matches()) continue;
                throw new IllegalArgumentException(this.owner + " has property: " + s + " with invalidly named value: " + s1);
            }
            if (this.properties.containsKey(s)) {
                throw new IllegalArgumentException(this.owner + " has duplicate property: " + s);
            }
        }

        public StateDefinition<O, S> create(Function<O, S> p_61102_, Factory<O, S> p_61103_) {
            return new StateDefinition<O, S>(p_61102_, this.owner, p_61103_, this.properties);
        }
    }

    public static interface Factory<O, S> {
        public S create(O var1, ImmutableMap<Property<?>, Comparable<?>> var2, MapCodec<S> var3);
    }
}

