/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class StateHolder<O, S> {
    public static final String NAME_TAG = "Name";
    public static final String PROPERTIES_TAG = "Properties";
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_ENTRY_TO_STRING_FUNCTION = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> p_61155_) {
            if (p_61155_ == null) {
                return "<NULL>";
            }
            Property<?> property = p_61155_.getKey();
            return String.valueOf(property.getName()) + "=" + this.getName(property, p_61155_.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> p_61152_, Comparable<?> p_61153_) {
            return p_61152_.getName(p_61153_);
        }
    };
    protected final O owner;
    private final ImmutableMap<Property<?>, Comparable<?>> values;
    private Table<Property<?>, Comparable<?>, S> neighbours;
    protected final MapCodec<S> propertiesCodec;

    protected StateHolder(O pOwner, ImmutableMap<Property<?>, Comparable<?>> pValues, MapCodec<S> pPropertiesCodec) {
        this.owner = pOwner;
        this.values = pValues;
        this.propertiesCodec = pPropertiesCodec;
    }

    public <T extends Comparable<T>> S cycle(Property<T> pProperty) {
        return this.setValue(pProperty, (Comparable)StateHolder.findNextInCollection(pProperty.getPossibleValues(), this.getValue(pProperty)));
    }

    protected static <T> T findNextInCollection(Collection<T> pCollection, T pValue) {
        Iterator<T> iterator = pCollection.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(pValue)) continue;
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return pCollection.iterator().next();
        }
        return iterator.next();
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(this.owner);
        if (!this.getValues().isEmpty()) {
            stringbuilder.append('[');
            stringbuilder.append(this.getValues().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    public Collection<Property> getProperties() {
        return Collections.unmodifiableCollection(this.values.keySet());
    }

    public <T extends Comparable<T>> boolean hasProperty(Property<T> pProperty) {
        return this.values.containsKey(pProperty);
    }

    public <T extends Comparable<T>> T getValue(Property<T> pProperty) {
        Comparable comparable = (Comparable)this.values.get(pProperty);
        if (comparable == null) {
            throw new IllegalArgumentException("Cannot get property " + pProperty + " as it does not exist in " + this.owner);
        }
        return (T)((Comparable)pProperty.getValueClass().cast(comparable));
    }

    public <T extends Comparable<T>> Optional<T> getOptionalValue(Property<T> pProperty) {
        Comparable comparable = (Comparable)this.values.get(pProperty);
        return comparable == null ? Optional.empty() : Optional.of((Comparable)pProperty.getValueClass().cast(comparable));
    }

    public <T extends Comparable<T>, V extends T> S setValue(Property<T> pProperty, V pValue) {
        Comparable comparable = (Comparable)this.values.get(pProperty);
        if (comparable == null) {
            throw new IllegalArgumentException("Cannot set property " + pProperty + " as it does not exist in " + this.owner);
        }
        if (comparable == pValue) {
            return (S)this;
        }
        Object s = this.neighbours.get(pProperty, pValue);
        if (s == null) {
            throw new IllegalArgumentException("Cannot set property " + pProperty + " to " + pValue + " on " + this.owner + ", it is not an allowed value");
        }
        return (S)s;
    }

    public void populateNeighbours(Map<Map<Property<?>, Comparable<?>>, S> p_61134_) {
        if (this.neighbours != null) {
            throw new IllegalStateException();
        }
        HashBasedTable table = HashBasedTable.create();
        for (Map.Entry entry : this.values.entrySet()) {
            Property property = (Property)entry.getKey();
            for (Comparable comparable : property.getPossibleValues()) {
                if (comparable == entry.getValue()) continue;
                table.put((Object)property, (Object)comparable, p_61134_.get(this.makeNeighbourValues(property, comparable)));
            }
        }
        this.neighbours = table.isEmpty() ? table : ArrayTable.create((Table)table);
    }

    private Map<Property<?>, Comparable<?>> makeNeighbourValues(Property<?> p_61141_, Comparable<?> p_61142_) {
        HashMap map = Maps.newHashMap(this.values);
        map.put(p_61141_, p_61142_);
        return map;
    }

    public ImmutableMap<Property<?>, Comparable<?>> getValues() {
        return this.values;
    }

    protected static <O, S extends StateHolder<O, S>> Codec<S> codec(Codec<O> p_61128_, Function<O, S> p_61129_) {
        return p_61128_.dispatch(NAME_TAG, p_61121_ -> p_61121_.owner, p_187547_ -> {
            StateHolder s = (StateHolder)p_61129_.apply(p_187547_);
            return s.getValues().isEmpty() ? Codec.unit((Object)s) : s.propertiesCodec.codec().optionalFieldOf(PROPERTIES_TAG).xmap(p_187544_ -> p_187544_.orElse(s), Optional::of).codec();
        });
    }
}

