/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class BlockPattern {
    private final Predicate<BlockInWorld>[][][] pattern;
    private final int depth;
    private final int height;
    private final int width;

    public BlockPattern(Predicate<BlockInWorld>[][][] pPattern) {
        this.pattern = pPattern;
        this.depth = pPattern.length;
        if (this.depth > 0) {
            this.height = pPattern[0].length;
            this.width = this.height > 0 ? pPattern[0][0].length : 0;
        } else {
            this.height = 0;
            this.width = 0;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @VisibleForTesting
    public Predicate<BlockInWorld>[][][] getPattern() {
        return this.pattern;
    }

    @Nullable
    @VisibleForTesting
    public BlockPatternMatch matches(LevelReader pPos, BlockPos pFinger, Direction pThumb, Direction pCache) {
        LoadingCache<BlockPos, BlockInWorld> loadingcache = BlockPattern.createLevelCache(pPos, false);
        return this.matches(pFinger, pThumb, pCache, loadingcache);
    }

    @Nullable
    private BlockPatternMatch matches(BlockPos pPos, Direction pFinger, Direction pThumb, LoadingCache<BlockPos, BlockInWorld> pCache) {
        int i = 0;
        while (i < this.width) {
            int j = 0;
            while (j < this.height) {
                int k = 0;
                while (k < this.depth) {
                    if (!this.pattern[k][j][i].test((BlockInWorld)pCache.getUnchecked((Object)BlockPattern.translateAndRotate(pPos, pFinger, pThumb, i, j, k)))) {
                        return null;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return new BlockPatternMatch(pPos, pFinger, pThumb, pCache, this.width, this.height, this.depth);
    }

    @Nullable
    public BlockPatternMatch find(LevelReader pLevel, BlockPos pPos) {
        LoadingCache<BlockPos, BlockInWorld> loadingcache = BlockPattern.createLevelCache(pLevel, false);
        int i = Math.max(Math.max(this.width, this.height), this.depth);
        for (BlockPos blockpos : BlockPos.betweenClosed(pPos, pPos.offset(i - 1, i - 1, i - 1))) {
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direction direction = directionArray[n2];
                Direction[] directionArray2 = Direction.values();
                int n3 = directionArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    BlockPatternMatch blockpattern$blockpatternmatch;
                    Direction direction1 = directionArray2[n4];
                    if (direction1 != direction && direction1 != direction.getOpposite() && (blockpattern$blockpatternmatch = this.matches(blockpos, direction, direction1, loadingcache)) != null) {
                        return blockpattern$blockpatternmatch;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static LoadingCache<BlockPos, BlockInWorld> createLevelCache(LevelReader pLevel, boolean pForceLoad) {
        return CacheBuilder.newBuilder().build((CacheLoader)new BlockCacheLoader(pLevel, pForceLoad));
    }

    protected static BlockPos translateAndRotate(BlockPos pPos, Direction pFinger, Direction pThumb, int pPalmOffset, int pThumbOffset, int pFingerOffset) {
        if (pFinger != pThumb && pFinger != pThumb.getOpposite()) {
            Vec3i vec3i = new Vec3i(pFinger.getStepX(), pFinger.getStepY(), pFinger.getStepZ());
            Vec3i vec3i1 = new Vec3i(pThumb.getStepX(), pThumb.getStepY(), pThumb.getStepZ());
            Vec3i vec3i2 = vec3i.cross(vec3i1);
            return pPos.offset(vec3i1.getX() * -pThumbOffset + vec3i2.getX() * pPalmOffset + vec3i.getX() * pFingerOffset, vec3i1.getY() * -pThumbOffset + vec3i2.getY() * pPalmOffset + vec3i.getY() * pFingerOffset, vec3i1.getZ() * -pThumbOffset + vec3i2.getZ() * pPalmOffset + vec3i.getZ() * pFingerOffset);
        }
        throw new IllegalArgumentException("Invalid forwards & up combination");
    }

    static class BlockCacheLoader
    extends CacheLoader<BlockPos, BlockInWorld> {
        private final LevelReader level;
        private final boolean loadChunks;

        public BlockCacheLoader(LevelReader pLevel, boolean pLoadChunks) {
            this.level = pLevel;
            this.loadChunks = pLoadChunks;
        }

        public BlockInWorld load(BlockPos p_61210_) {
            return new BlockInWorld(this.level, p_61210_, this.loadChunks);
        }
    }

    public static class BlockPatternMatch {
        private final BlockPos frontTopLeft;
        private final Direction forwards;
        private final Direction up;
        private final LoadingCache<BlockPos, BlockInWorld> cache;
        private final int width;
        private final int height;
        private final int depth;

        public BlockPatternMatch(BlockPos pFrontTopLeft, Direction pForwards, Direction pUp, LoadingCache<BlockPos, BlockInWorld> pCache, int pWidth, int pHeight, int pDepth) {
            this.frontTopLeft = pFrontTopLeft;
            this.forwards = pForwards;
            this.up = pUp;
            this.cache = pCache;
            this.width = pWidth;
            this.height = pHeight;
            this.depth = pDepth;
        }

        public BlockPos getFrontTopLeft() {
            return this.frontTopLeft;
        }

        public Direction getForwards() {
            return this.forwards;
        }

        public Direction getUp() {
            return this.up;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }

        public BlockInWorld getBlock(int pPalmOffset, int pThumbOffset, int pFingerOffset) {
            return (BlockInWorld)this.cache.getUnchecked((Object)BlockPattern.translateAndRotate(this.frontTopLeft, this.getForwards(), this.getUp(), pPalmOffset, pThumbOffset, pFingerOffset));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.up).add("forwards", (Object)this.forwards).add("frontTopLeft", (Object)this.frontTopLeft).toString();
        }
    }
}

