/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BlockPatternBuilder {
    private static final Joiner COMMA_JOINED = Joiner.on((String)",");
    private final List<String[]> pattern = Lists.newArrayList();
    private final Map<Character, Predicate<BlockInWorld>> lookup = Maps.newHashMap();
    private int height;
    private int width;

    private BlockPatternBuilder() {
        this.lookup.put(Character.valueOf(' '), p_187549_ -> true);
    }

    public BlockPatternBuilder a(String ... p_61248_) {
        if (!ArrayUtils.isEmpty((Object[])p_61248_) && !StringUtils.isEmpty((CharSequence)p_61248_[0])) {
            if (this.pattern.isEmpty()) {
                this.height = p_61248_.length;
                this.width = p_61248_[0].length();
            }
            if (p_61248_.length != this.height) {
                throw new IllegalArgumentException("Expected aisle with height of " + this.height + ", but was given one with a height of " + p_61248_.length + ")");
            }
            String[] stringArray = p_61248_;
            int n = p_61248_.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.length() != this.width) {
                    throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.width + ", found one with " + s.length() + ")");
                }
                char[] cArray = s.toCharArray();
                int n3 = cArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    char c0 = cArray[n4];
                    if (!this.lookup.containsKey(Character.valueOf(c0))) {
                        this.lookup.put(Character.valueOf(c0), null);
                    }
                    ++n4;
                }
                ++n2;
            }
            this.pattern.add(p_61248_);
            return this;
        }
        throw new IllegalArgumentException("Empty pattern for aisle");
    }

    public static BlockPatternBuilder start() {
        return new BlockPatternBuilder();
    }

    public BlockPatternBuilder where(char pSymbol, Predicate<BlockInWorld> pBlockMatcher) {
        this.lookup.put(Character.valueOf(pSymbol), pBlockMatcher);
        return this;
    }

    public BlockPattern build() {
        return new BlockPattern(this.createPattern());
    }

    private Predicate<BlockInWorld>[][][] createPattern() {
        this.ensureAllCharactersMatched();
        Predicate[][][] predicate = (Predicate[][][])Array.newInstance(Predicate.class, this.pattern.size(), this.height, this.width);
        int i = 0;
        while (i < this.pattern.size()) {
            int j = 0;
            while (j < this.height) {
                int k = 0;
                while (k < this.width) {
                    predicate[i][j][k] = this.lookup.get(Character.valueOf(this.pattern.get(i)[j].charAt(k)));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return predicate;
    }

    private void ensureAllCharactersMatched() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<Character, Predicate<BlockInWorld>> entry : this.lookup.entrySet()) {
            if (entry.getValue() != null) continue;
            list.add(entry.getKey());
        }
        if (!list.isEmpty()) {
            throw new IllegalStateException("Predicates for character(s) " + COMMA_JOINED.join((Iterable)list) + " are missing");
        }
    }
}

