/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.Property;

public class BooleanProperty
extends Property<Boolean> {
    private final ImmutableSet<Boolean> values = ImmutableSet.of((Object)true, (Object)false);

    protected BooleanProperty(String pName) {
        super(pName, Boolean.class);
    }

    @Override
    public Collection<Boolean> getPossibleValues() {
        return this.values;
    }

    public static BooleanProperty create(String pName) {
        return new BooleanProperty(pName);
    }

    @Override
    public Optional<Boolean> getValue(String pValue) {
        return !"true".equals(pValue) && !"false".equals(pValue) ? Optional.empty() : Optional.of(Boolean.valueOf(pValue));
    }

    @Override
    public String getName(Boolean pValue) {
        return pValue.toString();
    }

    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof BooleanProperty && super.equals(pOther)) {
            BooleanProperty booleanproperty = (BooleanProperty)pOther;
            return this.values.equals(booleanproperty.values);
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        return 31 * super.generateHashCode() + this.values.hashCode();
    }
}

