/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.Property;

public class EnumProperty<T extends Enum<T>>
extends Property<T> {
    private final ImmutableSet<T> values;
    private final Map<String, T> names = Maps.newHashMap();

    protected EnumProperty(String pName, Class<T> pClazz, Collection<T> pValues) {
        super(pName, pClazz);
        this.values = ImmutableSet.copyOf(pValues);
        for (Enum t : pValues) {
            String s = ((StringRepresentable)((Object)t)).getSerializedName();
            if (this.names.containsKey(s)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + s + "'");
            }
            this.names.put(s, t);
        }
    }

    @Override
    public Collection<T> getPossibleValues() {
        return this.values;
    }

    @Override
    public Optional<T> getValue(String pValue) {
        return Optional.ofNullable((Enum)this.names.get(pValue));
    }

    @Override
    public String getName(T pValue) {
        return ((StringRepresentable)pValue).getSerializedName();
    }

    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof EnumProperty && super.equals(pOther)) {
            EnumProperty enumproperty = (EnumProperty)pOther;
            return this.values.equals(enumproperty.values) && this.names.equals(enumproperty.names);
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        int i = super.generateHashCode();
        i = 31 * i + this.values.hashCode();
        return 31 * i + this.names.hashCode();
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String pName, Class<T> pClazz) {
        return EnumProperty.create(pName, pClazz, (T p_187560_) -> true);
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String pName, Class<T> pClazz, Predicate<T> pValues) {
        return EnumProperty.create(pName, pClazz, Arrays.stream((Enum[])pClazz.getEnumConstants()).filter(pValues).collect(Collectors.toList()));
    }

    public static <T extends Enum<T>> EnumProperty<T> a(String p_61599_, Class<T> p_61600_, T ... p_61601_) {
        return EnumProperty.create(p_61599_, p_61600_, Lists.newArrayList((Object[])p_61601_));
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String pName, Class<T> pClazz, Collection<T> pValues) {
        return new EnumProperty<T>(pName, pClazz, pValues);
    }
}

