/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.Property;

public class IntegerProperty
extends Property<Integer> {
    private final ImmutableSet<Integer> values;

    protected IntegerProperty(String pName, int pMin, int pMax) {
        super(pName, Integer.class);
        if (pMin < 0) {
            throw new IllegalArgumentException("Min value of " + pName + " must be 0 or greater");
        }
        if (pMax <= pMin) {
            throw new IllegalArgumentException("Max value of " + pName + " must be greater than min (" + pMin + ")");
        }
        HashSet set = Sets.newHashSet();
        int i = pMin;
        while (i <= pMax) {
            set.add(i);
            ++i;
        }
        this.values = ImmutableSet.copyOf((Collection)set);
    }

    @Override
    public Collection<Integer> getPossibleValues() {
        return this.values;
    }

    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof IntegerProperty && super.equals(pOther)) {
            IntegerProperty integerproperty = (IntegerProperty)pOther;
            return this.values.equals(integerproperty.values);
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        return 31 * super.generateHashCode() + this.values.hashCode();
    }

    public static IntegerProperty create(String pName, int pMin, int pMax) {
        return new IntegerProperty(pName, pMin, pMax);
    }

    @Override
    public Optional<Integer> getValue(String pValue) {
        try {
            Integer integer = Integer.valueOf(pValue);
            return this.values.contains((Object)integer) ? Optional.of(integer) : Optional.empty();
        }
        catch (NumberFormatException numberformatexception) {
            return Optional.empty();
        }
    }

    @Override
    public String getName(Integer pValue) {
        return pValue.toString();
    }
}

