/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import net.minecraft.world.level.border.WorldBorder;

public interface BorderChangeListener {
    public void onBorderSizeSet(WorldBorder var1, double var2);

    public void onBorderSizeLerping(WorldBorder var1, double var2, double var4, long var6);

    public void onBorderCenterSet(WorldBorder var1, double var2, double var4);

    public void onBorderSetWarningTime(WorldBorder var1, int var2);

    public void onBorderSetWarningBlocks(WorldBorder var1, int var2);

    public void onBorderSetDamagePerBlock(WorldBorder var1, double var2);

    public void onBorderSetDamageSafeZOne(WorldBorder var1, double var2);

    public static class DelegateBorderChangeListener
    implements BorderChangeListener {
        private final WorldBorder worldBorder;

        public DelegateBorderChangeListener(WorldBorder pWorldBorder) {
            this.worldBorder = pWorldBorder;
        }

        @Override
        public void onBorderSizeSet(WorldBorder pBorder, double pNewSize) {
            this.worldBorder.setSize(pNewSize);
        }

        @Override
        public void onBorderSizeLerping(WorldBorder pBorder, double pOldSize, double p_61877_, long pNewSize) {
            this.worldBorder.lerpSizeBetween(pOldSize, p_61877_, pNewSize);
        }

        @Override
        public void onBorderCenterSet(WorldBorder pBorder, double pX, double p_61873_) {
            this.worldBorder.setCenter(pX, p_61873_);
        }

        @Override
        public void onBorderSetWarningTime(WorldBorder pBorder, int pNewTime) {
            this.worldBorder.setWarningTime(pNewTime);
        }

        @Override
        public void onBorderSetWarningBlocks(WorldBorder pBorder, int pNewDistance) {
            this.worldBorder.setWarningBlocks(pNewDistance);
        }

        @Override
        public void onBorderSetDamagePerBlock(WorldBorder pBorder, double pNewAmount) {
            this.worldBorder.setDamagePerBlock(pNewAmount);
        }

        @Override
        public void onBorderSetDamageSafeZOne(WorldBorder pBorder, double pNewSize) {
            this.worldBorder.setDamageSafeZone(pNewSize);
        }
    }
}

