/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.VisibleForDebug;

public final class DataLayer {
    public static final int LAYER_COUNT = 16;
    public static final int LAYER_SIZE = 128;
    public static final int SIZE = 2048;
    private static final int NIBBLE_SIZE = 4;
    @Nullable
    protected byte[] data;

    public DataLayer() {
    }

    public DataLayer(byte[] pSize) {
        this.data = pSize;
        if (pSize.length != 2048) {
            throw Util.pauseInIde(new IllegalArgumentException("DataLayer should be 2048 bytes not: " + pSize.length));
        }
    }

    protected DataLayer(int pSize) {
        this.data = new byte[pSize];
    }

    public int get(int pX, int pY, int pZ) {
        return this.get(DataLayer.getIndex(pX, pY, pZ));
    }

    public void set(int pX, int pY, int pZ, int pValue) {
        this.set(DataLayer.getIndex(pX, pY, pZ), pValue);
    }

    private static int getIndex(int pX, int pY, int pZ) {
        return pY << 8 | pZ << 4 | pX;
    }

    private int get(int pIndex) {
        if (this.data == null) {
            return 0;
        }
        int i = DataLayer.getByteIndex(pIndex);
        int j = DataLayer.getNibbleIndex(pIndex);
        return this.data[i] >> 4 * j & 0xF;
    }

    private void set(int pIndex, int pValue) {
        if (this.data == null) {
            this.data = new byte[2048];
        }
        int i = DataLayer.getByteIndex(pIndex);
        int j = DataLayer.getNibbleIndex(pIndex);
        int k = ~(15 << 4 * j);
        int l = (pValue & 0xF) << 4 * j;
        this.data[i] = (byte)(this.data[i] & k | l);
    }

    private static int getNibbleIndex(int pIndex) {
        return pIndex & 1;
    }

    private static int getByteIndex(int pIndex) {
        return pIndex >> 1;
    }

    public byte[] getData() {
        if (this.data == null) {
            this.data = new byte[2048];
        }
        return this.data;
    }

    public DataLayer copy() {
        return this.data == null ? new DataLayer() : new DataLayer((byte[])this.data.clone());
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        int i = 0;
        while (i < 4096) {
            stringbuilder.append(Integer.toHexString(this.get(i)));
            if ((i & 0xF) == 15) {
                stringbuilder.append("\n");
            }
            if ((i & 0xFF) == 255) {
                stringbuilder.append("\n");
            }
            ++i;
        }
        return stringbuilder.toString();
    }

    @VisibleForDebug
    public String layerToString(int pUnused) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = 0;
        while (i < 256) {
            stringbuilder.append(Integer.toHexString(this.get(i)));
            if ((i & 0xF) == 15) {
                stringbuilder.append("\n");
            }
            ++i;
        }
        return stringbuilder.toString();
    }

    public boolean isEmpty() {
        return this.data == null;
    }
}

