/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.TickContainerAccess;

public class ImposterProtoChunk
extends ProtoChunk {
    private final LevelChunk wrapped;
    private final boolean allowWrites;

    public ImposterProtoChunk(LevelChunk p_187920_, boolean p_187921_) {
        super(p_187920_.getPos(), UpgradeData.EMPTY, p_187920_.levelHeightAccessor, p_187920_.getLevel().registryAccess().registryOrThrow(Registry.BIOME_REGISTRY), p_187920_.getBlendingData());
        this.wrapped = p_187920_;
        this.allowWrites = p_187921_;
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos pPos) {
        return this.wrapped.getBlockEntity(pPos);
    }

    @Override
    public BlockState getBlockState(BlockPos pPos) {
        return this.wrapped.getBlockState(pPos);
    }

    @Override
    public FluidState getFluidState(BlockPos pPos) {
        return this.wrapped.getFluidState(pPos);
    }

    @Override
    public int getMaxLightLevel() {
        return this.wrapped.getMaxLightLevel();
    }

    @Override
    public LevelChunkSection getSection(int p_187932_) {
        return this.allowWrites ? this.wrapped.getSection(p_187932_) : super.getSection(p_187932_);
    }

    @Override
    @Nullable
    public BlockState setBlockState(BlockPos pPos, BlockState pState, boolean pIsMoving) {
        return this.allowWrites ? this.wrapped.setBlockState(pPos, pState, pIsMoving) : null;
    }

    @Override
    public void setBlockEntity(BlockEntity pBlockEntity) {
        if (this.allowWrites) {
            this.wrapped.setBlockEntity(pBlockEntity);
        }
    }

    @Override
    public void addEntity(Entity pEntity) {
        if (this.allowWrites) {
            this.wrapped.addEntity(pEntity);
        }
    }

    @Override
    public void setStatus(ChunkStatus pStatus) {
        if (this.allowWrites) {
            super.setStatus(pStatus);
        }
    }

    @Override
    public LevelChunkSection[] getSections() {
        return this.wrapped.getSections();
    }

    @Override
    public void a(Heightmap.Types p_62706_, long[] p_62707_) {
    }

    private Heightmap.Types fixType(Heightmap.Types pType) {
        if (pType == Heightmap.Types.WORLD_SURFACE_WG) {
            return Heightmap.Types.WORLD_SURFACE;
        }
        return pType == Heightmap.Types.OCEAN_FLOOR_WG ? Heightmap.Types.OCEAN_FLOOR : pType;
    }

    @Override
    public Heightmap getOrCreateHeightmapUnprimed(Heightmap.Types pType) {
        return this.wrapped.getOrCreateHeightmapUnprimed(pType);
    }

    @Override
    public int getHeight(Heightmap.Types pType, int pX, int pZ) {
        return this.wrapped.getHeight(this.fixType(pType), pX, pZ);
    }

    @Override
    public Holder<Biome> getNoiseBiome(int pX, int pY, int pZ) {
        return this.wrapped.getNoiseBiome(pX, pY, pZ);
    }

    @Override
    public ChunkPos getPos() {
        return this.wrapped.getPos();
    }

    @Override
    @Nullable
    public StructureStart getStartForFeature(ConfiguredStructureFeature<?, ?> pStructure) {
        return this.wrapped.getStartForFeature(pStructure);
    }

    @Override
    public void setStartForFeature(ConfiguredStructureFeature<?, ?> pStructure, StructureStart pStart) {
    }

    @Override
    public Map<ConfiguredStructureFeature<?, ?>, StructureStart> getAllStarts() {
        return this.wrapped.getAllStarts();
    }

    @Override
    public void setAllStarts(Map<ConfiguredStructureFeature<?, ?>, StructureStart> pStructureStarts) {
    }

    @Override
    public LongSet getReferencesForFeature(ConfiguredStructureFeature<?, ?> pStructure) {
        return this.wrapped.getReferencesForFeature(pStructure);
    }

    @Override
    public void addReferenceForFeature(ConfiguredStructureFeature<?, ?> pStructure, long pReference) {
    }

    @Override
    public Map<ConfiguredStructureFeature<?, ?>, LongSet> getAllReferences() {
        return this.wrapped.getAllReferences();
    }

    @Override
    public void setAllReferences(Map<ConfiguredStructureFeature<?, ?>, LongSet> pStructureReferences) {
    }

    @Override
    public void setUnsaved(boolean pUnsaved) {
    }

    @Override
    public boolean isUnsaved() {
        return false;
    }

    @Override
    public ChunkStatus getStatus() {
        return this.wrapped.getStatus();
    }

    @Override
    public void removeBlockEntity(BlockPos pPos) {
    }

    @Override
    public void markPosForPostprocessing(BlockPos pPos) {
    }

    @Override
    public void setBlockEntityNbt(CompoundTag pTag) {
    }

    @Override
    @Nullable
    public CompoundTag getBlockEntityNbt(BlockPos pPos) {
        return this.wrapped.getBlockEntityNbt(pPos);
    }

    @Override
    @Nullable
    public CompoundTag getBlockEntityNbtForSaving(BlockPos pPos) {
        return this.wrapped.getBlockEntityNbtForSaving(pPos);
    }

    @Override
    public Stream<BlockPos> getLights() {
        return this.wrapped.getLights();
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        return this.allowWrites ? this.wrapped.getBlockTicks() : BlackholeTickAccess.emptyContainer();
    }

    @Override
    public TickContainerAccess<Fluid> getFluidTicks() {
        return this.allowWrites ? this.wrapped.getFluidTicks() : BlackholeTickAccess.emptyContainer();
    }

    @Override
    public ChunkAccess.TicksToSave getTicksForSerialization() {
        return this.wrapped.getTicksForSerialization();
    }

    @Override
    @Nullable
    public BlendingData getBlendingData() {
        return this.wrapped.getBlendingData();
    }

    @Override
    public void setBlendingData(BlendingData p_187930_) {
        this.wrapped.setBlendingData(p_187930_);
    }

    @Override
    public CarvingMask getCarvingMask(GenerationStep.Carving p_187926_) {
        if (this.allowWrites) {
            return super.getCarvingMask(p_187926_);
        }
        throw Util.pauseInIde(new UnsupportedOperationException("Meaningless in this context"));
    }

    @Override
    public CarvingMask getOrCreateCarvingMask(GenerationStep.Carving p_187934_) {
        if (this.allowWrites) {
            return super.getOrCreateCarvingMask(p_187934_);
        }
        throw Util.pauseInIde(new UnsupportedOperationException("Meaningless in this context"));
    }

    public LevelChunk getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean isLightCorrect() {
        return this.wrapped.isLightCorrect();
    }

    @Override
    public void setLightCorrect(boolean pLightCorrect) {
        this.wrapped.setLightCorrect(pLightCorrect);
    }

    @Override
    public void fillBiomesFromNoise(BiomeResolver p_187923_, Climate.Sampler p_187924_) {
        if (this.allowWrites) {
            this.wrapped.fillBiomesFromNoise(p_187923_, p_187924_);
        }
    }
}

