/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.SingleValuePalette;

public class PalettedContainer<T>
implements PaletteResize<T> {
    private static final int MIN_PALETTE_BITS = 0;
    private final PaletteResize<T> dummyPaletteResize = (p_63139_, p_63140_) -> 0;
    private final IdMap<T> registry;
    private volatile Data<T> data;
    private final Strategy strategy;
    private final ThreadingDetector threadingDetector = new ThreadingDetector("PalettedContainer");

    public void acquire() {
        this.threadingDetector.checkAndLock();
    }

    public void release() {
        this.threadingDetector.checkAndUnlock();
    }

    public static <T> Codec<PalettedContainer<T>> codec(IdMap<T> p_188055_, Codec<T> p_188056_, Strategy p_188057_, T p_188058_) {
        return RecordCodecBuilder.create(p_188047_ -> p_188047_.group((App)p_188056_.mapResult(ExtraCodecs.orElsePartial(p_188058_)).listOf().fieldOf("palette").forGetter(DiscData::paletteEntries), (App)Codec.LONG_STREAM.optionalFieldOf("data").forGetter(DiscData::storage)).apply((Applicative)p_188047_, DiscData::new)).comapFlatMap(p_188081_ -> PalettedContainer.read(p_188055_, p_188057_, p_188081_), p_188074_ -> p_188074_.write(p_188055_, p_188057_));
    }

    public PalettedContainer(IdMap<T> p_188035_, Strategy p_188036_, Configuration<T> p_188037_, BitStorage p_188038_, List<T> p_188039_) {
        this.registry = p_188035_;
        this.strategy = p_188036_;
        this.data = new Data<T>(p_188037_, p_188038_, p_188037_.factory().create(p_188037_.bits(), p_188035_, this, p_188039_));
    }

    private PalettedContainer(IdMap<T> p_199928_, Strategy p_199929_, Data<T> p_199930_) {
        this.registry = p_199928_;
        this.strategy = p_199929_;
        this.data = p_199930_;
    }

    public PalettedContainer(IdMap<T> p_188041_, T p_188042_, Strategy p_188043_) {
        this.strategy = p_188043_;
        this.registry = p_188041_;
        this.data = this.createOrReuseData(null, 0);
        this.data.palette.idFor(p_188042_);
    }

    private Data<T> createOrReuseData(@Nullable Data<T> p_188052_, int p_188053_) {
        Configuration<T> configuration = this.strategy.getConfiguration(this.registry, p_188053_);
        return p_188052_ != null && configuration.equals(p_188052_.configuration()) ? p_188052_ : configuration.createData(this.registry, this, this.strategy.size());
    }

    @Override
    public int onResize(int pBits, T pObjectAdded) {
        Data<T> data = this.data;
        Data data1 = this.createOrReuseData(data, pBits);
        data1.copyFrom(data.palette, data.storage);
        this.data = data1;
        return data1.palette.idFor(pObjectAdded);
    }

    public T getAndSet(int pX, int pY, int pZ, T pState) {
        T object;
        this.acquire();
        try {
            object = this.getAndSet(this.strategy.getIndex(pX, pY, pZ), pState);
        }
        finally {
            this.release();
        }
        return object;
    }

    public T getAndSetUnchecked(int pX, int pY, int pZ, T pState) {
        return this.getAndSet(this.strategy.getIndex(pX, pY, pZ), pState);
    }

    private T getAndSet(int pIndex, T pState) {
        int i = this.data.palette.idFor(pState);
        int j = this.data.storage.getAndSet(pIndex, i);
        return this.data.palette.valueFor(j);
    }

    public void set(int pX, int pY, int pZ, T pState) {
        this.acquire();
        try {
            this.set(this.strategy.getIndex(pX, pY, pZ), pState);
        }
        finally {
            this.release();
        }
    }

    private void set(int pIndex, T pState) {
        int i = this.data.palette.idFor(pState);
        this.data.storage.set(pIndex, i);
    }

    public T get(int pX, int pY, int pZ) {
        return this.get(this.strategy.getIndex(pX, pY, pZ));
    }

    protected T get(int pIndex) {
        Data<T> data = this.data;
        return data.palette.valueFor(data.storage.get(pIndex));
    }

    public void getAll(Consumer<T> p_196880_) {
        Palette palette = this.data.palette();
        IntArraySet intset = new IntArraySet();
        this.data.storage.getAll(arg_0 -> ((IntSet)intset).add(arg_0));
        intset.forEach(p_196884_ -> p_196880_.accept(palette.valueFor(p_196884_)));
    }

    public void read(FriendlyByteBuf pBuffer) {
        this.acquire();
        try {
            byte i = pBuffer.readByte();
            Data<T> data = this.createOrReuseData(this.data, i);
            data.palette.read(pBuffer);
            pBuffer.b(data.storage.getRaw());
            this.data = data;
        }
        finally {
            this.release();
        }
    }

    public void write(FriendlyByteBuf pBuffer) {
        this.acquire();
        try {
            this.data.write(pBuffer);
        }
        finally {
            this.release();
        }
    }

    private static <T> DataResult<PalettedContainer<T>> read(IdMap<T> p_188068_, Strategy p_188069_, DiscData<T> p_188070_) {
        BitStorage bitstorage;
        List<T> list = p_188070_.paletteEntries();
        int i = p_188069_.size();
        int j = p_188069_.calculateBitsForSerialization(p_188068_, list.size());
        Configuration<T> configuration = p_188069_.getConfiguration(p_188068_, j);
        if (j == 0) {
            bitstorage = new ZeroBitStorage(i);
        } else {
            Optional<LongStream> optional = p_188070_.storage();
            if (optional.isEmpty()) {
                return DataResult.error((String)"Missing values for non-zero storage");
            }
            long[] along = optional.get().toArray();
            try {
                if (configuration.factory() == Strategy.GLOBAL_PALETTE_FACTORY) {
                    HashMapPalette<Object> palette = new HashMapPalette<Object>(p_188068_, j, (p_196886_, p_196887_) -> 0, list);
                    SimpleBitStorage simplebitstorage = new SimpleBitStorage(j, i, along);
                    int[] aint = new int[i];
                    simplebitstorage.a(aint);
                    PalettedContainer.a(aint, p_198185_ -> p_188068_.getId(palette.valueFor(p_198185_)));
                    bitstorage = new SimpleBitStorage(configuration.bits(), i, aint);
                } else {
                    bitstorage = new SimpleBitStorage(configuration.bits(), i, along);
                }
            }
            catch (SimpleBitStorage.InitializationException simplebitstorage$initializationexception) {
                return DataResult.error((String)("Failed to read PalettedContainer: " + simplebitstorage$initializationexception.getMessage()));
            }
        }
        return DataResult.success(new PalettedContainer<T>(p_188068_, p_188069_, configuration, bitstorage, list));
    }

    private DiscData<T> write(IdMap<T> p_188065_, Strategy p_188066_) {
        DiscData<T> palettedcontainer$discdata;
        this.acquire();
        try {
            Optional<LongStream> optional;
            HashMapPalette<T> hashmappalette = new HashMapPalette<T>(p_188065_, this.data.storage.getBits(), this.dummyPaletteResize);
            int i = p_188066_.size();
            int[] aint = new int[i];
            this.data.storage.a(aint);
            PalettedContainer.a(aint, p_198178_ -> hashmappalette.idFor(this.data.palette.valueFor(p_198178_)));
            int j = p_188066_.calculateBitsForSerialization(p_188065_, hashmappalette.getSize());
            if (j != 0) {
                SimpleBitStorage simplebitstorage = new SimpleBitStorage(j, i, aint);
                optional = Optional.of(Arrays.stream(simplebitstorage.getRaw()));
            } else {
                optional = Optional.empty();
            }
            palettedcontainer$discdata = new DiscData<T>(hashmappalette.getEntries(), optional);
        }
        finally {
            this.release();
        }
        return palettedcontainer$discdata;
    }

    private static <T> void a(int[] p_198190_, IntUnaryOperator p_198191_) {
        int i = -1;
        int j = -1;
        int k = 0;
        while (k < p_198190_.length) {
            int l = p_198190_[k];
            if (l != i) {
                i = l;
                j = p_198191_.applyAsInt(l);
            }
            p_198190_[k] = j;
            ++k;
        }
    }

    public int getSerializedSize() {
        return this.data.getSerializedSize();
    }

    public boolean maybeHas(Predicate<T> pPredicate) {
        return this.data.palette.maybeHas(pPredicate);
    }

    public PalettedContainer<T> copy() {
        return new PalettedContainer<T>(this.registry, this.strategy, new Data<T>(this.data.configuration(), this.data.storage().copy(), this.data.palette().copy()));
    }

    public void count(CountConsumer<T> pCountConsumer) {
        if (this.data.palette.getSize() == 1) {
            pCountConsumer.accept(this.data.palette.valueFor(0), this.data.storage.getSize());
        } else {
            Int2IntOpenHashMap int2intopenhashmap = new Int2IntOpenHashMap();
            this.data.storage.getAll((int p_200430_) -> int2intopenhashmap.addTo(p_200430_, 1));
            int2intopenhashmap.int2IntEntrySet().forEach(p_198181_ -> pCountConsumer.accept(this.data.palette.valueFor(p_198181_.getIntKey()), p_198181_.getIntValue()));
        }
    }

    record Configuration<T>(Palette.Factory factory, int bits) {
        public Data<T> createData(IdMap<T> p_188092_, PaletteResize<T> p_188093_, int p_188094_) {
            BitStorage bitstorage = this.bits == 0 ? new ZeroBitStorage(p_188094_) : new SimpleBitStorage(this.bits, p_188094_);
            Palette<T> palette = this.factory.create(this.bits, p_188092_, p_188093_, List.of());
            return new Data<T>(this, bitstorage, palette);
        }
    }

    @FunctionalInterface
    public static interface CountConsumer<T> {
        public void accept(T var1, int var2);
    }

    record Data<T>(Configuration<T> configuration, BitStorage storage, Palette<T> palette) {
        public void copyFrom(Palette<T> p_188112_, BitStorage p_188113_) {
            int i = 0;
            while (i < p_188113_.getSize()) {
                T t = p_188112_.valueFor(p_188113_.get(i));
                this.storage.set(i, this.palette.idFor(t));
                ++i;
            }
        }

        public int getSerializedSize() {
            return 1 + this.palette.getSerializedSize() + FriendlyByteBuf.getVarIntSize(this.storage.getSize()) + this.storage.getRaw().length * 8;
        }

        public void write(FriendlyByteBuf p_188115_) {
            p_188115_.writeByte(this.storage.getBits());
            this.palette.write(p_188115_);
            p_188115_.a(this.storage.getRaw());
        }
    }

    record DiscData<T>(List<T> paletteEntries, Optional<LongStream> storage) {
    }

    public static abstract class Strategy {
        public static final Palette.Factory SINGLE_VALUE_PALETTE_FACTORY = SingleValuePalette::create;
        public static final Palette.Factory LINEAR_PALETTE_FACTORY = LinearPalette::create;
        public static final Palette.Factory HASHMAP_PALETTE_FACTORY = HashMapPalette::create;
        static final Palette.Factory GLOBAL_PALETTE_FACTORY = GlobalPalette::create;
        public static final Strategy SECTION_STATES = new Strategy(4){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> p_188157_, int p_188158_) {
                return switch (p_188158_) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, p_188158_);
                    case 1, 2, 3, 4 -> new Configuration(LINEAR_PALETTE_FACTORY, 4);
                    case 5, 6, 7, 8 -> new Configuration(HASHMAP_PALETTE_FACTORY, p_188158_);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(p_188157_.size()));
                };
            }
        };
        public static final Strategy SECTION_BIOMES = new Strategy(2){

            @Override
            public <A> Configuration<A> getConfiguration(IdMap<A> p_188162_, int p_188163_) {
                return switch (p_188163_) {
                    case 0 -> new Configuration(SINGLE_VALUE_PALETTE_FACTORY, p_188163_);
                    case 1, 2, 3 -> new Configuration(LINEAR_PALETTE_FACTORY, p_188163_);
                    default -> new Configuration(GLOBAL_PALETTE_FACTORY, Mth.ceillog2(p_188162_.size()));
                };
            }
        };
        private final int sizeBits;

        Strategy(int p_188143_) {
            this.sizeBits = p_188143_;
        }

        public int size() {
            return 1 << this.sizeBits * 3;
        }

        public int getIndex(int p_188146_, int p_188147_, int p_188148_) {
            return (p_188147_ << this.sizeBits | p_188148_) << this.sizeBits | p_188146_;
        }

        public abstract <A> Configuration<A> getConfiguration(IdMap<A> var1, int var2);

        <A> int calculateBitsForSerialization(IdMap<A> p_188152_, int p_188153_) {
            int i = Mth.ceillog2(p_188153_);
            Configuration<A> configuration = this.getConfiguration(p_188152_, i);
            return configuration.factory() == GLOBAL_PALETTE_FACTORY ? i : configuration.bits();
        }
    }
}

