/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import org.slf4j.Logger;

public class ChunkSerializer {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codec(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";

    public static ProtoChunk read(ServerLevel p_188231_, PoiManager p_188232_, ChunkPos p_188233_, CompoundTag p_188234_) {
        ChunkAccess chunkaccess;
        ChunkPos chunkpos = new ChunkPos(p_188234_.getInt("xPos"), p_188234_.getInt("zPos"));
        if (!Objects.equals(p_188233_, chunkpos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{p_188233_, p_188233_, chunkpos});
        }
        UpgradeData upgradedata = p_188234_.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData(p_188234_.getCompound(TAG_UPGRADE_DATA), p_188231_) : UpgradeData.EMPTY;
        boolean flag = p_188234_.getBoolean("isLightOn");
        ListTag listtag = p_188234_.getList("sections", 10);
        int i = p_188231_.getSectionsCount();
        LevelChunkSection[] alevelchunksection = new LevelChunkSection[i];
        boolean flag1 = p_188231_.dimensionType().hasSkyLight();
        ServerChunkCache chunksource = p_188231_.getChunkSource();
        LevelLightEngine levellightengine = ((ChunkSource)chunksource).getLightEngine();
        if (flag) {
            levellightengine.retainData(p_188233_, true);
        }
        Registry<Biome> registry = p_188231_.registryAccess().registryOrThrow(Registry.BIOME_REGISTRY);
        Codec<PalettedContainer<Holder<Biome>>> codec = ChunkSerializer.makeBiomeCodec(registry);
        int j = 0;
        while (j < listtag.size()) {
            CompoundTag compoundtag = listtag.getCompound(j);
            byte k = compoundtag.getByte("Y");
            int l = p_188231_.getSectionIndexFromSectionY(k);
            if (l >= 0 && l < alevelchunksection.length) {
                LevelChunkSection levelchunksection;
                PalettedContainer palettedcontainer = compoundtag.contains("block_states", 10) ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag.getCompound("block_states")).promotePartial(p_188283_ -> ChunkSerializer.logErrors(p_188233_, k, p_188283_)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)) : new PalettedContainer(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                PalettedContainer palettedcontainer1 = compoundtag.contains("biomes", 10) ? (PalettedContainer)codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag.getCompound("biomes")).promotePartial(p_188274_ -> ChunkSerializer.logErrors(p_188233_, k, p_188274_)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)) : new PalettedContainer(registry.asHolderIdMap(), registry.getHolderOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                alevelchunksection[l] = levelchunksection = new LevelChunkSection(k, palettedcontainer, palettedcontainer1);
                p_188232_.checkConsistencyWithBlocks(p_188233_, levelchunksection);
            }
            if (flag) {
                if (compoundtag.contains("BlockLight", 7)) {
                    levellightengine.queueSectionData(LightLayer.BLOCK, SectionPos.of(p_188233_, k), new DataLayer(compoundtag.getByteArray("BlockLight")), true);
                }
                if (flag1 && compoundtag.contains("SkyLight", 7)) {
                    levellightengine.queueSectionData(LightLayer.SKY, SectionPos.of(p_188233_, k), new DataLayer(compoundtag.getByteArray("SkyLight")), true);
                }
            }
            ++j;
        }
        long j1 = p_188234_.getLong("InhabitedTime");
        ChunkStatus.ChunkType chunkstatus$chunktype = ChunkSerializer.getChunkTypeFromTag(p_188234_);
        BlendingData blendingdata = p_188234_.contains("blending_data", 10) ? (BlendingData)BlendingData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_188234_.getCompound("blending_data"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        if (chunkstatus$chunktype == ChunkStatus.ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> levelchunkticks = LevelChunkTicks.load(p_188234_.getList(BLOCK_TICKS_TAG, 10), p_188287_ -> Registry.BLOCK.getOptional(ResourceLocation.tryParse(p_188287_)), p_188233_);
            LevelChunkTicks<Fluid> levelchunkticks1 = LevelChunkTicks.load(p_188234_.getList(FLUID_TICKS_TAG, 10), p_188285_ -> Registry.FLUID.getOptional(ResourceLocation.tryParse(p_188285_)), p_188233_);
            chunkaccess = new LevelChunk(p_188231_.getLevel(), p_188233_, upgradedata, levelchunkticks, levelchunkticks1, j1, alevelchunksection, ChunkSerializer.postLoadChunk(p_188231_, p_188234_), blendingdata);
        } else {
            boolean flag2;
            ProtoChunkTicks<Block> protochunkticks = ProtoChunkTicks.load(p_188234_.getList(BLOCK_TICKS_TAG, 10), p_196906_ -> Registry.BLOCK.getOptional(ResourceLocation.tryParse(p_196906_)), p_188233_);
            ProtoChunkTicks<Fluid> protochunkticks1 = ProtoChunkTicks.load(p_188234_.getList(FLUID_TICKS_TAG, 10), p_188276_ -> Registry.FLUID.getOptional(ResourceLocation.tryParse(p_188276_)), p_188233_);
            ProtoChunk protochunk = new ProtoChunk(p_188233_, upgradedata, alevelchunksection, protochunkticks, protochunkticks1, p_188231_, registry, blendingdata);
            chunkaccess = protochunk;
            protochunk.setInhabitedTime(j1);
            if (p_188234_.contains("below_zero_retrogen", 10)) {
                BelowZeroRetrogen.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_188234_.getCompound("below_zero_retrogen"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(protochunk::setBelowZeroRetrogen);
            }
            ChunkStatus chunkstatus = ChunkStatus.byName(p_188234_.getString("Status"));
            protochunk.setStatus(chunkstatus);
            if (chunkstatus.isOrAfter(ChunkStatus.FEATURES)) {
                protochunk.setLightEngine(levellightengine);
            }
            BelowZeroRetrogen belowzeroretrogen = protochunk.getBelowZeroRetrogen();
            boolean bl = flag2 = chunkstatus.isOrAfter(ChunkStatus.LIGHT) || belowzeroretrogen != null && belowzeroretrogen.targetStatus().isOrAfter(ChunkStatus.LIGHT);
            if (!flag && flag2) {
                for (BlockPos blockpos : BlockPos.betweenClosed(p_188233_.getMinBlockX(), p_188231_.getMinBuildHeight(), p_188233_.getMinBlockZ(), p_188233_.getMaxBlockX(), p_188231_.getMaxBuildHeight() - 1, p_188233_.getMaxBlockZ())) {
                    if (chunkaccess.getBlockState(blockpos).getLightEmission() == 0) continue;
                    protochunk.addLight(blockpos);
                }
            }
        }
        chunkaccess.setLightCorrect(flag);
        CompoundTag compoundtag2 = p_188234_.getCompound("Heightmaps");
        EnumSet<Heightmap.Types> enumset = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types heightmap$types : chunkaccess.getStatus().heightmapsAfter()) {
            String s = heightmap$types.getSerializationKey();
            if (compoundtag2.contains(s, 12)) {
                chunkaccess.a(heightmap$types, compoundtag2.getLongArray(s));
                continue;
            }
            enumset.add(heightmap$types);
        }
        Heightmap.primeHeightmaps(chunkaccess, enumset);
        CompoundTag compoundtag3 = p_188234_.getCompound("structures");
        chunkaccess.setAllStarts(ChunkSerializer.unpackStructureStart(StructurePieceSerializationContext.fromLevel(p_188231_), compoundtag3, p_188231_.getSeed()));
        chunkaccess.setAllReferences(ChunkSerializer.unpackStructureReferences(p_188231_.registryAccess(), p_188233_, compoundtag3));
        if (p_188234_.getBoolean("shouldSave")) {
            chunkaccess.setUnsaved(true);
        }
        ListTag listtag2 = p_188234_.getList("PostProcessing", 9);
        int k1 = 0;
        while (k1 < listtag2.size()) {
            ListTag listtag3 = listtag2.getList(k1);
            int l1 = 0;
            while (l1 < listtag3.size()) {
                chunkaccess.addPackedPostProcess(listtag3.getShort(l1), k1);
                ++l1;
            }
            ++k1;
        }
        if (chunkstatus$chunktype == ChunkStatus.ChunkType.LEVELCHUNK) {
            return new ImposterProtoChunk((LevelChunk)chunkaccess, false);
        }
        ProtoChunk protochunk1 = (ProtoChunk)chunkaccess;
        ListTag listtag4 = p_188234_.getList("entities", 10);
        int i2 = 0;
        while (i2 < listtag4.size()) {
            protochunk1.addEntity(listtag4.getCompound(i2));
            ++i2;
        }
        ListTag listtag5 = p_188234_.getList("block_entities", 10);
        int j2 = 0;
        while (j2 < listtag5.size()) {
            CompoundTag compoundtag1 = listtag5.getCompound(j2);
            chunkaccess.setBlockEntityNbt(compoundtag1);
            ++j2;
        }
        ListTag listtag6 = p_188234_.getList("Lights", 9);
        int k2 = 0;
        while (k2 < listtag6.size()) {
            ListTag listtag1 = listtag6.getList(k2);
            int i1 = 0;
            while (i1 < listtag1.size()) {
                protochunk1.addLight(listtag1.getShort(i1), k2);
                ++i1;
            }
            ++k2;
        }
        CompoundTag compoundtag4 = p_188234_.getCompound("CarvingMasks");
        for (String s1 : compoundtag4.getAllKeys()) {
            GenerationStep.Carving generationstep$carving = GenerationStep.Carving.valueOf(s1);
            protochunk1.setCarvingMask(generationstep$carving, new CarvingMask(compoundtag4.getLongArray(s1), chunkaccess.getMinBuildHeight()));
        }
        return protochunk1;
    }

    private static void logErrors(ChunkPos p_188240_, int p_188241_, String p_188242_) {
        LOGGER.error("Recoverable errors when loading section [" + p_188240_.x + ", " + p_188241_ + ", " + p_188240_.z + "]: " + p_188242_);
    }

    private static Codec<PalettedContainer<Holder<Biome>>> makeBiomeCodec(Registry<Biome> p_188261_) {
        return PalettedContainer.codec(p_188261_.asHolderIdMap(), p_188261_.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, p_188261_.getHolderOrThrow(Biomes.PLAINS));
    }

    public static CompoundTag write(ServerLevel pLevel, ChunkAccess pChunk) {
        UpgradeData upgradedata;
        BelowZeroRetrogen belowzeroretrogen;
        ChunkPos chunkpos = pChunk.getPos();
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putInt("DataVersion", SharedConstants.getCurrentVersion().getWorldVersion());
        compoundtag.putInt("xPos", chunkpos.x);
        compoundtag.putInt("yPos", pChunk.getMinSection());
        compoundtag.putInt("zPos", chunkpos.z);
        compoundtag.putLong("LastUpdate", pLevel.getGameTime());
        compoundtag.putLong("InhabitedTime", pChunk.getInhabitedTime());
        compoundtag.putString("Status", pChunk.getStatus().getName());
        BlendingData blendingdata = pChunk.getBlendingData();
        if (blendingdata != null) {
            BlendingData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)blendingdata).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_196909_ -> compoundtag.put("blending_data", (Tag)p_196909_));
        }
        if ((belowzeroretrogen = pChunk.getBelowZeroRetrogen()) != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)belowzeroretrogen).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_188279_ -> compoundtag.put("below_zero_retrogen", (Tag)p_188279_));
        }
        if (!(upgradedata = pChunk.getUpgradeData()).isEmpty()) {
            compoundtag.put(TAG_UPGRADE_DATA, upgradedata.write());
        }
        LevelChunkSection[] alevelchunksection = pChunk.getSections();
        ListTag listtag = new ListTag();
        ThreadedLevelLightEngine levellightengine = pLevel.getChunkSource().getLightEngine();
        Registry<Biome> registry = pLevel.registryAccess().registryOrThrow(Registry.BIOME_REGISTRY);
        Codec<PalettedContainer<Holder<Biome>>> codec = ChunkSerializer.makeBiomeCodec(registry);
        boolean flag = pChunk.isLightCorrect();
        int i = levellightengine.getMinLightSection();
        while (i < levellightengine.getMaxLightSection()) {
            int j = pChunk.getSectionIndexFromSectionY(i);
            boolean flag1 = j >= 0 && j < alevelchunksection.length;
            DataLayer datalayer = levellightengine.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of(chunkpos, i));
            DataLayer datalayer1 = levellightengine.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of(chunkpos, i));
            if (flag1 || datalayer != null || datalayer1 != null) {
                CompoundTag compoundtag1 = new CompoundTag();
                if (flag1) {
                    LevelChunkSection levelchunksection = alevelchunksection[j];
                    compoundtag1.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, levelchunksection.getStates()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                    compoundtag1.put("biomes", (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, levelchunksection.getBiomes()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                }
                if (datalayer != null && !datalayer.isEmpty()) {
                    compoundtag1.a("BlockLight", datalayer.getData());
                }
                if (datalayer1 != null && !datalayer1.isEmpty()) {
                    compoundtag1.a("SkyLight", datalayer1.getData());
                }
                if (!compoundtag1.isEmpty()) {
                    compoundtag1.putByte("Y", (byte)i);
                    listtag.add(compoundtag1);
                }
            }
            ++i;
        }
        compoundtag.put("sections", listtag);
        if (flag) {
            compoundtag.putBoolean("isLightOn", true);
        }
        ListTag listtag1 = new ListTag();
        for (BlockPos blockpos : pChunk.getBlockEntitiesPos()) {
            CompoundTag compoundtag3 = pChunk.getBlockEntityNbtForSaving(blockpos);
            if (compoundtag3 == null) continue;
            listtag1.add(compoundtag3);
        }
        compoundtag.put("block_entities", listtag1);
        if (pChunk.getStatus().getChunkType() == ChunkStatus.ChunkType.PROTOCHUNK) {
            ProtoChunk protochunk = (ProtoChunk)pChunk;
            ListTag listtag2 = new ListTag();
            listtag2.addAll(protochunk.getEntities());
            compoundtag.put("entities", listtag2);
            compoundtag.put("Lights", ChunkSerializer.a(protochunk.getPackedLights()));
            CompoundTag compoundtag4 = new CompoundTag();
            GenerationStep.Carving[] carvingArray = GenerationStep.Carving.values();
            int n = carvingArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenerationStep.Carving generationstep$carving = carvingArray[n2];
                CarvingMask carvingmask = protochunk.getCarvingMask(generationstep$carving);
                if (carvingmask != null) {
                    compoundtag4.a(generationstep$carving.toString(), carvingmask.toArray());
                }
                ++n2;
            }
            compoundtag.put("CarvingMasks", compoundtag4);
        }
        ChunkSerializer.saveTicks(pLevel, compoundtag, pChunk.getTicksForSerialization());
        compoundtag.put("PostProcessing", ChunkSerializer.a(pChunk.getPostProcessing()));
        CompoundTag compoundtag2 = new CompoundTag();
        for (Map.Entry<Heightmap.Types, Heightmap> entry : pChunk.getHeightmaps()) {
            if (!pChunk.getStatus().heightmapsAfter().contains(entry.getKey())) continue;
            compoundtag2.put(entry.getKey().getSerializationKey(), new LongArrayTag(entry.getValue().getRawData()));
        }
        compoundtag.put("Heightmaps", compoundtag2);
        compoundtag.put("structures", ChunkSerializer.packStructureData(StructurePieceSerializationContext.fromLevel(pLevel), chunkpos, pChunk.getAllStarts(), pChunk.getAllReferences()));
        return compoundtag;
    }

    private static void saveTicks(ServerLevel p_188236_, CompoundTag p_188237_, ChunkAccess.TicksToSave p_188238_) {
        long i = p_188236_.getLevelData().getGameTime();
        p_188237_.put(BLOCK_TICKS_TAG, p_188238_.blocks().save(i, p_196894_ -> Registry.BLOCK.getKey((Block)p_196894_).toString()));
        p_188237_.put(FLUID_TICKS_TAG, p_188238_.fluids().save(i, p_196896_ -> Registry.FLUID.getKey((Fluid)p_196896_).toString()));
    }

    public static ChunkStatus.ChunkType getChunkTypeFromTag(@Nullable CompoundTag pChunkNBT) {
        return pChunkNBT != null ? ChunkStatus.byName(pChunkNBT.getString("Status")).getChunkType() : ChunkStatus.ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel p_196891_, CompoundTag p_196892_) {
        ListTag listtag = ChunkSerializer.getListOfCompoundsOrNull(p_196892_, "entities");
        ListTag listtag1 = ChunkSerializer.getListOfCompoundsOrNull(p_196892_, "block_entities");
        return listtag == null && listtag1 == null ? null : p_196904_ -> {
            if (listtag != null) {
                p_196891_.addLegacyChunkEntities(EntityType.loadEntitiesRecursive(listtag, p_196891_));
            }
            if (listtag1 != null) {
                int i = 0;
                while (i < listtag1.size()) {
                    CompoundTag compoundtag = listtag1.getCompound(i);
                    boolean flag = compoundtag.getBoolean("keepPacked");
                    if (flag) {
                        p_196904_.setBlockEntityNbt(compoundtag);
                    } else {
                        BlockPos blockpos = BlockEntity.getPosFromTag(compoundtag);
                        BlockEntity blockentity = BlockEntity.loadStatic(blockpos, p_196904_.getBlockState(blockpos), compoundtag);
                        if (blockentity != null) {
                            p_196904_.setBlockEntity(blockentity);
                        }
                    }
                    ++i;
                }
            }
        };
    }

    @Nullable
    private static ListTag getListOfCompoundsOrNull(CompoundTag p_196898_, String p_196899_) {
        ListTag listtag = p_196898_.getList(p_196899_, 10);
        return listtag.isEmpty() ? null : listtag;
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext p_188250_, ChunkPos p_188251_, Map<ConfiguredStructureFeature<?, ?>, StructureStart> p_188252_, Map<ConfiguredStructureFeature<?, ?>, LongSet> p_188253_) {
        CompoundTag compoundtag = new CompoundTag();
        CompoundTag compoundtag1 = new CompoundTag();
        Registry<ConfiguredStructureFeature<?, ?>> registry = p_188250_.registryAccess().registryOrThrow(Registry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        for (Map.Entry<ConfiguredStructureFeature<?, ?>, StructureStart> entry : p_188252_.entrySet()) {
            ResourceLocation resourcelocation = registry.getKey(entry.getKey());
            compoundtag1.put(resourcelocation.toString(), entry.getValue().createTag(p_188250_, p_188251_));
        }
        compoundtag.put("starts", compoundtag1);
        CompoundTag compoundtag2 = new CompoundTag();
        for (Map.Entry<ConfiguredStructureFeature<?, ?>, LongSet> entry1 : p_188253_.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            ResourceLocation resourcelocation1 = registry.getKey(entry1.getKey());
            compoundtag2.put(resourcelocation1.toString(), new LongArrayTag(entry1.getValue()));
        }
        compoundtag.put("References", compoundtag2);
        return compoundtag;
    }

    private static Map<ConfiguredStructureFeature<?, ?>, StructureStart> unpackStructureStart(StructurePieceSerializationContext p_188255_, CompoundTag p_188256_, long p_188257_) {
        HashMap map = Maps.newHashMap();
        Registry<ConfiguredStructureFeature<?, ?>> registry = p_188255_.registryAccess().registryOrThrow(Registry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        CompoundTag compoundtag = p_188256_.getCompound("starts");
        for (String s : compoundtag.getAllKeys()) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse(s);
            ConfiguredStructureFeature<?, ?> configuredstructurefeature = registry.get(resourcelocation);
            if (configuredstructurefeature == null) {
                LOGGER.error("Unknown structure start: {}", (Object)resourcelocation);
                continue;
            }
            StructureStart structurestart = StructureFeature.loadStaticStart(p_188255_, compoundtag.getCompound(s), p_188257_);
            if (structurestart == null) continue;
            map.put(configuredstructurefeature, structurestart);
        }
        return map;
    }

    private static Map<ConfiguredStructureFeature<?, ?>, LongSet> unpackStructureReferences(RegistryAccess p_208155_, ChunkPos p_208156_, CompoundTag p_208157_) {
        HashMap map = Maps.newHashMap();
        Registry<ConfiguredStructureFeature<?, ?>> registry = p_208155_.registryOrThrow(Registry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        CompoundTag compoundtag = p_208157_.getCompound("References");
        for (String s : compoundtag.getAllKeys()) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse(s);
            ConfiguredStructureFeature<?, ?> configuredstructurefeature = registry.get(resourcelocation);
            if (configuredstructurefeature == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)resourcelocation, (Object)p_208156_);
                continue;
            }
            long[] along = compoundtag.getLongArray(s);
            if (along.length == 0) continue;
            map.put(configuredstructurefeature, new LongOpenHashSet(Arrays.stream(along).filter(p_208153_ -> {
                ChunkPos chunkpos = new ChunkPos(p_208153_);
                if (chunkpos.getChessboardDistance(p_208156_) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{resourcelocation, chunkpos, p_208156_});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    public static ListTag a(ShortList[] p_63491_) {
        ListTag listtag = new ListTag();
        ShortList[] shortListArray = p_63491_;
        int n = p_63491_.length;
        int n2 = 0;
        while (n2 < n) {
            ShortList shortlist = shortListArray[n2];
            ListTag listtag1 = new ListTag();
            if (shortlist != null) {
                for (Short oshort : shortlist) {
                    listtag1.add(ShortTag.valueOf(oshort));
                }
            }
            listtag.add(listtag1);
            ++n2;
        }
        return listtag;
    }
}

