/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final ProcessorMailbox<StrictQueue.IntRunnable> mailbox;
    private final RegionFileStorage storage;
    private final Map<ChunkPos, PendingStore> pendingWrites = Maps.newLinkedHashMap();

    protected IOWorker(Path p_196930_, boolean p_196931_, String p_196932_) {
        this.storage = new RegionFileStorage(p_196930_, p_196931_);
        this.mailbox = new ProcessorMailbox<StrictQueue.IntRunnable>(new StrictQueue.FixedPriorityQueue(Priority.values().length), Util.ioPool(), "IOWorker-" + p_196932_);
    }

    public CompletableFuture<Void> store(ChunkPos pChunkPos, @Nullable CompoundTag pChunkData) {
        return this.submitTask(() -> {
            PendingStore ioworker$pendingstore = this.pendingWrites.computeIfAbsent(pChunkPos, p_156584_ -> new PendingStore(pChunkData));
            ioworker$pendingstore.data = pChunkData;
            return Either.left(ioworker$pendingstore.result);
        }).thenCompose(Function.identity());
    }

    @Nullable
    public CompoundTag load(ChunkPos pChunkPos) throws IOException {
        CompletableFuture<CompoundTag> completablefuture = this.loadAsync(pChunkPos);
        try {
            return completablefuture.join();
        }
        catch (CompletionException completionexception) {
            if (completionexception.getCause() instanceof IOException) {
                throw (IOException)completionexception.getCause();
            }
            throw completionexception;
        }
    }

    protected CompletableFuture<CompoundTag> loadAsync(ChunkPos pChunkPos) {
        return this.submitTask(() -> {
            PendingStore ioworker$pendingstore = this.pendingWrites.get(pChunkPos);
            if (ioworker$pendingstore != null) {
                return Either.left((Object)ioworker$pendingstore.data);
            }
            try {
                CompoundTag compoundtag = this.storage.read(pChunkPos);
                return Either.left((Object)compoundtag);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to read chunk {}", (Object)pChunkPos, (Object)exception);
                return Either.right((Object)exception);
            }
        });
    }

    public CompletableFuture<Void> synchronize(boolean p_182499_) {
        CompletionStage completablefuture = this.submitTask(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(p_156581_ -> p_156581_.result).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        return p_182499_ ? ((CompletableFuture)completablefuture).thenCompose(p_63544_ -> this.submitTask(() -> {
            try {
                this.storage.flush();
                return Either.left(null);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to synchronize chunks", (Throwable)exception);
                return Either.right((Object)exception);
            }
        })) : ((CompletableFuture)completablefuture).thenCompose(p_182494_ -> this.submitTask(() -> Either.left(null)));
    }

    @Override
    public CompletableFuture<Void> scanChunk(ChunkPos p_196939_, StreamTagVisitor p_196940_) {
        return this.submitTask(() -> {
            try {
                PendingStore ioworker$pendingstore = this.pendingWrites.get(p_196939_);
                if (ioworker$pendingstore != null) {
                    if (ioworker$pendingstore.data != null) {
                        ioworker$pendingstore.data.acceptAsRoot(p_196940_);
                    }
                } else {
                    this.storage.scanChunk(p_196939_, p_196940_);
                }
                return Either.left(null);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to bulk scan chunk {}", (Object)p_196939_, (Object)exception);
                return Either.right((Object)exception);
            }
        });
    }

    private <T> CompletableFuture<T> submitTask(Supplier<Either<T, Exception>> pTask) {
        return this.mailbox.askEither(p_196943_ -> new StrictQueue.IntRunnable(Priority.FOREGROUND.ordinal(), () -> this.lambda$12(p_196943_, (Supplier)pTask)));
    }

    private void storePendingChunk() {
        if (!this.pendingWrites.isEmpty()) {
            Iterator<Map.Entry<ChunkPos, PendingStore>> iterator = this.pendingWrites.entrySet().iterator();
            Map.Entry<ChunkPos, PendingStore> entry = iterator.next();
            iterator.remove();
            this.runStore(entry.getKey(), entry.getValue());
            this.tellStorePending();
        }
    }

    private void tellStorePending() {
        this.mailbox.tell(new StrictQueue.IntRunnable(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(ChunkPos p_63536_, PendingStore p_63537_) {
        try {
            this.storage.write(p_63536_, p_63537_.data);
            p_63537_.result.complete(null);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to store chunk {}", (Object)p_63536_, (Object)exception);
            p_63537_.result.completeExceptionally(exception);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.shutdownRequested.compareAndSet(false, true)) {
            this.mailbox.ask(p_196934_ -> new StrictQueue.IntRunnable(Priority.SHUTDOWN.ordinal(), () -> p_196934_.tell(Unit.INSTANCE))).join();
            this.mailbox.close();
            try {
                this.storage.close();
            }
            catch (Exception exception) {
                LOGGER.error("Failed to close storage", (Throwable)exception);
            }
        }
    }

    private /* synthetic */ void lambda$12(ProcessorHandle processorHandle, Supplier supplier) {
        if (!this.shutdownRequested.get()) {
            processorHandle.tell((Either)supplier.get());
        }
        this.tellStorePending();
    }

    static class PendingStore {
        @Nullable
        CompoundTag data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public PendingStore(@Nullable CompoundTag pData) {
            this.data = pData;
        }
    }

    static enum Priority {
        FOREGROUND,
        BACKGROUND,
        SHUTDOWN;

    }
}

