/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.ExceptionCollector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;

public final class RegionFileStorage
implements AutoCloseable {
    public static final String ANVIL_EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    private final Long2ObjectLinkedOpenHashMap<RegionFile> regionCache = new Long2ObjectLinkedOpenHashMap();
    private final Path folder;
    private final boolean sync;

    RegionFileStorage(Path p_196954_, boolean p_196955_) {
        this.folder = p_196954_;
        this.sync = p_196955_;
    }

    private RegionFile getRegionFile(ChunkPos pChunkPos) throws IOException {
        long i = ChunkPos.asLong(pChunkPos.getRegionX(), pChunkPos.getRegionZ());
        RegionFile regionfile = (RegionFile)this.regionCache.getAndMoveToFirst(i);
        if (regionfile != null) {
            return regionfile;
        }
        if (this.regionCache.size() >= 256) {
            ((RegionFile)this.regionCache.removeLast()).close();
        }
        Files.createDirectories(this.folder, new FileAttribute[0]);
        Path path = this.folder.resolve("r." + pChunkPos.getRegionX() + "." + pChunkPos.getRegionZ() + ANVIL_EXTENSION);
        RegionFile regionfile1 = new RegionFile(path, this.folder, this.sync);
        this.regionCache.putAndMoveToFirst(i, (Object)regionfile1);
        return regionfile1;
    }

    @Nullable
    public CompoundTag read(ChunkPos pChunkPos) throws IOException {
        CompoundTag compoundtag;
        block7: {
            CompoundTag compoundtag2;
            RegionFile regionfile = this.getRegionFile(pChunkPos);
            try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(pChunkPos);){
                if (datainputstream == null) {
                    compoundtag = null;
                    break block7;
                }
                compoundtag2 = NbtIo.read(datainputstream);
            }
            return compoundtag2;
        }
        return compoundtag;
    }

    public void scanChunk(ChunkPos p_196957_, StreamTagVisitor p_196958_) throws IOException {
        RegionFile regionfile = this.getRegionFile(p_196957_);
        try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(p_196957_);){
            if (datainputstream != null) {
                NbtIo.parse(datainputstream, p_196958_);
            }
        }
    }

    protected void write(ChunkPos pChunkPos, @Nullable CompoundTag pChunkData) throws IOException {
        RegionFile regionfile = this.getRegionFile(pChunkPos);
        if (pChunkData == null) {
            regionfile.clear(pChunkPos);
        } else {
            try (DataOutputStream dataoutputstream = regionfile.getChunkDataOutputStream(pChunkPos);){
                NbtIo.write(pChunkData, dataoutputstream);
            }
        }
    }

    @Override
    public void close() throws IOException {
        ExceptionCollector<IOException> exceptioncollector = new ExceptionCollector<IOException>();
        for (RegionFile regionfile : this.regionCache.values()) {
            try {
                regionfile.close();
            }
            catch (IOException ioexception) {
                exceptioncollector.add(ioexception);
            }
        }
        exceptioncollector.throwIfPresent();
    }

    public void flush() throws IOException {
        for (RegionFile regionfile : this.regionCache.values()) {
            regionfile.flush();
        }
    }
}

