/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.util.FastBufferedInputStream;

public class RegionFileVersion {
    private static final Int2ObjectMap<RegionFileVersion> VERSIONS = new Int2ObjectOpenHashMap();
    public static final RegionFileVersion VERSION_GZIP = RegionFileVersion.register(new RegionFileVersion(1, p_63767_ -> new FastBufferedInputStream(new GZIPInputStream((InputStream)p_63767_)), p_63769_ -> new BufferedOutputStream(new GZIPOutputStream((OutputStream)p_63769_))));
    public static final RegionFileVersion VERSION_DEFLATE = RegionFileVersion.register(new RegionFileVersion(2, p_196964_ -> new FastBufferedInputStream(new InflaterInputStream((InputStream)p_196964_)), p_196966_ -> new BufferedOutputStream(new DeflaterOutputStream((OutputStream)p_196966_))));
    public static final RegionFileVersion VERSION_NONE = RegionFileVersion.register(new RegionFileVersion(3, p_196960_ -> p_196960_, p_196962_ -> p_196962_));
    private final int id;
    private final StreamWrapper<InputStream> inputWrapper;
    private final StreamWrapper<OutputStream> outputWrapper;

    private RegionFileVersion(int pId, StreamWrapper<InputStream> pInputWrapper, StreamWrapper<OutputStream> pOutputWrapper) {
        this.id = pId;
        this.inputWrapper = pInputWrapper;
        this.outputWrapper = pOutputWrapper;
    }

    private static RegionFileVersion register(RegionFileVersion pFileVersion) {
        VERSIONS.put(pFileVersion.id, (Object)pFileVersion);
        return pFileVersion;
    }

    @Nullable
    public static RegionFileVersion fromId(int pId) {
        return (RegionFileVersion)VERSIONS.get(pId);
    }

    public static boolean isValidVersion(int pId) {
        return VERSIONS.containsKey(pId);
    }

    public int getId() {
        return this.id;
    }

    public OutputStream wrap(OutputStream pInputStream) throws IOException {
        return this.outputWrapper.wrap(pInputStream);
    }

    public InputStream wrap(InputStream pInputStream) throws IOException {
        return this.inputWrapper.wrap(pInputStream);
    }

    @FunctionalInterface
    static interface StreamWrapper<O> {
        public O wrap(O var1) throws IOException;
    }
}

