/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.IOWorker;
import org.slf4j.Logger;

public class SectionStorage<R>
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String SECTIONS_TAG = "Sections";
    private final IOWorker worker;
    private final Long2ObjectMap<Optional<R>> storage = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet dirty = new LongLinkedOpenHashSet();
    private final Function<Runnable, Codec<R>> codec;
    private final Function<Runnable, R> factory;
    private final DataFixer fixerUpper;
    private final DataFixTypes type;
    protected final LevelHeightAccessor levelHeightAccessor;

    public SectionStorage(Path p_196968_, Function<Runnable, Codec<R>> p_196969_, Function<Runnable, R> p_196970_, DataFixer p_196971_, DataFixTypes p_196972_, boolean p_196973_, LevelHeightAccessor p_196974_) {
        this.codec = p_196969_;
        this.factory = p_196970_;
        this.fixerUpper = p_196971_;
        this.type = p_196972_;
        this.levelHeightAccessor = p_196974_;
        this.worker = new IOWorker(p_196968_, p_196973_, p_196968_.getFileName().toString());
    }

    protected void tick(BooleanSupplier p_63812_) {
        while (this.hasWork() && p_63812_.getAsBoolean()) {
            ChunkPos chunkpos = SectionPos.of(this.dirty.firstLong()).chunk();
            this.writeColumn(chunkpos);
        }
    }

    public boolean hasWork() {
        return !this.dirty.isEmpty();
    }

    @Nullable
    protected Optional<R> get(long p_63819_) {
        return (Optional)this.storage.get(p_63819_);
    }

    protected Optional<R> getOrLoad(long p_63824_) {
        if (this.outsideStoredRange(p_63824_)) {
            return Optional.empty();
        }
        Optional<R> optional = this.get(p_63824_);
        if (optional != null) {
            return optional;
        }
        this.readColumn(SectionPos.of(p_63824_).chunk());
        optional = this.get(p_63824_);
        if (optional == null) {
            throw Util.pauseInIde(new IllegalStateException());
        }
        return optional;
    }

    protected boolean outsideStoredRange(long p_156631_) {
        int i = SectionPos.sectionToBlockCoord(SectionPos.y(p_156631_));
        return this.levelHeightAccessor.isOutsideBuildHeight(i);
    }

    protected R getOrCreate(long p_63828_) {
        if (this.outsideStoredRange(p_63828_)) {
            throw Util.pauseInIde(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> optional = this.getOrLoad(p_63828_);
        if (optional.isPresent()) {
            return optional.get();
        }
        R r = this.factory.apply(() -> this.setDirty(p_63828_));
        this.storage.put(p_63828_, Optional.of(r));
        return r;
    }

    private void readColumn(ChunkPos p_63815_) {
        this.readColumn(p_63815_, NbtOps.INSTANCE, this.tryRead(p_63815_));
    }

    @Nullable
    private CompoundTag tryRead(ChunkPos p_63821_) {
        try {
            return this.worker.load(p_63821_);
        }
        catch (IOException ioexception) {
            LOGGER.error("Error reading chunk {} data from disk", (Object)p_63821_, (Object)ioexception);
            return null;
        }
    }

    private <T> void readColumn(ChunkPos p_63802_, DynamicOps<T> p_63803_, @Nullable T p_63804_) {
        if (p_63804_ == null) {
            int i = this.levelHeightAccessor.getMinSection();
            while (i < this.levelHeightAccessor.getMaxSection()) {
                this.storage.put(SectionStorage.getKey(p_63802_, i), Optional.empty());
                ++i;
            }
        } else {
            int k;
            Dynamic dynamic1 = new Dynamic(p_63803_, p_63804_);
            int j = SectionStorage.getVersion(dynamic1);
            boolean flag = j != (k = SharedConstants.getCurrentVersion().getWorldVersion());
            Dynamic dynamic = this.fixerUpper.update(this.type.getType(), dynamic1, j, k);
            OptionalDynamic optionaldynamic = dynamic.get(SECTIONS_TAG);
            int l = this.levelHeightAccessor.getMinSection();
            while (l < this.levelHeightAccessor.getMaxSection()) {
                long i1 = SectionStorage.getKey(p_63802_, l);
                Optional optional = optionaldynamic.get(Integer.toString(l)).result().flatMap(p_63791_ -> this.codec.apply(() -> this.setDirty(i1)).parse(p_63791_).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)));
                this.storage.put(i1, optional);
                optional.ifPresent(p_63795_ -> {
                    this.onSectionLoad(i1);
                    if (flag) {
                        this.setDirty(i1);
                    }
                });
                ++l;
            }
        }
    }

    private void writeColumn(ChunkPos p_63826_) {
        Dynamic<Tag> dynamic = this.writeColumn(p_63826_, NbtOps.INSTANCE);
        Tag tag = (Tag)dynamic.getValue();
        if (tag instanceof CompoundTag) {
            this.worker.store(p_63826_, (CompoundTag)tag);
        } else {
            LOGGER.error("Expected compound tag, got {}", (Object)tag);
        }
    }

    private <T> Dynamic<T> writeColumn(ChunkPos p_63799_, DynamicOps<T> p_63800_) {
        HashMap map = Maps.newHashMap();
        int i = this.levelHeightAccessor.getMinSection();
        while (i < this.levelHeightAccessor.getMaxSection()) {
            long j = SectionStorage.getKey(p_63799_, i);
            this.dirty.remove(j);
            Optional optional = (Optional)this.storage.get(j);
            if (optional != null && optional.isPresent()) {
                DataResult dataresult = this.codec.apply(() -> this.setDirty(j)).encodeStart(p_63800_, optional.get());
                String s = Integer.toString(i);
                dataresult.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_63811_ -> map.put(p_63800_.createString(s), p_63811_));
            }
            ++i;
        }
        return new Dynamic(p_63800_, p_63800_.createMap((Map)ImmutableMap.of((Object)p_63800_.createString(SECTIONS_TAG), (Object)p_63800_.createMap((Map)map), (Object)p_63800_.createString("DataVersion"), (Object)p_63800_.createInt(SharedConstants.getCurrentVersion().getWorldVersion()))));
    }

    private static long getKey(ChunkPos p_156628_, int p_156629_) {
        return SectionPos.asLong(p_156628_.x, p_156629_, p_156628_.z);
    }

    protected void onSectionLoad(long p_63813_) {
    }

    protected void setDirty(long pSectionPos) {
        Optional optional = (Optional)this.storage.get(pSectionPos);
        if (optional != null && optional.isPresent()) {
            this.dirty.add(pSectionPos);
        } else {
            LOGGER.warn("No data for position: {}", (Object)SectionPos.of(pSectionPos));
        }
    }

    private static int getVersion(Dynamic<?> p_63806_) {
        return p_63806_.get("DataVersion").asInt(1945);
    }

    public void flush(ChunkPos p_63797_) {
        if (this.hasWork()) {
            int i = this.levelHeightAccessor.getMinSection();
            while (i < this.levelHeightAccessor.getMaxSection()) {
                long j = SectionStorage.getKey(p_63797_, i);
                if (this.dirty.contains(j)) {
                    this.writeColumn(p_63797_);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }
}

