/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public final class LevelStem {
    public static final Codec<LevelStem> CODEC = RecordCodecBuilder.create(p_63986_ -> p_63986_.group((App)DimensionType.CODEC.fieldOf("type").forGetter(LevelStem::typeHolder), (App)ChunkGenerator.CODEC.fieldOf("generator").forGetter(LevelStem::generator)).apply((Applicative)p_63986_, p_63986_.stable(LevelStem::new)));
    public static final ResourceKey<LevelStem> OVERWORLD = ResourceKey.create(Registry.LEVEL_STEM_REGISTRY, new ResourceLocation("overworld"));
    public static final ResourceKey<LevelStem> NETHER = ResourceKey.create(Registry.LEVEL_STEM_REGISTRY, new ResourceLocation("the_nether"));
    public static final ResourceKey<LevelStem> END = ResourceKey.create(Registry.LEVEL_STEM_REGISTRY, new ResourceLocation("the_end"));
    private static final Set<ResourceKey<LevelStem>> BUILTIN_ORDER = ImmutableSet.of(OVERWORLD, NETHER, END);
    private final Holder<DimensionType> type;
    private final ChunkGenerator generator;

    public LevelStem(Holder<DimensionType> p_204519_, ChunkGenerator p_204520_) {
        this.type = p_204519_;
        this.generator = p_204520_;
    }

    public Holder<DimensionType> typeHolder() {
        return this.type;
    }

    public ChunkGenerator generator() {
        return this.generator;
    }

    public static Registry<LevelStem> sortMap(Registry<LevelStem> pMappedRegistry) {
        MappedRegistry<LevelStem> writableregistry = new MappedRegistry<LevelStem>(Registry.LEVEL_STEM_REGISTRY, Lifecycle.experimental(), null);
        for (ResourceKey<LevelStem> resourceKey : BUILTIN_ORDER) {
            LevelStem levelstem = pMappedRegistry.get(resourceKey);
            if (levelstem == null) continue;
            ((WritableRegistry)writableregistry).register(resourceKey, levelstem, pMappedRegistry.lifecycle(levelstem));
        }
        for (Map.Entry entry : pMappedRegistry.entrySet()) {
            ResourceKey resourcekey1 = (ResourceKey)entry.getKey();
            if (BUILTIN_ORDER.contains(resourcekey1)) continue;
            ((WritableRegistry)writableregistry).register(resourcekey1, (LevelStem)entry.getValue(), pMappedRegistry.lifecycle((LevelStem)entry.getValue()));
        }
        return writableregistry;
    }

    public static boolean stable(long pSeed, Registry<LevelStem> p_204524_) {
        if (p_204524_.size() != BUILTIN_ORDER.size()) {
            return false;
        }
        Optional<LevelStem> optional = p_204524_.getOptional(OVERWORLD);
        Optional<LevelStem> optional1 = p_204524_.getOptional(NETHER);
        Optional<LevelStem> optional2 = p_204524_.getOptional(END);
        if (!(optional.isEmpty() || optional1.isEmpty() || optional2.isEmpty())) {
            if (!optional.get().typeHolder().is(DimensionType.OVERWORLD_LOCATION) && !optional.get().typeHolder().is(DimensionType.OVERWORLD_CAVES_LOCATION)) {
                return false;
            }
            if (!optional1.get().typeHolder().is(DimensionType.NETHER_LOCATION)) {
                return false;
            }
            if (!optional2.get().typeHolder().is(DimensionType.END_LOCATION)) {
                return false;
            }
            if (optional1.get().generator() instanceof NoiseBasedChunkGenerator && optional2.get().generator() instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator noisebasedchunkgenerator = (NoiseBasedChunkGenerator)optional1.get().generator();
                NoiseBasedChunkGenerator noisebasedchunkgenerator1 = (NoiseBasedChunkGenerator)optional2.get().generator();
                if (!noisebasedchunkgenerator.stable(pSeed, NoiseGeneratorSettings.NETHER)) {
                    return false;
                }
                if (!noisebasedchunkgenerator1.stable(pSeed, NoiseGeneratorSettings.END)) {
                    return false;
                }
                if (!(noisebasedchunkgenerator.getBiomeSource() instanceof MultiNoiseBiomeSource)) {
                    return false;
                }
                MultiNoiseBiomeSource multinoisebiomesource = (MultiNoiseBiomeSource)noisebasedchunkgenerator.getBiomeSource();
                if (!multinoisebiomesource.stable(MultiNoiseBiomeSource.Preset.NETHER)) {
                    return false;
                }
                BiomeSource biomesource = optional.get().generator().getBiomeSource();
                if (biomesource instanceof MultiNoiseBiomeSource && !((MultiNoiseBiomeSource)biomesource).stable(MultiNoiseBiomeSource.Preset.OVERWORLD)) {
                    return false;
                }
                if (!(noisebasedchunkgenerator1.getBiomeSource() instanceof TheEndBiomeSource)) {
                    return false;
                }
                TheEndBiomeSource theendbiomesource = (TheEndBiomeSource)noisebasedchunkgenerator1.getBiomeSource();
                return theendbiomesource.stable(pSeed);
            }
            return false;
        }
        return false;
    }
}

