/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class EntitySection<T extends EntityAccess> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ClassInstanceMultiMap<T> storage;
    private Visibility chunkStatus;

    public EntitySection(Class<T> p_156831_, Visibility p_156832_) {
        this.chunkStatus = p_156832_;
        this.storage = new ClassInstanceMultiMap<T>(p_156831_);
    }

    public void add(T p_188347_) {
        this.storage.add(p_188347_);
    }

    public boolean remove(T p_188356_) {
        return this.storage.remove(p_188356_);
    }

    public void getEntities(AABB p_188353_, Consumer<T> p_188354_) {
        for (EntityAccess t : this.storage) {
            if (!t.getBoundingBox().intersects(p_188353_)) continue;
            p_188354_.accept(t);
        }
    }

    public <U extends T> void getEntities(EntityTypeTest<T, U> p_188349_, AABB p_188350_, Consumer<? super U> p_188351_) {
        Collection<T> collection = this.storage.find(p_188349_.getBaseClass());
        if (!collection.isEmpty()) {
            for (EntityAccess t : collection) {
                EntityAccess u = (EntityAccess)p_188349_.tryCast(t);
                if (u == null || !t.getBoundingBox().intersects(p_188350_)) continue;
                p_188351_.accept(u);
            }
        }
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public Stream<T> getEntities() {
        return this.storage.stream();
    }

    public Visibility getStatus() {
        return this.chunkStatus;
    }

    public Visibility updateChunkStatus(Visibility pChunkStatus) {
        Visibility visibility = this.chunkStatus;
        this.chunkStatus = pChunkStatus;
        return visibility;
    }

    @VisibleForDebug
    public int size() {
        return this.storage.size();
    }

    public List<T> getEntityList() {
        return this.storage.getValues();
    }

    public static EntitySectionStorage getSectionStorage(TransientEntitySectionManager tesm) {
        return tesm.sectionStorage;
    }
}

