/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AABB;

public class EntitySectionStorage<T extends EntityAccess> {
    private final Class<T> entityClass;
    private final Long2ObjectFunction<Visibility> intialSectionVisibility;
    private final Long2ObjectMap<EntitySection<T>> sections = new Long2ObjectOpenHashMap();
    private final LongSortedSet sectionIds = new LongAVLTreeSet();
    private boolean updated;

    public EntitySectionStorage(Class<T> pEntityClass, Long2ObjectFunction<Visibility> pIntialSectionVisibility) {
        this.entityClass = pEntityClass;
        this.intialSectionVisibility = pIntialSectionVisibility;
    }

    public void forEachAccessibleNonEmptySection(AABB p_188363_, Consumer<EntitySection<T>> p_188364_) {
        int i = SectionPos.posToSectionCoord(p_188363_.minX - 2.0);
        int j = SectionPos.posToSectionCoord(p_188363_.minY - 2.0);
        int k = SectionPos.posToSectionCoord(p_188363_.minZ - 2.0);
        int l = SectionPos.posToSectionCoord(p_188363_.maxX + 2.0);
        int i1 = SectionPos.posToSectionCoord(p_188363_.maxY + 2.0);
        int j1 = SectionPos.posToSectionCoord(p_188363_.maxZ + 2.0);
        int k1 = i;
        while (k1 <= l) {
            long l1 = SectionPos.asLong(k1, 0, 0);
            long i2 = SectionPos.asLong(k1, -1, -1);
            LongBidirectionalIterator longiterator = this.sectionIds.subSet(l1, i2 + 1L).iterator();
            while (longiterator.hasNext()) {
                EntitySection entitysection;
                long j2 = longiterator.nextLong();
                int k2 = SectionPos.y(j2);
                int l2 = SectionPos.z(j2);
                if (k2 < j || k2 > i1 || l2 < k || l2 > j1 || (entitysection = (EntitySection)this.sections.get(j2)) == null || entitysection.isEmpty() || !entitysection.getStatus().isAccessible()) continue;
                p_188364_.accept(entitysection);
            }
            ++k1;
        }
    }

    public LongStream getExistingSectionPositionsInChunk(long p_156862_) {
        int j;
        int i = ChunkPos.getX(p_156862_);
        LongSortedSet longsortedset = this.getChunkSections(i, j = ChunkPos.getZ(p_156862_));
        if (longsortedset.isEmpty()) {
            return LongStream.empty();
        }
        LongBidirectionalIterator oflong = longsortedset.iterator();
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize((PrimitiveIterator.OfLong)oflong, 1301), false);
    }

    private LongSortedSet getChunkSections(int p_156859_, int p_156860_) {
        long i = SectionPos.asLong(p_156859_, 0, p_156860_);
        long j = SectionPos.asLong(p_156859_, -1, p_156860_);
        return this.sectionIds.subSet(i, j + 1L);
    }

    public Stream<EntitySection<T>> getExistingSectionsInChunk(long p_156889_) {
        return this.getExistingSectionPositionsInChunk(p_156889_).mapToObj(arg_0 -> this.sections.get(arg_0)).filter(Objects::nonNull);
    }

    private static long getChunkKeyFromSectionKey(long p_156900_) {
        return ChunkPos.asLong(SectionPos.x(p_156900_), SectionPos.z(p_156900_));
    }

    public EntitySection<T> getOrCreateSection(long p_156894_) {
        EntitySection entitysection;
        int i = this.sections.size();
        try {
            entitysection = (EntitySection)this.sections.computeIfAbsent(p_156894_, this::createSection);
        }
        finally {
            if (this.sections.size() != i) {
                this.updated = true;
            }
        }
        return entitysection;
    }

    @Nullable
    public EntitySection<T> getSection(long p_156896_) {
        return (EntitySection)this.sections.get(p_156896_);
    }

    private EntitySection<T> createSection(long p_156902_) {
        long i = EntitySectionStorage.getChunkKeyFromSectionKey(p_156902_);
        Visibility visibility = (Visibility)((Object)this.intialSectionVisibility.get(i));
        this.sectionIds.add(p_156902_);
        return new EntitySection<T>(this.entityClass, visibility);
    }

    public LongSet getAllChunksWithExistingSections() {
        LongOpenHashSet longset = new LongOpenHashSet();
        this.sections.keySet().forEach(arg_0 -> EntitySectionStorage.lambda$3((LongSet)longset, arg_0));
        return longset;
    }

    public void getEntities(AABB p_156891_, Consumer<T> p_156892_) {
        this.forEachAccessibleNonEmptySection(p_156891_, p_188365_2_ -> p_188365_2_.getEntities(p_156891_, p_156892_));
    }

    public <U extends T> void getEntities(EntityTypeTest<T, U> p_156864_, AABB p_156865_, Consumer<U> p_156866_) {
        this.forEachAccessibleNonEmptySection(p_156865_, p_188357_3_ -> p_188357_3_.getEntities(p_156864_, p_156865_, p_156866_));
    }

    public void remove(long p_156898_) {
        int i = this.sections.size();
        this.sections.remove(p_156898_);
        this.sectionIds.remove(p_156898_);
        if (this.sections.size() != i) {
            this.updated = true;
        }
    }

    @VisibleForDebug
    public int count() {
        return this.sectionIds.size();
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean resetUpdated() {
        boolean flag = this.updated;
        this.updated = false;
        return flag;
    }

    public LongSet getSectionKeys() {
        return this.sections.keySet();
    }

    private static /* synthetic */ void lambda$3(LongSet longSet, long p_156884_1_) {
        longSet.add(EntitySectionStorage.getChunkKeyFromSectionKey(p_156884_1_));
    }
}

