/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.slf4j.Logger;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    final Set<UUID> knownUuids = Sets.newHashSet();
    final LevelCallback<T> callbacks;
    private final EntityPersistentStorage<T> permanentStorage;
    private final EntityLookup<T> visibleEntityStorage;
    final EntitySectionStorage<T> sectionStorage;
    private final LevelEntityGetter<T> entityGetter;
    private final Long2ObjectMap<Visibility> chunkVisibility = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<ChunkLoadStatus> chunkLoadStatuses = new Long2ObjectOpenHashMap();
    private final LongSet chunksToUnload = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> loadingInbox = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> p_157503_, LevelCallback<T> p_157504_, EntityPersistentStorage<T> p_157505_) {
        this.visibleEntityStorage = new EntityLookup();
        this.sectionStorage = new EntitySectionStorage<T>(p_157503_, (Long2ObjectFunction<Visibility>)this.chunkVisibility);
        this.chunkVisibility.defaultReturnValue((Object)Visibility.HIDDEN);
        this.chunkLoadStatuses.defaultReturnValue((Object)ChunkLoadStatus.FRESH);
        this.callbacks = p_157504_;
        this.permanentStorage = p_157505_;
        this.entityGetter = new LevelEntityGetterAdapter<T>(this.visibleEntityStorage, this.sectionStorage);
    }

    void removeSectionIfEmpty(long pSectionKey, EntitySection<T> p_157511_) {
        if (p_157511_.isEmpty()) {
            this.sectionStorage.remove(pSectionKey);
        }
    }

    private boolean addEntityUuid(T pEntity) {
        if (!this.knownUuids.add(pEntity.getUUID())) {
            LOGGER.warn("UUID of added entity already exists: {}", pEntity);
            return false;
        }
        return true;
    }

    public boolean addNewEntity(T pEntity) {
        return this.addEntity(pEntity, false);
    }

    private boolean addEntity(T p_157539_, boolean p_157540_) {
        Visibility visibility;
        if (!this.addEntityUuid(p_157539_)) {
            return false;
        }
        long i = SectionPos.asLong(p_157539_.blockPosition());
        EntitySection<T> entitysection = this.sectionStorage.getOrCreateSection(i);
        entitysection.add(p_157539_);
        p_157539_.setLevelCallback(new Callback(this, p_157539_, i, entitysection));
        if (!p_157540_) {
            this.callbacks.onCreated(p_157539_);
        }
        if ((visibility = PersistentEntitySectionManager.getEffectiveStatus(p_157539_, entitysection.getStatus())).isAccessible()) {
            this.startTracking(p_157539_);
        }
        if (visibility.isTicking()) {
            this.startTicking(p_157539_);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility getEffectiveStatus(T pEntity, Visibility pVisibility) {
        return pEntity.isAlwaysTicking() ? Visibility.TICKING : pVisibility;
    }

    public void addLegacyChunkEntities(Stream<T> pEntities) {
        pEntities.forEach(p_157607_ -> this.addEntity(p_157607_, true));
    }

    public void addWorldGenChunkEntities(Stream<T> pEntities) {
        pEntities.forEach(p_157605_ -> this.addEntity(p_157605_, false));
    }

    void startTicking(T p_157565_) {
        this.callbacks.onTickingStart(p_157565_);
    }

    void stopTicking(T p_157571_) {
        this.callbacks.onTickingEnd(p_157571_);
    }

    void startTracking(T p_157576_) {
        this.visibleEntityStorage.add(p_157576_);
        this.callbacks.onTrackingStart(p_157576_);
    }

    void stopTracking(T p_157581_) {
        this.callbacks.onTrackingEnd(p_157581_);
        this.visibleEntityStorage.remove(p_157581_);
    }

    public void updateChunkStatus(ChunkPos pPos, ChunkHolder.FullChunkStatus pStatus) {
        Visibility visibility = Visibility.fromFullChunkStatus(pStatus);
        this.updateChunkStatus(pPos, visibility);
    }

    public void updateChunkStatus(ChunkPos pPos, Visibility pStatus) {
        long i = pPos.toLong();
        if (pStatus == Visibility.HIDDEN) {
            this.chunkVisibility.remove(i);
            this.chunksToUnload.add(i);
        } else {
            this.chunkVisibility.put(i, (Object)pStatus);
            this.chunksToUnload.remove(i);
            this.ensureChunkQueuedForLoad(i);
        }
        this.sectionStorage.getExistingSectionsInChunk(i).forEach(p_157545_ -> {
            Visibility visibility2 = p_157545_.updateChunkStatus(pStatus);
            boolean flag = visibility2.isAccessible();
            boolean flag1 = pStatus.isAccessible();
            boolean flag2 = visibility2.isTicking();
            boolean flag3 = pStatus.isTicking();
            if (flag2 && !flag3) {
                p_157545_.getEntities().filter(p_157603_ -> !p_157603_.isAlwaysTicking()).forEach(this::stopTicking);
            }
            if (flag && !flag1) {
                p_157545_.getEntities().filter(p_157601_ -> !p_157601_.isAlwaysTicking()).forEach(this::stopTracking);
            } else if (!flag && flag1) {
                p_157545_.getEntities().filter(p_157599_ -> !p_157599_.isAlwaysTicking()).forEach(this::startTracking);
            }
            if (!flag2 && flag3) {
                p_157545_.getEntities().filter(p_157597_ -> !p_157597_.isAlwaysTicking()).forEach(this::startTicking);
            }
        });
    }

    private void ensureChunkQueuedForLoad(long pChunkPosValue) {
        ChunkLoadStatus persistententitysectionmanager$chunkloadstatus = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(pChunkPosValue));
        if (persistententitysectionmanager$chunkloadstatus == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(pChunkPosValue);
        }
    }

    private boolean storeChunkSections(long p_157513_, Consumer<T> p_157514_) {
        ChunkLoadStatus persistententitysectionmanager$chunkloadstatus = (ChunkLoadStatus)((Object)this.chunkLoadStatuses.get(p_157513_));
        if (persistententitysectionmanager$chunkloadstatus == ChunkLoadStatus.PENDING) {
            return false;
        }
        List<T> list = this.sectionStorage.getExistingSectionsInChunk(p_157513_).flatMap(p_157542_ -> p_157542_.getEntities().filter(EntityAccess::shouldBeSaved)).collect(Collectors.toList());
        if (list.isEmpty()) {
            if (persistententitysectionmanager$chunkloadstatus == ChunkLoadStatus.LOADED) {
                this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(p_157513_), ImmutableList.of()));
            }
            return true;
        }
        if (persistententitysectionmanager$chunkloadstatus == ChunkLoadStatus.FRESH) {
            this.requestChunkLoad(p_157513_);
            return false;
        }
        this.permanentStorage.storeEntities(new ChunkEntities(new ChunkPos(p_157513_), list));
        list.forEach(p_157514_);
        return true;
    }

    private void requestChunkLoad(long pChunkPosValue) {
        this.chunkLoadStatuses.put(pChunkPosValue, (Object)ChunkLoadStatus.PENDING);
        ChunkPos chunkpos = new ChunkPos(pChunkPosValue);
        ((CompletableFuture)this.permanentStorage.loadEntities(chunkpos).thenAccept(this.loadingInbox::add)).exceptionally(p_157532_ -> {
            LOGGER.error("Failed to read chunk {}", (Object)chunkpos, p_157532_);
            return null;
        });
    }

    private boolean processChunkUnload(long pChunkPosValue) {
        boolean flag = this.storeChunkSections(pChunkPosValue, p_157595_ -> p_157595_.getPassengersAndSelf().forEach(this::unloadEntity));
        if (!flag) {
            return false;
        }
        this.chunkLoadStatuses.remove(pChunkPosValue);
        return true;
    }

    private void unloadEntity(EntityAccess p_157586_) {
        p_157586_.setRemoved(Entity.RemovalReason.UNLOADED_TO_CHUNK);
        p_157586_.setLevelCallback(EntityInLevelCallback.NULL);
    }

    private void processUnloads() {
        this.chunksToUnload.removeIf(p_157584_ -> this.chunkVisibility.get(p_157584_) != Visibility.HIDDEN ? true : this.processChunkUnload(p_157584_));
    }

    private void processPendingLoads() {
        ChunkEntities<T> chunkentities;
        while ((chunkentities = this.loadingInbox.poll()) != null) {
            chunkentities.getEntities().forEach(p_157593_ -> this.addEntity(p_157593_, true));
            this.chunkLoadStatuses.put(chunkentities.getPos().toLong(), (Object)ChunkLoadStatus.LOADED);
        }
    }

    public void tick() {
        this.processPendingLoads();
        this.processUnloads();
    }

    private LongSet getAllChunksToSave() {
        LongSet longset = this.sectionStorage.getAllChunksWithExistingSections();
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.chunkLoadStatuses)) {
            if (entry.getValue() != ChunkLoadStatus.LOADED) continue;
            longset.add(entry.getLongKey());
        }
        return longset;
    }

    public void autoSave() {
        this.getAllChunksToSave().forEach(p_157579_ -> {
            boolean flag;
            boolean bl = flag = this.chunkVisibility.get(p_157579_) == Visibility.HIDDEN;
            if (flag) {
                this.processChunkUnload(p_157579_);
            } else {
                this.storeChunkSections(p_157579_, p_157591_ -> {});
            }
        });
    }

    public void saveAll() {
        LongSet longset = this.getAllChunksToSave();
        while (!longset.isEmpty()) {
            this.permanentStorage.flush(false);
            this.processPendingLoads();
            longset.removeIf(p_157574_ -> {
                boolean flag = this.chunkVisibility.get(p_157574_) == Visibility.HIDDEN;
                return flag ? this.processChunkUnload(p_157574_) : this.storeChunkSections(p_157574_, p_157589_ -> {});
            });
        }
        this.permanentStorage.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.saveAll();
        this.permanentStorage.close();
    }

    public boolean isLoaded(UUID p_157551_) {
        return this.knownUuids.contains(p_157551_);
    }

    public LevelEntityGetter<T> getEntityGetter() {
        return this.entityGetter;
    }

    public boolean canPositionTick(BlockPos p_202168_) {
        return ((Visibility)((Object)this.chunkVisibility.get(ChunkPos.asLong(p_202168_)))).isTicking();
    }

    public boolean canPositionTick(ChunkPos p_202166_) {
        return ((Visibility)((Object)this.chunkVisibility.get(p_202166_.toLong()))).isTicking();
    }

    public boolean areEntitiesLoaded(long p_157508_) {
        return this.chunkLoadStatuses.get(p_157508_) == ChunkLoadStatus.LOADED;
    }

    public void dumpSections(Writer p_157549_) throws IOException {
        CsvOutput csvoutput = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("visibility").addColumn("load_status").addColumn("entity_count").build(p_157549_);
        this.sectionStorage.getAllChunksWithExistingSections().forEach(p_157517_ -> {
            ChunkLoadStatus persistententitysectionmanager$chunkloadstatus = (ChunkLoadStatus)((Object)((Object)this.chunkLoadStatuses.get(p_157517_)));
            this.sectionStorage.getExistingSectionPositionsInChunk(p_157517_).forEach(p_157521_ -> {
                EntitySection<T> entitysection = this.sectionStorage.getSection(p_157521_);
                if (entitysection != null) {
                    try {
                        csvoutput.a(new Object[]{SectionPos.x(p_157521_), SectionPos.y(p_157521_), SectionPos.z(p_157521_), entitysection.getStatus(), persistententitysectionmanager$chunkloadstatus, entitysection.size()});
                    }
                    catch (IOException ioexception) {
                        throw new UncheckedIOException(ioexception);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String gatherStats() {
        return String.valueOf(this.knownUuids.size()) + "," + this.visibleEntityStorage.count() + "," + this.sectionStorage.count() + "," + this.chunkLoadStatuses.size() + "," + this.chunkVisibility.size() + "," + this.loadingInbox.size() + "," + this.chunksToUnload.size();
    }

    class Callback
    implements EntityInLevelCallback {
        private final T entity;
        private long currentSectionKey;
        private EntitySection<T> currentSection;
        final /* synthetic */ PersistentEntitySectionManager this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        Callback(T t, long p_157616_, EntitySection<T> entitySection) {
            void var3_3;
            void p_157614_;
            this.this$0 = (PersistentEntitySectionManager)l;
            this.entity = p_157614_;
            this.currentSectionKey = var3_3;
            this.currentSection = (EntitySection)p_157616_;
        }

        @Override
        public void onMove() {
            BlockPos blockpos = this.entity.blockPosition();
            long i = SectionPos.asLong(blockpos);
            if (i != this.currentSectionKey) {
                Visibility visibility = this.currentSection.getStatus();
                if (!this.currentSection.remove(this.entity)) {
                    LOGGER.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), i});
                }
                this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
                EntitySection entitysection = this.this$0.sectionStorage.getOrCreateSection(i);
                entitysection.add(this.entity);
                this.currentSection = entitysection;
                this.currentSectionKey = i;
                this.updateStatus(visibility, entitysection.getStatus());
            }
        }

        private void updateStatus(Visibility p_157621_, Visibility p_157622_) {
            Visibility visibility1;
            Visibility visibility = PersistentEntitySectionManager.getEffectiveStatus(this.entity, p_157621_);
            if (visibility != (visibility1 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, p_157622_))) {
                boolean flag = visibility.isAccessible();
                boolean flag1 = visibility1.isAccessible();
                if (flag && !flag1) {
                    this.this$0.stopTracking(this.entity);
                } else if (!flag && flag1) {
                    this.this$0.startTracking(this.entity);
                }
                boolean flag2 = visibility.isTicking();
                boolean flag3 = visibility1.isTicking();
                if (flag2 && !flag3) {
                    this.this$0.stopTicking(this.entity);
                } else if (!flag2 && flag3) {
                    this.this$0.startTicking(this.entity);
                }
            }
        }

        @Override
        public void onRemove(Entity.RemovalReason p_157619_) {
            Visibility visibility;
            if (!this.currentSection.remove(this.entity)) {
                LOGGER.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), p_157619_});
            }
            if ((visibility = PersistentEntitySectionManager.getEffectiveStatus(this.entity, this.currentSection.getStatus())).isTicking()) {
                this.this$0.stopTicking(this.entity);
            }
            if (visibility.isAccessible()) {
                this.this$0.stopTracking(this.entity);
            }
            if (p_157619_.shouldDestroy()) {
                this.this$0.callbacks.onDestroyed(this.entity);
            }
            this.this$0.knownUuids.remove(this.entity.getUUID());
            this.entity.setLevelCallback(NULL);
            this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
        }
    }

    static enum ChunkLoadStatus {
        FRESH,
        PENDING,
        LOADED;

    }
}

