/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;

public class BlockPositionSource
implements PositionSource {
    public static final Codec<BlockPositionSource> CODEC = RecordCodecBuilder.create(p_157710_ -> p_157710_.group((App)BlockPos.CODEC.fieldOf("pos").xmap(Optional::of, Optional::get).forGetter(p_157712_ -> p_157712_.pos)).apply((Applicative)p_157710_, BlockPositionSource::new));
    final Optional<BlockPos> pos;

    public BlockPositionSource(BlockPos pPos) {
        this(Optional.of(pPos));
    }

    public BlockPositionSource(Optional<BlockPos> pPos) {
        this.pos = pPos;
    }

    @Override
    public Optional<BlockPos> getPosition(Level pLevel) {
        return this.pos;
    }

    @Override
    public PositionSourceType<?> getType() {
        return PositionSourceType.BLOCK;
    }

    public static class Type
    implements PositionSourceType<BlockPositionSource> {
        @Override
        public BlockPositionSource read(FriendlyByteBuf p_157716_) {
            return new BlockPositionSource(Optional.of(p_157716_.readBlockPos()));
        }

        @Override
        public void write(FriendlyByteBuf p_157718_, BlockPositionSource p_157719_) {
            p_157719_.pos.ifPresent(p_157718_::writeBlockPos);
        }

        @Override
        public Codec<BlockPositionSource> codec() {
            return CODEC;
        }
    }
}

