/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;

public class EntityPositionSource
implements PositionSource {
    public static final Codec<EntityPositionSource> CODEC = RecordCodecBuilder.create(p_157735_ -> p_157735_.group((App)Codec.INT.fieldOf("source_entity_id").forGetter(p_157737_ -> p_157737_.sourceEntityId)).apply((Applicative)p_157735_, EntityPositionSource::new));
    final int sourceEntityId;
    private Optional<Entity> sourceEntity = Optional.empty();

    public EntityPositionSource(int p_157730_) {
        this.sourceEntityId = p_157730_;
    }

    @Override
    public Optional<BlockPos> getPosition(Level pLevel) {
        if (!this.sourceEntity.isPresent()) {
            this.sourceEntity = Optional.ofNullable(pLevel.getEntity(this.sourceEntityId));
        }
        return this.sourceEntity.map(Entity::blockPosition);
    }

    @Override
    public PositionSourceType<?> getType() {
        return PositionSourceType.ENTITY;
    }

    public static class Type
    implements PositionSourceType<EntityPositionSource> {
        @Override
        public EntityPositionSource read(FriendlyByteBuf p_157741_) {
            return new EntityPositionSource(p_157741_.readVarInt());
        }

        @Override
        public void write(FriendlyByteBuf p_157743_, EntityPositionSource p_157744_) {
            p_157743_.writeVarInt(p_157744_.sourceEntityId);
        }

        @Override
        public Codec<EntityPositionSource> codec() {
            return CODEC;
        }
    }
}

