/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.gameevent.GameEventListener;

public class EuclideanGameEventDispatcher
implements GameEventDispatcher {
    private final List<GameEventListener> listeners = Lists.newArrayList();
    private final Level level;

    public EuclideanGameEventDispatcher(Level pLevel) {
        this.level = pLevel;
    }

    @Override
    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    @Override
    public void register(GameEventListener pListener) {
        this.listeners.add(pListener);
        DebugPackets.sendGameEventListenerInfo(this.level, pListener);
    }

    @Override
    public void unregister(GameEventListener pListener) {
        this.listeners.remove(pListener);
    }

    @Override
    public void post(GameEvent pEvent, @Nullable Entity pEntity, BlockPos pPos) {
        boolean flag = false;
        for (GameEventListener gameeventlistener : this.listeners) {
            if (!this.postToListener(this.level, pEvent, pEntity, pPos, gameeventlistener)) continue;
            flag = true;
        }
        if (flag) {
            DebugPackets.sendGameEventInfo(this.level, pEvent, pPos);
        }
    }

    private boolean postToListener(Level pLevel, GameEvent pEvent, @Nullable Entity pEntity, BlockPos pPos, GameEventListener pListener) {
        int i;
        Optional<BlockPos> optional = pListener.getListenerSource().getPosition(pLevel);
        if (!optional.isPresent()) {
            return false;
        }
        double d0 = optional.get().distSqr(pPos);
        return d0 <= (double)(i = pListener.getListenerRadius() * pListener.getListenerRadius()) && pListener.handleGameEvent(pLevel, pEvent, pEntity, pPos);
    }
}

