/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import org.apache.commons.lang3.mutable.MutableDouble;

public interface Aquifer {
    public static Aquifer create(NoiseChunk p_208161_, ChunkPos p_208162_, DensityFunction p_208163_, DensityFunction p_208164_, DensityFunction p_208165_, DensityFunction p_208166_, PositionalRandomFactory p_208167_, int p_208168_, int p_208169_, FluidPicker p_208170_) {
        return new NoiseBasedAquifer(p_208161_, p_208162_, p_208163_, p_208164_, p_208165_, p_208166_, p_208167_, p_208168_, p_208169_, p_208170_);
    }

    public static Aquifer createDisabled(FluidPicker p_188375_) {
        return new Aquifer(){

            @Override
            @Nullable
            public BlockState computeSubstance(DensityFunction.FunctionContext p_208172_, double p_208173_) {
                return p_208173_ > 0.0 ? null : p_188375_.computeFluid(p_208172_.blockX(), p_208172_.blockY(), p_208172_.blockZ()).at(p_208172_.blockY());
            }

            @Override
            public boolean shouldScheduleFluidUpdate() {
                return false;
            }
        };
    }

    @Nullable
    public BlockState computeSubstance(DensityFunction.FunctionContext var1, double var2);

    public boolean shouldScheduleFluidUpdate();

    public static interface FluidPicker {
        public FluidStatus computeFluid(int var1, int var2, int var3);
    }

    public static final class FluidStatus {
        final int fluidLevel;
        final BlockState fluidType;

        public FluidStatus(int p_188403_, BlockState p_188404_) {
            this.fluidLevel = p_188403_;
            this.fluidType = p_188404_;
        }

        public BlockState at(int p_188406_) {
            return p_188406_ < this.fluidLevel ? this.fluidType : Blocks.AIR.defaultBlockState();
        }
    }

    public static class NoiseBasedAquifer
    implements Aquifer {
        private static final int X_RANGE = 10;
        private static final int Y_RANGE = 9;
        private static final int Z_RANGE = 10;
        private static final int X_SEPARATION = 6;
        private static final int Y_SEPARATION = 3;
        private static final int Z_SEPARATION = 6;
        private static final int X_SPACING = 16;
        private static final int Y_SPACING = 12;
        private static final int Z_SPACING = 16;
        private static final int MAX_REASONABLE_DISTANCE_TO_AQUIFER_CENTER = 11;
        private static final double FLOWING_UPDATE_SIMULARITY = NoiseBasedAquifer.similarity(Mth.square(10), Mth.square(12));
        private final NoiseChunk noiseChunk;
        private final DensityFunction barrierNoise;
        private final DensityFunction fluidLevelFloodednessNoise;
        private final DensityFunction fluidLevelSpreadNoise;
        private final DensityFunction lavaNoise;
        private final PositionalRandomFactory positionalRandomFactory;
        private final FluidStatus[] aquiferCache;
        private final long[] aquiferLocationCache;
        private final FluidPicker globalFluidPicker;
        private boolean shouldScheduleFluidUpdate;
        private final int minGridX;
        private final int minGridY;
        private final int minGridZ;
        private final int gridSizeX;
        private final int gridSizeZ;
        private static final int[][] SURFACE_SAMPLING_OFFSETS_IN_CHUNKS;

        static {
            int[][] nArrayArray = new int[13][];
            nArrayArray[0] = new int[]{-2, -1};
            nArrayArray[1] = new int[]{-1, -1};
            int[] nArray = new int[2];
            nArray[1] = -1;
            nArrayArray[2] = nArray;
            nArrayArray[3] = new int[]{1, -1};
            int[] nArray2 = new int[2];
            nArray2[0] = -3;
            nArrayArray[4] = nArray2;
            int[] nArray3 = new int[2];
            nArray3[0] = -2;
            nArrayArray[5] = nArray3;
            int[] nArray4 = new int[2];
            nArray4[0] = -1;
            nArrayArray[6] = nArray4;
            nArrayArray[7] = new int[2];
            int[] nArray5 = new int[2];
            nArray5[0] = 1;
            nArrayArray[8] = nArray5;
            nArrayArray[9] = new int[]{-2, 1};
            nArrayArray[10] = new int[]{-1, 1};
            int[] nArray6 = new int[2];
            nArray6[1] = 1;
            nArrayArray[11] = nArray6;
            nArrayArray[12] = new int[]{1, 1};
            SURFACE_SAMPLING_OFFSETS_IN_CHUNKS = nArrayArray;
        }

        NoiseBasedAquifer(NoiseChunk p_208175_, ChunkPos p_208176_, DensityFunction p_208177_, DensityFunction p_208178_, DensityFunction p_208179_, DensityFunction p_208180_, PositionalRandomFactory p_208181_, int p_208182_, int p_208183_, FluidPicker p_208184_) {
            this.noiseChunk = p_208175_;
            this.barrierNoise = p_208177_;
            this.fluidLevelFloodednessNoise = p_208178_;
            this.fluidLevelSpreadNoise = p_208179_;
            this.lavaNoise = p_208180_;
            this.positionalRandomFactory = p_208181_;
            this.minGridX = this.gridX(p_208176_.getMinBlockX()) - 1;
            this.globalFluidPicker = p_208184_;
            int i = this.gridX(p_208176_.getMaxBlockX()) + 1;
            this.gridSizeX = i - this.minGridX + 1;
            this.minGridY = this.gridY(p_208182_) - 1;
            int j = this.gridY(p_208182_ + p_208183_) + 1;
            int k = j - this.minGridY + 1;
            this.minGridZ = this.gridZ(p_208176_.getMinBlockZ()) - 1;
            int l = this.gridZ(p_208176_.getMaxBlockZ()) + 1;
            this.gridSizeZ = l - this.minGridZ + 1;
            int i1 = this.gridSizeX * k * this.gridSizeZ;
            this.aquiferCache = new FluidStatus[i1];
            this.aquiferLocationCache = new long[i1];
            Arrays.fill(this.aquiferLocationCache, Long.MAX_VALUE);
        }

        private int getIndex(int pGridX, int pGridY, int pGridZ) {
            int i = pGridX - this.minGridX;
            int j = pGridY - this.minGridY;
            int k = pGridZ - this.minGridZ;
            return (j * this.gridSizeZ + k) * this.gridSizeX + i;
        }

        @Override
        @Nullable
        public BlockState computeSubstance(DensityFunction.FunctionContext p_208186_, double p_208187_) {
            double d5;
            double d3;
            int i = p_208186_.blockX();
            int j = p_208186_.blockY();
            int k = p_208186_.blockZ();
            if (p_208187_ > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            FluidStatus aquifer$fluidstatus = this.globalFluidPicker.computeFluid(i, j, k);
            if (aquifer$fluidstatus.at(j).is(Blocks.LAVA)) {
                this.shouldScheduleFluidUpdate = false;
                return Blocks.LAVA.defaultBlockState();
            }
            int l = Math.floorDiv(i - 5, 16);
            int i1 = Math.floorDiv(j + 1, 12);
            int j1 = Math.floorDiv(k - 5, 16);
            int k1 = Integer.MAX_VALUE;
            int l1 = Integer.MAX_VALUE;
            int i2 = Integer.MAX_VALUE;
            long j2 = 0L;
            long k2 = 0L;
            long l2 = 0L;
            int i3 = 0;
            while (i3 <= 1) {
                int j3 = -1;
                while (j3 <= 1) {
                    int k3 = 0;
                    while (k3 <= 1) {
                        long l4;
                        int l3 = l + i3;
                        int i4 = i1 + j3;
                        int j4 = j1 + k3;
                        int k4 = this.getIndex(l3, i4, j4);
                        long i5 = this.aquiferLocationCache[k4];
                        if (i5 != Long.MAX_VALUE) {
                            l4 = i5;
                        } else {
                            RandomSource randomsource = this.positionalRandomFactory.at(l3, i4, j4);
                            this.aquiferLocationCache[k4] = l4 = BlockPos.asLong(l3 * 16 + randomsource.nextInt(10), i4 * 12 + randomsource.nextInt(9), j4 * 16 + randomsource.nextInt(10));
                        }
                        int i6 = BlockPos.getX(l4) - i;
                        int j5 = BlockPos.getY(l4) - j;
                        int k5 = BlockPos.getZ(l4) - k;
                        int l5 = i6 * i6 + j5 * j5 + k5 * k5;
                        if (k1 >= l5) {
                            l2 = k2;
                            k2 = j2;
                            j2 = l4;
                            i2 = l1;
                            l1 = k1;
                            k1 = l5;
                        } else if (l1 >= l5) {
                            l2 = k2;
                            k2 = l4;
                            i2 = l1;
                            l1 = l5;
                        } else if (i2 >= l5) {
                            l2 = l4;
                            i2 = l5;
                        }
                        ++k3;
                    }
                    ++j3;
                }
                ++i3;
            }
            FluidStatus aquifer$fluidstatus1 = this.getAquiferStatus(j2);
            double d1 = NoiseBasedAquifer.similarity(k1, l1);
            BlockState blockstate = aquifer$fluidstatus1.at(j);
            if (d1 <= 0.0) {
                this.shouldScheduleFluidUpdate = d1 >= FLOWING_UPDATE_SIMULARITY;
                return blockstate;
            }
            if (blockstate.is(Blocks.WATER) && this.globalFluidPicker.computeFluid(i, j - 1, k).at(j - 1).is(Blocks.LAVA)) {
                this.shouldScheduleFluidUpdate = true;
                return blockstate;
            }
            MutableDouble mutabledouble = new MutableDouble(Double.NaN);
            FluidStatus aquifer$fluidstatus2 = this.getAquiferStatus(k2);
            double d2 = d1 * this.calculatePressure(p_208186_, mutabledouble, aquifer$fluidstatus1, aquifer$fluidstatus2);
            if (p_208187_ + d2 > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            FluidStatus aquifer$fluidstatus3 = this.getAquiferStatus(l2);
            double d0 = NoiseBasedAquifer.similarity(k1, i2);
            if (d0 > 0.0 && p_208187_ + (d3 = d1 * d0 * this.calculatePressure(p_208186_, mutabledouble, aquifer$fluidstatus1, aquifer$fluidstatus3)) > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            double d4 = NoiseBasedAquifer.similarity(l1, i2);
            if (d4 > 0.0 && p_208187_ + (d5 = d1 * d4 * this.calculatePressure(p_208186_, mutabledouble, aquifer$fluidstatus2, aquifer$fluidstatus3)) > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            this.shouldScheduleFluidUpdate = true;
            return blockstate;
        }

        @Override
        public boolean shouldScheduleFluidUpdate() {
            return this.shouldScheduleFluidUpdate;
        }

        private static double similarity(int pFirstDistance, int pSecondDistance) {
            double d0 = 25.0;
            return 1.0 - (double)Math.abs(pSecondDistance - pFirstDistance) / 25.0;
        }

        private double calculatePressure(DensityFunction.FunctionContext p_208189_, MutableDouble p_208190_, FluidStatus p_208191_, FluidStatus p_208192_) {
            int i = p_208189_.blockY();
            BlockState blockstate = p_208191_.at(i);
            BlockState blockstate1 = p_208192_.at(i);
            if (!(blockstate.is(Blocks.LAVA) && blockstate1.is(Blocks.WATER) || blockstate.is(Blocks.WATER) && blockstate1.is(Blocks.LAVA))) {
                double d12;
                double d15;
                double d11;
                int j = Math.abs(p_208191_.fluidLevel - p_208192_.fluidLevel);
                if (j == 0) {
                    return 0.0;
                }
                double d0 = 0.5 * (double)(p_208191_.fluidLevel + p_208192_.fluidLevel);
                double d1 = (double)i + 0.5 - d0;
                double d2 = (double)j / 2.0;
                double d3 = 0.0;
                double d4 = 2.5;
                double d5 = 1.5;
                double d6 = 3.0;
                double d7 = 10.0;
                double d8 = 3.0;
                double d9 = d2 - Math.abs(d1);
                double d10 = d1 > 0.0 ? ((d11 = 0.0 + d9) > 0.0 ? d11 / 1.5 : d11 / 2.5) : ((d15 = 3.0 + d9) > 0.0 ? d15 / 3.0 : d15 / 10.0);
                double d16 = 2.0;
                if (!(d10 < -2.0) && !(d10 > 2.0)) {
                    double d13 = p_208190_.getValue();
                    if (Double.isNaN(d13)) {
                        double d14 = this.barrierNoise.compute(p_208189_);
                        p_208190_.setValue(d14);
                        d12 = d14;
                    } else {
                        d12 = d13;
                    }
                } else {
                    d12 = 0.0;
                }
                return 2.0 * (d12 + d10);
            }
            return 2.0;
        }

        private int gridX(int pX) {
            return Math.floorDiv(pX, 16);
        }

        private int gridY(int pY) {
            return Math.floorDiv(pY, 12);
        }

        private int gridZ(int pZ) {
            return Math.floorDiv(pZ, 16);
        }

        private FluidStatus getAquiferStatus(long p_188446_) {
            FluidStatus aquifer$fluidstatus1;
            int j1;
            int i1;
            int i = BlockPos.getX(p_188446_);
            int j = BlockPos.getY(p_188446_);
            int k = BlockPos.getZ(p_188446_);
            int l = this.gridX(i);
            int k1 = this.getIndex(l, i1 = this.gridY(j), j1 = this.gridZ(k));
            FluidStatus aquifer$fluidstatus = this.aquiferCache[k1];
            if (aquifer$fluidstatus != null) {
                return aquifer$fluidstatus;
            }
            this.aquiferCache[k1] = aquifer$fluidstatus1 = this.computeFluid(i, j, k);
            return aquifer$fluidstatus1;
        }

        private FluidStatus computeFluid(int p_188448_, int p_188449_, int p_188450_) {
            double d4;
            FluidStatus aquifer$fluidstatus = this.globalFluidPicker.computeFluid(p_188448_, p_188449_, p_188450_);
            int i = Integer.MAX_VALUE;
            int j = p_188449_ + 12;
            int k = p_188449_ - 12;
            boolean flag = false;
            int[][] nArray = SURFACE_SAMPLING_OFFSETS_IN_CHUNKS;
            int n = SURFACE_SAMPLING_OFFSETS_IN_CHUNKS.length;
            int n2 = 0;
            while (n2 < n) {
                FluidStatus aquifer$fluidstatus1;
                boolean flag2;
                boolean flag1;
                int[] aint = nArray[n2];
                int l = p_188448_ + SectionPos.sectionToBlockCoord(aint[0]);
                int i1 = p_188450_ + SectionPos.sectionToBlockCoord(aint[1]);
                int j1 = this.noiseChunk.preliminarySurfaceLevel(l, i1);
                int k1 = j1 + 8;
                boolean bl = flag1 = aint[0] == 0 && aint[1] == 0;
                if (flag1 && k > k1) {
                    return aquifer$fluidstatus;
                }
                boolean bl2 = flag2 = j > k1;
                if ((flag2 || flag1) && !(aquifer$fluidstatus1 = this.globalFluidPicker.computeFluid(l, k1, i1)).at(k1).isAir()) {
                    if (flag1) {
                        flag = true;
                    }
                    if (flag2) {
                        return aquifer$fluidstatus1;
                    }
                }
                i = Math.min(i, j1);
                ++n2;
            }
            int j5 = i + 8 - p_188449_;
            int k5 = 64;
            double d2 = flag ? Mth.clampedMap((double)j5, 0.0, 64.0, 1.0, 0.0) : 0.0;
            double d3 = Mth.clamp(this.fluidLevelFloodednessNoise.compute(new DensityFunction.SinglePointContext(p_188448_, p_188449_, p_188450_)), -1.0, 1.0);
            if (d3 > (d4 = Mth.map(d2, 1.0, 0.0, -0.3, 0.8))) {
                return aquifer$fluidstatus;
            }
            double d5 = Mth.map(d2, 1.0, 0.0, -0.8, 0.4);
            if (d3 <= d5) {
                return new FluidStatus(DimensionType.WAY_BELOW_MIN_Y, aquifer$fluidstatus.fluidType);
            }
            int l5 = 16;
            int l1 = 40;
            int i2 = Math.floorDiv(p_188448_, 16);
            int j2 = Math.floorDiv(p_188449_, 40);
            int k2 = Math.floorDiv(p_188450_, 16);
            int l2 = j2 * 40 + 20;
            int i3 = 10;
            double d0 = this.fluidLevelSpreadNoise.compute(new DensityFunction.SinglePointContext(i2, j2, k2)) * 10.0;
            int j3 = Mth.quantize(d0, 3);
            int k3 = l2 + j3;
            int l3 = Math.min(i, k3);
            if (k3 <= -10) {
                int i5;
                int l4;
                int i4 = 64;
                int j4 = 40;
                int k4 = Math.floorDiv(p_188448_, 64);
                double d1 = this.lavaNoise.compute(new DensityFunction.SinglePointContext(k4, l4 = Math.floorDiv(p_188449_, 40), i5 = Math.floorDiv(p_188450_, 64)));
                if (Math.abs(d1) > 0.3) {
                    return new FluidStatus(l3, Blocks.LAVA.defaultBlockState());
                }
            }
            return new FluidStatus(l3, aquifer$fluidstatus.fluidType);
        }
    }
}

