/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.Util;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class Beardifier
implements DensityFunctions.BeardifierOrMarker {
    public static final int BEARD_KERNEL_RADIUS = 12;
    private static final int BEARD_KERNEL_SIZE = 24;
    private static final float[] BEARD_KERNEL = Util.make(new float[13824], p_158082_ -> {
        int i = 0;
        while (i < 24) {
            int j = 0;
            while (j < 24) {
                int k = 0;
                while (k < 24) {
                    p_158082_[i * 24 * 24 + j * 24 + k] = (float)Beardifier.computeBeardContribution(j - 12, k - 12, i - 12);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    });
    private final ObjectList<StructurePiece> rigids;
    private final ObjectList<JigsawJunction> junctions;
    private final ObjectListIterator<StructurePiece> pieceIterator;
    private final ObjectListIterator<JigsawJunction> junctionIterator;

    protected Beardifier(StructureFeatureManager pStructureFeatureManager, ChunkAccess pChunk) {
        ChunkPos chunkpos = pChunk.getPos();
        int i = chunkpos.getMinBlockX();
        int j = chunkpos.getMinBlockZ();
        this.junctions = new ObjectArrayList(32);
        this.rigids = new ObjectArrayList(10);
        pStructureFeatureManager.startsForFeature(SectionPos.bottomOf(pChunk), p_208202_ -> p_208202_.adaptNoise).forEach(p_208198_ -> {
            for (StructurePiece structurepiece : p_208198_.getPieces()) {
                if (!structurepiece.isCloseToChunk(chunkpos, 12)) continue;
                if (structurepiece instanceof PoolElementStructurePiece) {
                    PoolElementStructurePiece poolelementstructurepiece = (PoolElementStructurePiece)structurepiece;
                    StructureTemplatePool.Projection structuretemplatepool$projection = poolelementstructurepiece.getElement().getProjection();
                    if (structuretemplatepool$projection == StructureTemplatePool.Projection.RIGID) {
                        this.rigids.add((Object)poolelementstructurepiece);
                    }
                    for (JigsawJunction jigsawjunction : poolelementstructurepiece.getJunctions()) {
                        int k = jigsawjunction.getSourceX();
                        int l = jigsawjunction.getSourceZ();
                        if (k <= i - 12 || l <= j - 12 || k >= i + 15 + 12 || l >= j + 15 + 12) continue;
                        this.junctions.add((Object)jigsawjunction);
                    }
                    continue;
                }
                this.rigids.add((Object)structurepiece);
            }
        });
        this.pieceIterator = this.rigids.iterator();
        this.junctionIterator = this.junctions.iterator();
    }

    @Override
    public double compute(DensityFunction.FunctionContext p_208200_) {
        int i = p_208200_.blockX();
        int j = p_208200_.blockY();
        int k = p_208200_.blockZ();
        double d0 = 0.0;
        while (this.pieceIterator.hasNext()) {
            StructurePiece structurepiece = (StructurePiece)this.pieceIterator.next();
            BoundingBox boundingbox = structurepiece.getBoundingBox();
            int l = Math.max(0, Math.max(boundingbox.minX() - i, i - boundingbox.maxX()));
            int i1 = j - (boundingbox.minY() + (structurepiece instanceof PoolElementStructurePiece ? ((PoolElementStructurePiece)structurepiece).getGroundLevelDelta() : 0));
            int j1 = Math.max(0, Math.max(boundingbox.minZ() - k, k - boundingbox.maxZ()));
            NoiseEffect noiseeffect = structurepiece.getNoiseEffect();
            if (noiseeffect == NoiseEffect.BURY) {
                d0 += Beardifier.getBuryContribution(l, i1, j1);
                continue;
            }
            if (noiseeffect != NoiseEffect.BEARD) continue;
            d0 += Beardifier.getBeardContribution(l, i1, j1) * 0.8;
        }
        this.pieceIterator.back(this.rigids.size());
        while (this.junctionIterator.hasNext()) {
            JigsawJunction jigsawjunction = (JigsawJunction)this.junctionIterator.next();
            int k1 = i - jigsawjunction.getSourceX();
            int l1 = j - jigsawjunction.getSourceGroundY();
            int i2 = k - jigsawjunction.getSourceZ();
            d0 += Beardifier.getBeardContribution(k1, l1, i2) * 0.4;
        }
        this.junctionIterator.back(this.junctions.size());
        return d0;
    }

    @Override
    public double minValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double maxValue() {
        return Double.POSITIVE_INFINITY;
    }

    private static double getBuryContribution(int pX, int pY, int pZ) {
        double d0 = Mth.length(pX, (double)pY / 2.0, pZ);
        return Mth.clampedMap(d0, 0.0, 6.0, 1.0, 0.0);
    }

    private static double getBeardContribution(int pX, int pY, int pZ) {
        int i = pX + 12;
        int j = pY + 12;
        int k = pZ + 12;
        if (i >= 0 && i < 24) {
            if (j >= 0 && j < 24) {
                return k >= 0 && k < 24 ? (double)BEARD_KERNEL[k * 24 * 24 + i * 24 + j] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double computeBeardContribution(int pX, int pY, int pZ) {
        double d0 = pX * pX + pZ * pZ;
        double d1 = (double)pY + 0.5;
        double d2 = d1 * d1;
        double d3 = Math.pow(Math.E, -(d2 / 16.0 + d0 / 16.0));
        double d4 = -d1 * Mth.fastInvSqrt(d2 / 2.0 + d0 / 2.0) / 2.0;
        return d4 * d3;
    }
}

