/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class DebugLevelSource
extends ChunkGenerator {
    public static final Codec<DebugLevelSource> CODEC = RecordCodecBuilder.create(p_208215_ -> DebugLevelSource.commonCodec(p_208215_).and((App)RegistryOps.retrieveRegistry(Registry.BIOME_REGISTRY).forGetter(p_208210_ -> p_208210_.biomes)).apply((Applicative)p_208215_, p_208215_.stable(DebugLevelSource::new)));
    private static final int BLOCK_MARGIN = 2;
    private static final List<BlockState> ALL_BLOCKS = StreamSupport.stream(Registry.BLOCK.spliterator(), false).flatMap(p_208208_ -> p_208208_.getStateDefinition().getPossibleStates().stream()).collect(Collectors.toList());
    private static final int GRID_WIDTH = Mth.ceil(Mth.sqrt(ALL_BLOCKS.size()));
    private static final int GRID_HEIGHT = Mth.ceil((float)ALL_BLOCKS.size() / (float)GRID_WIDTH);
    protected static final BlockState AIR = Blocks.AIR.defaultBlockState();
    protected static final BlockState BARRIER = Blocks.BARRIER.defaultBlockState();
    public static final int HEIGHT = 70;
    public static final int BARRIER_HEIGHT = 60;
    private final Registry<Biome> biomes;

    public DebugLevelSource(Registry<StructureSet> p_208205_, Registry<Biome> p_208206_) {
        super(p_208205_, Optional.empty(), new FixedBiomeSource(p_208206_.getOrCreateHolder(Biomes.PLAINS)));
        this.biomes = p_208206_;
    }

    public Registry<Biome> biomes() {
        return this.biomes;
    }

    @Override
    protected Codec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    @Override
    public ChunkGenerator withSeed(long pSeed) {
        return this;
    }

    @Override
    public void buildSurface(WorldGenRegion p_188520_, StructureFeatureManager p_188521_, ChunkAccess p_188522_) {
    }

    @Override
    public void applyBiomeDecoration(WorldGenLevel p_188524_, ChunkAccess p_188525_, StructureFeatureManager p_188526_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ChunkPos chunkpos = p_188525_.getPos();
        int i = chunkpos.x;
        int j = chunkpos.z;
        int k = 0;
        while (k < 16) {
            int l = 0;
            while (l < 16) {
                int i1 = SectionPos.sectionToBlockCoord(i, k);
                int j1 = SectionPos.sectionToBlockCoord(j, l);
                p_188524_.setBlock(blockpos$mutableblockpos.set(i1, 60, j1), BARRIER, 2);
                BlockState blockstate = DebugLevelSource.getBlockStateFor(i1, j1);
                p_188524_.setBlock(blockpos$mutableblockpos.set(i1, 70, j1), blockstate, 2);
                ++l;
            }
            ++k;
        }
    }

    @Override
    public CompletableFuture<ChunkAccess> fillFromNoise(Executor p_188528_, Blender p_188529_, StructureFeatureManager p_188530_, ChunkAccess p_188531_) {
        return CompletableFuture.completedFuture(p_188531_);
    }

    @Override
    public int getBaseHeight(int pX, int pZ, Heightmap.Types pType, LevelHeightAccessor pLevel) {
        return 0;
    }

    @Override
    public NoiseColumn getBaseColumn(int pX, int pZ, LevelHeightAccessor pLevel) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    @Override
    public void addDebugScreenInfo(List<String> p_208212_, BlockPos p_208213_) {
    }

    public static BlockState getBlockStateFor(int pChunkX, int pChunkZ) {
        int i;
        BlockState blockstate = AIR;
        if (pChunkX > 0 && pChunkZ > 0 && pChunkX % 2 != 0 && pChunkZ % 2 != 0 && (pChunkX /= 2) <= GRID_WIDTH && (pChunkZ /= 2) <= GRID_HEIGHT && (i = Mth.abs(pChunkX * GRID_WIDTH + pChunkZ)) < ALL_BLOCKS.size()) {
            blockstate = ALL_BLOCKS.get(i);
        }
        return blockstate;
    }

    @Override
    public Climate.Sampler climateSampler() {
        return Climate.empty();
    }

    @Override
    public void applyCarvers(WorldGenRegion p_188513_, long p_188514_, BiomeManager p_188515_, StructureFeatureManager p_188516_, ChunkAccess p_188517_, GenerationStep.Carving p_188518_) {
    }

    @Override
    public void spawnOriginalMobs(WorldGenRegion pLevel) {
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getGenDepth() {
        return 384;
    }

    @Override
    public int getSeaLevel() {
        return 63;
    }
}

