/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import org.slf4j.Logger;

public final class DensityFunctions {
    private static final Codec<DensityFunction> CODEC = Registry.DENSITY_FUNCTION_TYPES.byNameCodec().dispatch(DensityFunction::codec, Function.identity());
    protected static final double MAX_REASONABLE_NOISE_VALUE = 1000000.0;
    static final Codec<Double> NOISE_VALUE_CODEC = Codec.doubleRange((double)-1000000.0, (double)1000000.0);
    public static final Codec<DensityFunction> DIRECT_CODEC = Codec.either(NOISE_VALUE_CODEC, CODEC).xmap(p_208274_ -> (DensityFunction)p_208274_.map(DensityFunctions::constant, Function.identity()), p_208392_ -> {
        if (p_208392_ instanceof Constant) {
            Constant densityfunctions$constant = (Constant)p_208392_;
            return Either.left((Object)densityfunctions$constant.value());
        }
        return Either.right((Object)p_208392_);
    });

    public static Codec<? extends DensityFunction> bootstrap(Registry<Codec<? extends DensityFunction>> p_208343_) {
        DensityFunctions.register(p_208343_, "blend_alpha", BlendAlpha.CODEC);
        DensityFunctions.register(p_208343_, "blend_offset", BlendOffset.CODEC);
        DensityFunctions.register(p_208343_, "beardifier", (Codec<? extends DensityFunction>)BeardifierMarker.CODEC);
        DensityFunctions.register(p_208343_, "old_blended_noise", BlendedNoise.CODEC);
        Enum[] enumArray = Marker.Type.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Marker.Type densityfunctions$marker$type = enumArray[n2];
            DensityFunctions.register(p_208343_, densityfunctions$marker$type.getSerializedName(), densityfunctions$marker$type.codec);
            ++n2;
        }
        DensityFunctions.register(p_208343_, "noise", Noise.CODEC);
        DensityFunctions.register(p_208343_, "end_islands", EndIslandDensityFunction.CODEC);
        DensityFunctions.register(p_208343_, "weird_scaled_sampler", WeirdScaledSampler.CODEC);
        DensityFunctions.register(p_208343_, "shifted_noise", ShiftedNoise.CODEC);
        DensityFunctions.register(p_208343_, "range_choice", RangeChoice.CODEC);
        DensityFunctions.register(p_208343_, "shift_a", ShiftA.CODEC);
        DensityFunctions.register(p_208343_, "shift_b", ShiftB.CODEC);
        DensityFunctions.register(p_208343_, "shift", Shift.CODEC);
        DensityFunctions.register(p_208343_, "blend_density", BlendDensity.CODEC);
        DensityFunctions.register(p_208343_, "clamp", Clamp.CODEC);
        enumArray = Mapped.Type.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum densityfunctions$mapped$type = enumArray[n2];
            DensityFunctions.register(p_208343_, ((Mapped.Type)densityfunctions$mapped$type).getSerializedName(), ((Mapped.Type)densityfunctions$mapped$type).codec);
            ++n2;
        }
        DensityFunctions.register(p_208343_, "slide", Slide.CODEC);
        enumArray = TwoArgumentSimpleFunction.Type.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum densityfunctions$twoargumentsimplefunction$type = enumArray[n2];
            DensityFunctions.register(p_208343_, ((TwoArgumentSimpleFunction.Type)densityfunctions$twoargumentsimplefunction$type).getSerializedName(), ((TwoArgumentSimpleFunction.Type)densityfunctions$twoargumentsimplefunction$type).codec);
            ++n2;
        }
        DensityFunctions.register(p_208343_, "spline", Spline.CODEC);
        DensityFunctions.register(p_208343_, "terrain_shaper_spline", TerrainShaperSpline.CODEC);
        DensityFunctions.register(p_208343_, "constant", Constant.CODEC);
        return DensityFunctions.register(p_208343_, "y_clamped_gradient", YClampedGradient.CODEC);
    }

    private static Codec<? extends DensityFunction> register(Registry<Codec<? extends DensityFunction>> p_208345_, String p_208346_, Codec<? extends DensityFunction> p_208347_) {
        return Registry.register(p_208345_, p_208346_, p_208347_);
    }

    static <A, O> Codec<O> singleArgumentCodec(Codec<A> p_208276_, Function<A, O> p_208277_, Function<O, A> p_208278_) {
        return p_208276_.fieldOf("argument").xmap(p_208277_, p_208278_).codec();
    }

    static <O> Codec<O> singleFunctionArgumentCodec(Function<DensityFunction, O> p_208353_, Function<O, DensityFunction> p_208354_) {
        return DensityFunctions.singleArgumentCodec(DensityFunction.HOLDER_HELPER_CODEC, p_208353_, p_208354_);
    }

    static <O> Codec<O> doubleFunctionArgumentCodec(BiFunction<DensityFunction, DensityFunction, O> p_208349_, Function<O, DensityFunction> p_208350_, Function<O, DensityFunction> p_208351_) {
        return RecordCodecBuilder.create(p_208359_ -> p_208359_.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument1").forGetter(p_208350_), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument2").forGetter(p_208351_)).apply((Applicative)p_208359_, p_208349_));
    }

    static <O> Codec<O> makeCodec(MapCodec<O> p_208280_) {
        return p_208280_.codec();
    }

    private DensityFunctions() {
    }

    public static DensityFunction interpolated(DensityFunction p_208282_) {
        return new Marker(Marker.Type.Interpolated, p_208282_);
    }

    public static DensityFunction flatCache(DensityFunction p_208362_) {
        return new Marker(Marker.Type.FlatCache, p_208362_);
    }

    public static DensityFunction cache2d(DensityFunction p_208374_) {
        return new Marker(Marker.Type.Cache2D, p_208374_);
    }

    public static DensityFunction cacheOnce(DensityFunction p_208381_) {
        return new Marker(Marker.Type.CacheOnce, p_208381_);
    }

    public static DensityFunction cacheAllInCell(DensityFunction p_208388_) {
        return new Marker(Marker.Type.CacheAllInCell, p_208388_);
    }

    public static DensityFunction mappedNoise(Holder<NormalNoise.NoiseParameters> p_208337_, @Deprecated double p_208338_, double p_208339_, double p_208340_, double p_208341_) {
        return DensityFunctions.mapFromUnitTo(new Noise(p_208337_, null, p_208338_, p_208339_), p_208340_, p_208341_);
    }

    public static DensityFunction mappedNoise(Holder<NormalNoise.NoiseParameters> p_208332_, double p_208333_, double p_208334_, double p_208335_) {
        return DensityFunctions.mappedNoise(p_208332_, 1.0, p_208333_, p_208334_, p_208335_);
    }

    public static DensityFunction mappedNoise(Holder<NormalNoise.NoiseParameters> p_208328_, double p_208329_, double p_208330_) {
        return DensityFunctions.mappedNoise(p_208328_, 1.0, 1.0, p_208329_, p_208330_);
    }

    public static DensityFunction shiftedNoise2d(DensityFunction p_208297_, DensityFunction p_208298_, double p_208299_, Holder<NormalNoise.NoiseParameters> p_208300_) {
        return new ShiftedNoise(p_208297_, DensityFunctions.zero(), p_208298_, p_208299_, 0.0, p_208300_, null);
    }

    public static DensityFunction noise(Holder<NormalNoise.NoiseParameters> p_208323_) {
        return DensityFunctions.noise(p_208323_, 1.0, 1.0);
    }

    public static DensityFunction noise(Holder<NormalNoise.NoiseParameters> p_208369_, double p_208370_, double p_208371_) {
        return new Noise(p_208369_, null, p_208370_, p_208371_);
    }

    public static DensityFunction noise(Holder<NormalNoise.NoiseParameters> p_208325_, double p_208326_) {
        return DensityFunctions.noise(p_208325_, 1.0, p_208326_);
    }

    public static DensityFunction rangeChoice(DensityFunction p_208288_, double p_208289_, double p_208290_, DensityFunction p_208291_, DensityFunction p_208292_) {
        return new RangeChoice(p_208288_, p_208289_, p_208290_, p_208291_, p_208292_);
    }

    public static DensityFunction shiftA(Holder<NormalNoise.NoiseParameters> p_208367_) {
        return new ShiftA(p_208367_, null);
    }

    public static DensityFunction shiftB(Holder<NormalNoise.NoiseParameters> p_208379_) {
        return new ShiftB(p_208379_, null);
    }

    public static DensityFunction shift(Holder<NormalNoise.NoiseParameters> p_208386_) {
        return new Shift(p_208386_, null);
    }

    public static DensityFunction blendDensity(DensityFunction p_208390_) {
        return new BlendDensity(p_208390_);
    }

    public static DensityFunction endIslands(long p_208272_) {
        return new EndIslandDensityFunction(p_208272_);
    }

    public static DensityFunction weirdScaledSampler(DensityFunction p_208316_, Holder<NormalNoise.NoiseParameters> p_208317_, WeirdScaledSampler.RarityValueMapper p_208318_) {
        return new WeirdScaledSampler(p_208316_, p_208317_, null, p_208318_);
    }

    public static DensityFunction slide(NoiseSettings p_208320_, DensityFunction p_208321_) {
        return new Slide(p_208320_, p_208321_);
    }

    public static DensityFunction add(DensityFunction p_208294_, DensityFunction p_208295_) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.ADD, p_208294_, p_208295_);
    }

    public static DensityFunction mul(DensityFunction p_208364_, DensityFunction p_208365_) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.MUL, p_208364_, p_208365_);
    }

    public static DensityFunction min(DensityFunction p_208376_, DensityFunction p_208377_) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.MIN, p_208376_, p_208377_);
    }

    public static DensityFunction max(DensityFunction p_208383_, DensityFunction p_208384_) {
        return TwoArgumentSimpleFunction.create(TwoArgumentSimpleFunction.Type.MAX, p_208383_, p_208384_);
    }

    public static DensityFunction terrainShaperSpline(DensityFunction p_208306_, DensityFunction p_208307_, DensityFunction p_208308_, TerrainShaperSpline.SplineType p_208309_, double p_208310_, double p_208311_) {
        return new TerrainShaperSpline(p_208306_, p_208307_, p_208308_, null, p_208309_, p_208310_, p_208311_);
    }

    public static DensityFunction zero() {
        return Constant.ZERO;
    }

    public static DensityFunction constant(double p_208265_) {
        return new Constant(p_208265_);
    }

    public static DensityFunction yClampedGradient(int p_208267_, int p_208268_, double p_208269_, double p_208270_) {
        return new YClampedGradient(p_208267_, p_208268_, p_208269_, p_208270_);
    }

    public static DensityFunction map(DensityFunction p_208313_, Mapped.Type p_208314_) {
        return Mapped.create(p_208314_, p_208313_);
    }

    private static DensityFunction mapFromUnitTo(DensityFunction p_208284_, double p_208285_, double p_208286_) {
        double d0 = (p_208285_ + p_208286_) * 0.5;
        double d1 = (p_208286_ - p_208285_) * 0.5;
        return DensityFunctions.add(DensityFunctions.constant(d0), DensityFunctions.mul(DensityFunctions.constant(d1), p_208284_));
    }

    public static DensityFunction blendAlpha() {
        return BlendAlpha.INSTANCE;
    }

    public static DensityFunction blendOffset() {
        return BlendOffset.INSTANCE;
    }

    public static DensityFunction lerp(DensityFunction p_208302_, DensityFunction p_208303_, DensityFunction p_208304_) {
        DensityFunction densityfunction = DensityFunctions.cacheOnce(p_208302_);
        DensityFunction densityfunction1 = DensityFunctions.add(DensityFunctions.mul(densityfunction, DensityFunctions.constant(-1.0)), DensityFunctions.constant(1.0));
        return DensityFunctions.add(DensityFunctions.mul(p_208303_, densityfunction1), DensityFunctions.mul(p_208304_, densityfunction));
    }

    record Ap2(TwoArgumentSimpleFunction.Type type, DensityFunction argument1, DensityFunction argument2, double minValue, double maxValue) implements TwoArgumentSimpleFunction
    {
        @Override
        public double compute(DensityFunction.FunctionContext p_208410_) {
            double d0 = this.argument1.compute(p_208410_);
            return switch (this.type) {
                case TwoArgumentSimpleFunction.Type.ADD -> d0 + this.argument2.compute(p_208410_);
                case TwoArgumentSimpleFunction.Type.MAX -> d0 > this.argument2.maxValue() ? d0 : Math.max(d0, this.argument2.compute(p_208410_));
                case TwoArgumentSimpleFunction.Type.MIN -> d0 < this.argument2.minValue() ? d0 : Math.min(d0, this.argument2.compute(p_208410_));
                case TwoArgumentSimpleFunction.Type.MUL -> d0 == 0.0 ? 0.0 : d0 * this.argument2.compute(p_208410_);
                default -> throw new IncompatibleClassChangeError();
            };
        }

        @Override
        public void a(double[] p_208414_, DensityFunction.ContextProvider p_208415_) {
            this.argument1.a(p_208414_, p_208415_);
            switch (this.type) {
                case ADD: {
                    double[] adouble = new double[p_208414_.length];
                    this.argument2.a(adouble, p_208415_);
                    int k = 0;
                    while (k < p_208414_.length) {
                        int n = k;
                        p_208414_[n] = p_208414_[n] + adouble[k];
                        ++k;
                    }
                    break;
                }
                case MAX: {
                    double d3 = this.argument2.maxValue();
                    int l = 0;
                    while (l < p_208414_.length) {
                        double d4 = p_208414_[l];
                        p_208414_[l] = d4 > d3 ? d4 : Math.max(d4, this.argument2.compute(p_208415_.forIndex(l)));
                        ++l;
                    }
                    break;
                }
                case MIN: {
                    double d2 = this.argument2.minValue();
                    int j = 0;
                    while (j < p_208414_.length) {
                        double d1 = p_208414_[j];
                        p_208414_[j] = d1 < d2 ? d1 : Math.min(d1, this.argument2.compute(p_208415_.forIndex(j)));
                        ++j;
                    }
                    break;
                }
                case MUL: {
                    int i = 0;
                    while (i < p_208414_.length) {
                        double d0 = p_208414_[i];
                        p_208414_[i] = d0 == 0.0 ? 0.0 : d0 * this.argument2.compute(p_208415_.forIndex(i));
                        ++i;
                    }
                    break;
                }
            }
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208412_) {
            return (DensityFunction)p_208412_.apply(TwoArgumentSimpleFunction.create(this.type, this.argument1.mapAll(p_208412_), this.argument2.mapAll(p_208412_)));
        }
    }

    protected static enum BeardifierMarker implements BeardifierOrMarker
    {
        INSTANCE;


        @Override
        public double compute(DensityFunction.FunctionContext p_208515_) {
            return 0.0;
        }

        @Override
        public void a(double[] p_208517_, DensityFunction.ContextProvider p_208518_) {
            Arrays.fill(p_208517_, 0.0);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 0.0;
        }
    }

    public static interface BeardifierOrMarker
    extends DensityFunction.SimpleFunction {
        public static final Codec<DensityFunction> CODEC = Codec.unit((Object)BeardifierMarker.INSTANCE);

        @Override
        default public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected static enum BlendAlpha implements DensityFunction.SimpleFunction
    {
        INSTANCE;

        public static final Codec<DensityFunction> CODEC;

        static {
            CODEC = Codec.unit((Object)INSTANCE);
        }

        @Override
        public double compute(DensityFunction.FunctionContext p_208536_) {
            return 1.0;
        }

        @Override
        public void a(double[] p_208538_, DensityFunction.ContextProvider p_208539_) {
            Arrays.fill(p_208538_, 1.0);
        }

        @Override
        public double minValue() {
            return 1.0;
        }

        @Override
        public double maxValue() {
            return 1.0;
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record BlendDensity(DensityFunction input) implements TransformerWithContext
    {
        static final Codec<BlendDensity> CODEC = DensityFunctions.singleFunctionArgumentCodec(BlendDensity::new, BlendDensity::input);

        @Override
        public double transform(DensityFunction.FunctionContext p_208553_, double p_208554_) {
            return p_208553_.getBlender().blendDensity(p_208553_, p_208554_);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208556_) {
            return (DensityFunction)p_208556_.apply(new BlendDensity(this.input.mapAll(p_208556_)));
        }

        @Override
        public double minValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected static enum BlendOffset implements DensityFunction.SimpleFunction
    {
        INSTANCE;

        public static final Codec<DensityFunction> CODEC;

        static {
            CODEC = Codec.unit((Object)INSTANCE);
        }

        @Override
        public double compute(DensityFunction.FunctionContext p_208573_) {
            return 0.0;
        }

        @Override
        public void a(double[] p_208575_, DensityFunction.ContextProvider p_208576_) {
            Arrays.fill(p_208575_, 0.0);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 0.0;
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record Clamp(DensityFunction input, double minValue, double maxValue) implements PureTransformer
    {
        private static final MapCodec<Clamp> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208597_ -> p_208597_.group((App)DensityFunction.DIRECT_CODEC.fieldOf("input").forGetter(Clamp::input), (App)NOISE_VALUE_CODEC.fieldOf("min").forGetter(Clamp::minValue), (App)NOISE_VALUE_CODEC.fieldOf("max").forGetter(Clamp::maxValue)).apply((Applicative)p_208597_, Clamp::new));
        public static final Codec<Clamp> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double transform(double p_208595_) {
            return Mth.clamp(p_208595_, this.minValue, this.maxValue);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208599_) {
            return new Clamp(this.input.mapAll(p_208599_), this.minValue, this.maxValue);
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record Constant(double value) implements DensityFunction.SimpleFunction
    {
        static final Codec<Constant> CODEC = DensityFunctions.singleArgumentCodec(NOISE_VALUE_CODEC, Constant::new, Constant::value);
        static final Constant ZERO = new Constant(0.0);

        @Override
        public double compute(DensityFunction.FunctionContext p_208615_) {
            return this.value;
        }

        @Override
        public void a(double[] p_208617_, DensityFunction.ContextProvider p_208618_) {
            Arrays.fill(p_208617_, this.value);
        }

        @Override
        public double minValue() {
            return this.value;
        }

        @Override
        public double maxValue() {
            return this.value;
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected static final class EndIslandDensityFunction
    implements DensityFunction.SimpleFunction {
        public static final Codec<EndIslandDensityFunction> CODEC = Codec.unit((Object)new EndIslandDensityFunction(0L));
        final SimplexNoise islandNoise;

        public EndIslandDensityFunction(long p_208630_) {
            LegacyRandomSource randomsource = new LegacyRandomSource(p_208630_);
            randomsource.consumeCount(17292);
            this.islandNoise = new SimplexNoise(randomsource);
        }

        @Override
        public double compute(DensityFunction.FunctionContext p_208633_) {
            return ((double)TheEndBiomeSource.getHeightValue(this.islandNoise, p_208633_.blockX() / 8, p_208633_.blockZ() / 8) - 8.0) / 128.0;
        }

        @Override
        public double minValue() {
            return -0.84375;
        }

        @Override
        public double maxValue() {
            return 0.5625;
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record HolderHolder(Holder<DensityFunction> function) implements DensityFunction
    {
        @Override
        public double compute(DensityFunction.FunctionContext p_208641_) {
            return this.function.value().compute(p_208641_);
        }

        @Override
        public void a(double[] p_208645_, DensityFunction.ContextProvider p_208646_) {
            this.function.value().a(p_208645_, p_208646_);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208643_) {
            return (DensityFunction)p_208643_.apply(new HolderHolder(new Holder.Direct<DensityFunction>(this.function.value().mapAll(p_208643_))));
        }

        @Override
        public double minValue() {
            return this.function.value().minValue();
        }

        @Override
        public double maxValue() {
            return this.function.value().maxValue();
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            throw new UnsupportedOperationException("Calling .codec() on HolderHolder");
        }
    }

    protected record Mapped(Type type, DensityFunction input, double minValue, double maxValue) implements PureTransformer
    {
        public static Mapped create(Type p_208672_, DensityFunction p_208673_) {
            double d0 = p_208673_.minValue();
            double d1 = Mapped.transform(p_208672_, d0);
            double d2 = Mapped.transform(p_208672_, p_208673_.maxValue());
            return p_208672_ != Type.ABS && p_208672_ != Type.SQUARE ? new Mapped(p_208672_, p_208673_, d1, d2) : new Mapped(p_208672_, p_208673_, Math.max(0.0, d0), Math.max(d1, d2));
        }

        private static double transform(Type p_208669_, double p_208670_) {
            return switch (p_208669_) {
                case Type.ABS -> Math.abs(p_208670_);
                case Type.SQUARE -> p_208670_ * p_208670_;
                case Type.CUBE -> p_208670_ * p_208670_ * p_208670_;
                case Type.HALF_NEGATIVE -> p_208670_ > 0.0 ? p_208670_ : p_208670_ * 0.5;
                case Type.QUARTER_NEGATIVE -> p_208670_ > 0.0 ? p_208670_ : p_208670_ * 0.25;
                case Type.SQUEEZE -> {
                    double d0 = Mth.clamp(p_208670_, -1.0, 1.0);
                    yield d0 / 2.0 - d0 * d0 * d0 / 24.0;
                }
                default -> throw new IncompatibleClassChangeError();
            };
        }

        @Override
        public double transform(double p_208665_) {
            return Mapped.transform(this.type, p_208665_);
        }

        @Override
        public Mapped mapAll(DensityFunction.Visitor p_208677_) {
            return Mapped.create(this.type, this.input.mapAll(p_208677_));
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return this.type.codec;
        }

        static enum Type implements StringRepresentable
        {
            ABS("abs"),
            SQUARE("square"),
            CUBE("cube"),
            HALF_NEGATIVE("half_negative"),
            QUARTER_NEGATIVE("quarter_negative"),
            SQUEEZE("squeeze");

            private final String name;
            final Codec<Mapped> codec = DensityFunctions.singleFunctionArgumentCodec(p_208700_ -> Mapped.create(this, p_208700_), Mapped::input);

            private Type(String p_208697_) {
                this.name = p_208697_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    protected record Marker(Type type, DensityFunction wrapped) implements MarkerOrMarked
    {
        @Override
        public double compute(DensityFunction.FunctionContext p_208712_) {
            return this.wrapped.compute(p_208712_);
        }

        @Override
        public void a(double[] p_208716_, DensityFunction.ContextProvider p_208717_) {
            this.wrapped.a(p_208716_, p_208717_);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208714_) {
            return (DensityFunction)p_208714_.apply(new Marker(this.type, this.wrapped.mapAll(p_208714_)));
        }

        @Override
        public double minValue() {
            return this.wrapped.minValue();
        }

        @Override
        public double maxValue() {
            return this.wrapped.maxValue();
        }

        static enum Type implements StringRepresentable
        {
            Interpolated("interpolated"),
            FlatCache("flat_cache"),
            Cache2D("cache_2d"),
            CacheOnce("cache_once"),
            CacheAllInCell("cache_all_in_cell");

            private final String name;
            final Codec<MarkerOrMarked> codec = DensityFunctions.singleFunctionArgumentCodec(p_208740_ -> new Marker(this, (DensityFunction)p_208740_), MarkerOrMarked::wrapped);

            private Type(String p_208737_) {
                this.name = p_208737_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    public static interface MarkerOrMarked
    extends DensityFunction {
        public Marker.Type type();

        public DensityFunction wrapped();

        @Override
        default public Codec<? extends DensityFunction> codec() {
            return this.type().codec;
        }
    }

    record MulOrAdd(Type specificType, DensityFunction input, double minValue, double maxValue, double argument) implements TwoArgumentSimpleFunction,
    PureTransformer
    {
        @Override
        public TwoArgumentSimpleFunction.Type type() {
            return this.specificType == Type.MUL ? TwoArgumentSimpleFunction.Type.MUL : TwoArgumentSimpleFunction.Type.ADD;
        }

        @Override
        public DensityFunction argument1() {
            return DensityFunctions.constant(this.argument);
        }

        @Override
        public DensityFunction argument2() {
            return this.input;
        }

        @Override
        public double transform(double p_208759_) {
            return switch (this.specificType) {
                case Type.MUL -> p_208759_ * this.argument;
                case Type.ADD -> p_208759_ + this.argument;
                default -> throw new IncompatibleClassChangeError();
            };
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208761_) {
            double d3;
            double d2;
            DensityFunction densityfunction = this.input.mapAll(p_208761_);
            double d0 = densityfunction.minValue();
            double d1 = densityfunction.maxValue();
            if (this.specificType == Type.ADD) {
                d2 = d0 + this.argument;
                d3 = d1 + this.argument;
            } else if (this.argument >= 0.0) {
                d2 = d0 * this.argument;
                d3 = d1 * this.argument;
            } else {
                d2 = d1 * this.argument;
                d3 = d0 * this.argument;
            }
            return new MulOrAdd(this.specificType, densityfunction, d2, d3, this.argument);
        }

        static enum Type {
            MUL,
            ADD;

        }
    }

    protected record Noise(Holder<NormalNoise.NoiseParameters> noiseData, @Nullable NormalNoise noise, double xzScale, double yScale) implements DensityFunction.SimpleFunction
    {
        public static final MapCodec<Noise> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208798_ -> p_208798_.group((App)NormalNoise.NoiseParameters.CODEC.fieldOf("noise").forGetter(Noise::noiseData), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(Noise::xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(Noise::yScale)).apply((Applicative)p_208798_, Noise::createUnseeded));
        public static final Codec<Noise> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        public static Noise createUnseeded(Holder<NormalNoise.NoiseParameters> p_208802_, @Deprecated double p_208803_, double p_208804_) {
            return new Noise(p_208802_, null, p_208803_, p_208804_);
        }

        @Override
        public double compute(DensityFunction.FunctionContext p_208800_) {
            return this.noise == null ? 0.0 : this.noise.getValue((double)p_208800_.blockX() * this.xzScale, (double)p_208800_.blockY() * this.yScale, (double)p_208800_.blockZ() * this.xzScale);
        }

        @Override
        public double minValue() {
            return -this.maxValue();
        }

        @Override
        public double maxValue() {
            return this.noise == null ? 2.0 : this.noise.maxValue();
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    static interface PureTransformer
    extends DensityFunction {
        public DensityFunction input();

        @Override
        default public double compute(DensityFunction.FunctionContext p_208817_) {
            return this.transform(this.input().compute(p_208817_));
        }

        @Override
        default public void a(double[] p_208819_, DensityFunction.ContextProvider p_208820_) {
            this.input().a(p_208819_, p_208820_);
            int i = 0;
            while (i < p_208819_.length) {
                p_208819_[i] = this.transform(p_208819_[i]);
                ++i;
            }
        }

        public double transform(double var1);
    }

    record RangeChoice(DensityFunction input, double minInclusive, double maxExclusive, DensityFunction whenInRange, DensityFunction whenOutOfRange) implements DensityFunction
    {
        public static final MapCodec<RangeChoice> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208837_ -> p_208837_.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(RangeChoice::input), (App)NOISE_VALUE_CODEC.fieldOf("min_inclusive").forGetter(RangeChoice::minInclusive), (App)NOISE_VALUE_CODEC.fieldOf("max_exclusive").forGetter(RangeChoice::maxExclusive), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("when_in_range").forGetter(RangeChoice::whenInRange), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("when_out_of_range").forGetter(RangeChoice::whenOutOfRange)).apply((Applicative)p_208837_, RangeChoice::new));
        public static final Codec<RangeChoice> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext p_208839_) {
            double d0 = this.input.compute(p_208839_);
            return d0 >= this.minInclusive && d0 < this.maxExclusive ? this.whenInRange.compute(p_208839_) : this.whenOutOfRange.compute(p_208839_);
        }

        @Override
        public void a(double[] p_208843_, DensityFunction.ContextProvider p_208844_) {
            this.input.a(p_208843_, p_208844_);
            int i = 0;
            while (i < p_208843_.length) {
                double d0 = p_208843_[i];
                p_208843_[i] = d0 >= this.minInclusive && d0 < this.maxExclusive ? this.whenInRange.compute(p_208844_.forIndex(i)) : this.whenOutOfRange.compute(p_208844_.forIndex(i));
                ++i;
            }
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208841_) {
            return (DensityFunction)p_208841_.apply(new RangeChoice(this.input.mapAll(p_208841_), this.minInclusive, this.maxExclusive, this.whenInRange.mapAll(p_208841_), this.whenOutOfRange.mapAll(p_208841_)));
        }

        @Override
        public double minValue() {
            return Math.min(this.whenInRange.minValue(), this.whenOutOfRange.minValue());
        }

        @Override
        public double maxValue() {
            return Math.max(this.whenInRange.maxValue(), this.whenOutOfRange.maxValue());
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    record Shift(Holder<NormalNoise.NoiseParameters> noiseData, @Nullable NormalNoise offsetNoise) implements ShiftNoise
    {
        static final Codec<Shift> CODEC = DensityFunctions.singleArgumentCodec(NormalNoise.NoiseParameters.CODEC, p_208868_ -> new Shift((Holder<NormalNoise.NoiseParameters>)p_208868_, null), Shift::noiseData);

        @Override
        public double compute(DensityFunction.FunctionContext p_208864_) {
            return this.compute(p_208864_.blockX(), p_208864_.blockY(), p_208864_.blockZ());
        }

        @Override
        public ShiftNoise withNewNoise(NormalNoise p_208866_) {
            return new Shift(this.noiseData, p_208866_);
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record ShiftA(Holder<NormalNoise.NoiseParameters> noiseData, @Nullable NormalNoise offsetNoise) implements ShiftNoise
    {
        static final Codec<ShiftA> CODEC = DensityFunctions.singleArgumentCodec(NormalNoise.NoiseParameters.CODEC, p_208888_ -> new ShiftA((Holder<NormalNoise.NoiseParameters>)p_208888_, null), ShiftA::noiseData);

        @Override
        public double compute(DensityFunction.FunctionContext p_208884_) {
            return this.compute(p_208884_.blockX(), 0.0, p_208884_.blockZ());
        }

        @Override
        public ShiftNoise withNewNoise(NormalNoise p_208886_) {
            return new ShiftA(this.noiseData, p_208886_);
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record ShiftB(Holder<NormalNoise.NoiseParameters> noiseData, @Nullable NormalNoise offsetNoise) implements ShiftNoise
    {
        static final Codec<ShiftB> CODEC = DensityFunctions.singleArgumentCodec(NormalNoise.NoiseParameters.CODEC, p_208908_ -> new ShiftB((Holder<NormalNoise.NoiseParameters>)p_208908_, null), ShiftB::noiseData);

        @Override
        public double compute(DensityFunction.FunctionContext p_208904_) {
            return this.compute(p_208904_.blockZ(), p_208904_.blockX(), 0.0);
        }

        @Override
        public ShiftNoise withNewNoise(NormalNoise p_208906_) {
            return new ShiftB(this.noiseData, p_208906_);
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    static interface ShiftNoise
    extends DensityFunction.SimpleFunction {
        public Holder<NormalNoise.NoiseParameters> noiseData();

        @Nullable
        public NormalNoise offsetNoise();

        @Override
        default public double minValue() {
            return -this.maxValue();
        }

        @Override
        default public double maxValue() {
            NormalNoise normalnoise = this.offsetNoise();
            return (normalnoise == null ? 2.0 : normalnoise.maxValue()) * 4.0;
        }

        default public double compute(double p_208918_, double p_208919_, double p_208920_) {
            NormalNoise normalnoise = this.offsetNoise();
            return normalnoise == null ? 0.0 : normalnoise.getValue(p_208918_ * 0.25, p_208919_ * 0.25, p_208920_ * 0.25) * 4.0;
        }

        public ShiftNoise withNewNoise(NormalNoise var1);
    }

    protected record ShiftedNoise(DensityFunction shiftX, DensityFunction shiftY, DensityFunction shiftZ, double xzScale, double yScale, Holder<NormalNoise.NoiseParameters> noiseData, @Nullable NormalNoise noise) implements DensityFunction
    {
        private static final MapCodec<ShiftedNoise> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208943_ -> p_208943_.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_x").forGetter(ShiftedNoise::shiftX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_y").forGetter(ShiftedNoise::shiftY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("shift_z").forGetter(ShiftedNoise::shiftZ), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(ShiftedNoise::xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(ShiftedNoise::yScale), (App)NormalNoise.NoiseParameters.CODEC.fieldOf("noise").forGetter(ShiftedNoise::noiseData)).apply((Applicative)p_208943_, ShiftedNoise::createUnseeded));
        public static final Codec<ShiftedNoise> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        public static ShiftedNoise createUnseeded(DensityFunction p_208949_, DensityFunction p_208950_, DensityFunction p_208951_, double p_208952_, double p_208953_, Holder<NormalNoise.NoiseParameters> p_208954_) {
            return new ShiftedNoise(p_208949_, p_208950_, p_208951_, p_208952_, p_208953_, p_208954_, null);
        }

        @Override
        public double compute(DensityFunction.FunctionContext p_208945_) {
            if (this.noise == null) {
                return 0.0;
            }
            double d0 = (double)p_208945_.blockX() * this.xzScale + this.shiftX.compute(p_208945_);
            double d1 = (double)p_208945_.blockY() * this.yScale + this.shiftY.compute(p_208945_);
            double d2 = (double)p_208945_.blockZ() * this.xzScale + this.shiftZ.compute(p_208945_);
            return this.noise.getValue(d0, d1, d2);
        }

        @Override
        public void a(double[] p_208956_, DensityFunction.ContextProvider p_208957_) {
            p_208957_.a(p_208956_, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208947_) {
            return (DensityFunction)p_208947_.apply(new ShiftedNoise(this.shiftX.mapAll(p_208947_), this.shiftY.mapAll(p_208947_), this.shiftZ.mapAll(p_208947_), this.xzScale, this.yScale, this.noiseData, this.noise));
        }

        @Override
        public double minValue() {
            return -this.maxValue();
        }

        @Override
        public double maxValue() {
            return this.noise == null ? 2.0 : this.noise.maxValue();
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    protected record Slide(@Nullable NoiseSettings settings, DensityFunction input) implements TransformerWithContext
    {
        public static final Codec<Slide> CODEC = DensityFunctions.singleFunctionArgumentCodec(p_208985_ -> new Slide(null, (DensityFunction)p_208985_), Slide::input);

        @Override
        public double transform(DensityFunction.FunctionContext p_208980_, double p_208981_) {
            return this.settings == null ? p_208981_ : NoiseRouterData.applySlide(this.settings, p_208981_, p_208980_.blockY());
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208983_) {
            return (DensityFunction)p_208983_.apply(new Slide(this.settings, this.input.mapAll(p_208983_)));
        }

        @Override
        public double minValue() {
            return this.settings == null ? this.input.minValue() : Math.min(this.input.minValue(), Math.min(this.settings.bottomSlideSettings().target(), this.settings.topSlideSettings().target()));
        }

        @Override
        public double maxValue() {
            return this.settings == null ? this.input.maxValue() : Math.max(this.input.maxValue(), Math.max(this.settings.bottomSlideSettings().target(), this.settings.topSlideSettings().target()));
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    public record Spline(CubicSpline<TerrainShaper.PointCustom> spline, double minValue, double maxValue) implements DensityFunction
    {
        private static final MapCodec<Spline> DATA_CODEC = RecordCodecBuilder.mapCodec(p_211713_ -> p_211713_.group((App)TerrainShaper.SPLINE_CUSTOM_CODEC.fieldOf("spline").forGetter(Spline::spline), (App)NOISE_VALUE_CODEC.fieldOf("min_value").forGetter(Spline::minValue), (App)NOISE_VALUE_CODEC.fieldOf("max_value").forGetter(Spline::maxValue)).apply((Applicative)p_211713_, Spline::new));
        public static final Codec<Spline> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext p_211715_) {
            return Mth.clamp((double)this.spline.apply(TerrainShaper.makePoint(p_211715_)), this.minValue, this.maxValue);
        }

        @Override
        public void a(double[] p_211722_, DensityFunction.ContextProvider p_211723_) {
            p_211723_.a(p_211722_, this);
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_211717_) {
            return (DensityFunction)p_211717_.apply(new Spline(this.spline.mapAll((ToFloatFunction<C> p_211720_) -> {
                ToFloatFunction object;
                if (p_211720_ instanceof TerrainShaper.CoordinateCustom) {
                    TerrainShaper.CoordinateCustom terrainshaper$coordinatecustom = (TerrainShaper.CoordinateCustom)p_211720_;
                    object = terrainshaper$coordinatecustom.mapAll(p_211717_);
                } else {
                    object = p_211720_;
                }
                return object;
            }), this.minValue, this.maxValue));
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }

    @Deprecated
    public record TerrainShaperSpline(DensityFunction continentalness, DensityFunction erosion, DensityFunction weirdness, @Nullable TerrainShaper shaper, SplineType spline, double minValue, double maxValue) implements DensityFunction
    {
        private static final MapCodec<TerrainShaperSpline> DATA_CODEC = RecordCodecBuilder.mapCodec(p_209014_ -> p_209014_.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("continentalness").forGetter(TerrainShaperSpline::continentalness), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("erosion").forGetter(TerrainShaperSpline::erosion), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("weirdness").forGetter(TerrainShaperSpline::weirdness), (App)SplineType.CODEC.fieldOf("spline").forGetter(TerrainShaperSpline::spline), (App)NOISE_VALUE_CODEC.fieldOf("min_value").forGetter(TerrainShaperSpline::minValue), (App)NOISE_VALUE_CODEC.fieldOf("max_value").forGetter(TerrainShaperSpline::maxValue)).apply((Applicative)p_209014_, TerrainShaperSpline::createUnseeded));
        public static final Codec<TerrainShaperSpline> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        public static TerrainShaperSpline createUnseeded(DensityFunction p_209020_, DensityFunction p_209021_, DensityFunction p_209022_, SplineType p_209023_, double p_209024_, double p_209025_) {
            return new TerrainShaperSpline(p_209020_, p_209021_, p_209022_, null, p_209023_, p_209024_, p_209025_);
        }

        @Override
        public double compute(DensityFunction.FunctionContext p_209016_) {
            return this.shaper == null ? 0.0 : Mth.clamp((double)this.spline.spline.apply(this.shaper, TerrainShaper.makePoint((float)this.continentalness.compute(p_209016_), (float)this.erosion.compute(p_209016_), (float)this.weirdness.compute(p_209016_))), this.minValue, this.maxValue);
        }

        @Override
        public void a(double[] p_209027_, DensityFunction.ContextProvider p_209028_) {
            int i = 0;
            while (i < p_209027_.length) {
                p_209027_[i] = this.compute(p_209028_.forIndex(i));
                ++i;
            }
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_209018_) {
            return (DensityFunction)p_209018_.apply(new TerrainShaperSpline(this.continentalness.mapAll(p_209018_), this.erosion.mapAll(p_209018_), this.weirdness.mapAll(p_209018_), this.shaper, this.spline, this.minValue, this.maxValue));
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }

        static interface Spline {
            public float apply(TerrainShaper var1, TerrainShaper.Point var2);
        }

        public static enum SplineType implements StringRepresentable
        {
            OFFSET("offset", TerrainShaper::offset),
            FACTOR("factor", TerrainShaper::factor),
            JAGGEDNESS("jaggedness", TerrainShaper::jaggedness);

            private static final Map<String, SplineType> BY_NAME;
            public static final Codec<SplineType> CODEC;
            private final String name;
            final Spline spline;

            static {
                BY_NAME = Arrays.stream(SplineType.values()).collect(Collectors.toMap(SplineType::getSerializedName, p_209059_ -> p_209059_));
                CODEC = StringRepresentable.fromEnum(SplineType::values, BY_NAME::get);
            }

            private SplineType(String p_209055_, Spline p_209056_) {
                this.name = p_209055_;
                this.spline = p_209056_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    static interface TransformerWithContext
    extends DensityFunction {
        public DensityFunction input();

        @Override
        default public double compute(DensityFunction.FunctionContext p_209065_) {
            return this.transform(p_209065_, this.input().compute(p_209065_));
        }

        @Override
        default public void a(double[] p_209069_, DensityFunction.ContextProvider p_209070_) {
            this.input().a(p_209069_, p_209070_);
            int i = 0;
            while (i < p_209069_.length) {
                p_209069_[i] = this.transform(p_209070_.forIndex(i), p_209069_[i]);
                ++i;
            }
        }

        public double transform(DensityFunction.FunctionContext var1, double var2);
    }

    static interface TwoArgumentSimpleFunction
    extends DensityFunction {
        public static final Logger LOGGER = LogUtils.getLogger();
        public static final /* synthetic */ int[] $SWITCH_TABLE$net$minecraft$world$level$levelgen$DensityFunctions$TwoArgumentSimpleFunction$Type;

        static {
            $SWITCH_TABLE$net$minecraft$world$level$levelgen$DensityFunctions$TwoArgumentSimpleFunction$Type = TwoArgumentSimpleFunction.$SWITCH_TABLE$net$minecraft$world$level$levelgen$DensityFunctions$TwoArgumentSimpleFunction$Type();
        }

        public static TwoArgumentSimpleFunction create(Type p_209074_, DensityFunction p_209075_, DensityFunction p_209076_) {
            double d0 = p_209075_.minValue();
            double d1 = p_209076_.minValue();
            double d2 = p_209075_.maxValue();
            double d3 = p_209076_.maxValue();
            if (p_209074_ == Type.MIN || p_209074_ == Type.MAX) {
                boolean flag1;
                boolean flag = d0 >= d3;
                boolean bl = flag1 = d1 >= d2;
                if (flag || flag1) {
                    LOGGER.warn("Creating a " + p_209074_ + " function between two non-overlapping inputs: " + p_209075_ + " and " + p_209076_);
                }
            }
            double d6 = switch (p_209074_) {
                case Type.ADD -> d0 + d1;
                case Type.MAX -> Math.max(d0, d1);
                case Type.MIN -> Math.min(d0, d1);
                case Type.MUL -> d0 > 0.0 && d1 > 0.0 ? d0 * d1 : (d2 < 0.0 && d3 < 0.0 ? d2 * d3 : Math.min(d0 * d3, d2 * d1));
                default -> throw new IncompatibleClassChangeError();
            };
            double d5 = d6;
            switch (p_209074_) {
                case ADD: {
                    d6 = d2 + d3;
                    break;
                }
                case MAX: {
                    d6 = Math.max(d2, d3);
                    break;
                }
                case MIN: {
                    d6 = Math.min(d2, d3);
                    break;
                }
                case MUL: {
                    d6 = d0 > 0.0 && d1 > 0.0 ? d2 * d3 : (d2 < 0.0 && d3 < 0.0 ? d0 * d1 : Math.max(d0 * d1, d2 * d3));
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            double d4 = d6;
            if (p_209074_ == Type.MUL || p_209074_ == Type.ADD) {
                if (p_209075_ instanceof Constant) {
                    Constant densityfunctions$constant1 = (Constant)p_209075_;
                    return new MulOrAdd(p_209074_ == Type.ADD ? MulOrAdd.Type.ADD : MulOrAdd.Type.MUL, p_209076_, d5, d4, densityfunctions$constant1.value);
                }
                if (p_209076_ instanceof Constant) {
                    Constant densityfunctions$constant = (Constant)p_209076_;
                    return new MulOrAdd(p_209074_ == Type.ADD ? MulOrAdd.Type.ADD : MulOrAdd.Type.MUL, p_209075_, d5, d4, densityfunctions$constant.value);
                }
            }
            return new Ap2(p_209074_, p_209075_, p_209076_, d5, d4);
        }

        public Type type();

        public DensityFunction argument1();

        public DensityFunction argument2();

        @Override
        default public Codec<? extends DensityFunction> codec() {
            return this.type().codec;
        }

        public static enum Type implements StringRepresentable
        {
            ADD("add"),
            MUL("mul"),
            MIN("min"),
            MAX("max");

            final Codec<TwoArgumentSimpleFunction> codec = DensityFunctions.doubleFunctionArgumentCodec((p_209092_, p_209093_) -> TwoArgumentSimpleFunction.create(this, p_209092_, p_209093_), TwoArgumentSimpleFunction::argument1, TwoArgumentSimpleFunction::argument2);
            private final String name;

            private Type(String p_209089_) {
                this.name = p_209089_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    protected record WeirdScaledSampler(DensityFunction input, Holder<NormalNoise.NoiseParameters> noiseData, @Nullable NormalNoise noise, RarityValueMapper rarityValueMapper) implements TransformerWithContext
    {
        private static final MapCodec<WeirdScaledSampler> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208438_ -> p_208438_.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(WeirdScaledSampler::input), (App)NormalNoise.NoiseParameters.CODEC.fieldOf("noise").forGetter(WeirdScaledSampler::noiseData), (App)RarityValueMapper.CODEC.fieldOf("rarity_value_mapper").forGetter(WeirdScaledSampler::rarityValueMapper)).apply((Applicative)p_208438_, WeirdScaledSampler::createUnseeded));
        public static final Codec<WeirdScaledSampler> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        public static WeirdScaledSampler createUnseeded(DensityFunction p_208445_, Holder<NormalNoise.NoiseParameters> p_208446_, RarityValueMapper p_208447_) {
            return new WeirdScaledSampler(p_208445_, p_208446_, null, p_208447_);
        }

        @Override
        public double transform(DensityFunction.FunctionContext p_208440_, double p_208441_) {
            if (this.noise == null) {
                return 0.0;
            }
            double d0 = this.rarityValueMapper.mapper.get(p_208441_);
            return d0 * Math.abs(this.noise.getValue((double)p_208440_.blockX() / d0, (double)p_208440_.blockY() / d0, (double)p_208440_.blockZ() / d0));
        }

        @Override
        public DensityFunction mapAll(DensityFunction.Visitor p_208443_) {
            this.input.mapAll(p_208443_);
            return (DensityFunction)p_208443_.apply(new WeirdScaledSampler(this.input.mapAll(p_208443_), this.noiseData, this.noise, this.rarityValueMapper));
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return this.rarityValueMapper.maxRarity * (this.noise == null ? 2.0 : this.noise.maxValue());
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }

        public static enum RarityValueMapper implements StringRepresentable
        {
            TYPE1("type_1", NoiseRouterData.QuantizedSpaghettiRarity::getSpaghettiRarity3D, 2.0),
            TYPE2("type_2", NoiseRouterData.QuantizedSpaghettiRarity::getSphaghettiRarity2D, 3.0);

            private static final Map<String, RarityValueMapper> BY_NAME;
            public static final Codec<RarityValueMapper> CODEC;
            private final String name;
            final Double2DoubleFunction mapper;
            final double maxRarity;

            static {
                BY_NAME = Arrays.stream(RarityValueMapper.values()).collect(Collectors.toMap(RarityValueMapper::getSerializedName, p_208475_ -> p_208475_));
                CODEC = StringRepresentable.fromEnum(RarityValueMapper::values, BY_NAME::get);
            }

            private RarityValueMapper(String p_208470_, Double2DoubleFunction p_208471_, double p_208472_) {
                this.name = p_208470_;
                this.mapper = p_208471_;
                this.maxRarity = p_208472_;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }
        }
    }

    record YClampedGradient(int fromY, int toY, double fromValue, double toValue) implements DensityFunction.SimpleFunction
    {
        private static final MapCodec<YClampedGradient> DATA_CODEC = RecordCodecBuilder.mapCodec(p_208494_ -> p_208494_.group((App)Codec.intRange((int)(DimensionType.MIN_Y * 2), (int)(DimensionType.MAX_Y * 2)).fieldOf("from_y").forGetter(YClampedGradient::fromY), (App)Codec.intRange((int)(DimensionType.MIN_Y * 2), (int)(DimensionType.MAX_Y * 2)).fieldOf("to_y").forGetter(YClampedGradient::toY), (App)NOISE_VALUE_CODEC.fieldOf("from_value").forGetter(YClampedGradient::fromValue), (App)NOISE_VALUE_CODEC.fieldOf("to_value").forGetter(YClampedGradient::toValue)).apply((Applicative)p_208494_, YClampedGradient::new));
        public static final Codec<YClampedGradient> CODEC = DensityFunctions.makeCodec(DATA_CODEC);

        @Override
        public double compute(DensityFunction.FunctionContext p_208496_) {
            return Mth.clampedMap((double)p_208496_.blockY(), (double)this.fromY, (double)this.toY, this.fromValue, this.toValue);
        }

        @Override
        public double minValue() {
            return Math.min(this.fromValue, this.toValue);
        }

        @Override
        public double maxValue() {
            return Math.max(this.fromValue, this.toValue);
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return CODEC;
        }
    }
}

