/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class FlatLevelSource
extends ChunkGenerator {
    public static final Codec<FlatLevelSource> CODEC = RecordCodecBuilder.create(p_204551_ -> FlatLevelSource.commonCodec(p_204551_).and((App)FlatLevelGeneratorSettings.CODEC.fieldOf("settings").forGetter(FlatLevelSource::settings)).apply((Applicative)p_204551_, p_204551_.stable(FlatLevelSource::new)));
    private final FlatLevelGeneratorSettings settings;

    public FlatLevelSource(Registry<StructureSet> p_209099_, FlatLevelGeneratorSettings p_209100_) {
        super(p_209099_, p_209100_.structureOverrides(), new FixedBiomeSource(p_209100_.getBiomeFromSettings()), new FixedBiomeSource(p_209100_.getBiome()), 0L);
        this.settings = p_209100_;
    }

    @Override
    protected Codec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    @Override
    public ChunkGenerator withSeed(long pSeed) {
        return this;
    }

    public FlatLevelGeneratorSettings settings() {
        return this.settings;
    }

    @Override
    public void buildSurface(WorldGenRegion p_188554_, StructureFeatureManager p_188555_, ChunkAccess p_188556_) {
    }

    @Override
    public int getSpawnHeight(LevelHeightAccessor pLevel) {
        return pLevel.getMinBuildHeight() + Math.min(pLevel.getHeight(), this.settings.getLayers().size());
    }

    @Override
    protected Holder<Biome> adjustBiome(Holder<Biome> p_204553_) {
        return this.settings.getBiome();
    }

    @Override
    public CompletableFuture<ChunkAccess> fillFromNoise(Executor p_188562_, Blender p_188563_, StructureFeatureManager p_188564_, ChunkAccess p_188565_) {
        List<BlockState> list = this.settings.getLayers();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        Heightmap heightmap = p_188565_.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = p_188565_.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        int i = 0;
        while (i < Math.min(p_188565_.getHeight(), list.size())) {
            BlockState blockstate = list.get(i);
            if (blockstate != null) {
                int j = p_188565_.getMinBuildHeight() + i;
                int k = 0;
                while (k < 16) {
                    int l = 0;
                    while (l < 16) {
                        p_188565_.setBlockState(blockpos$mutableblockpos.set(k, j, l), blockstate, false);
                        heightmap.update(k, j, l, blockstate);
                        heightmap1.update(k, j, l, blockstate);
                        ++l;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return CompletableFuture.completedFuture(p_188565_);
    }

    @Override
    public int getBaseHeight(int pX, int pZ, Heightmap.Types pType, LevelHeightAccessor pLevel) {
        List<BlockState> list = this.settings.getLayers();
        int i = Math.min(list.size(), pLevel.getMaxBuildHeight()) - 1;
        while (i >= 0) {
            BlockState blockstate = list.get(i);
            if (blockstate != null && pType.isOpaque().test(blockstate)) {
                return pLevel.getMinBuildHeight() + i + 1;
            }
            --i;
        }
        return pLevel.getMinBuildHeight();
    }

    @Override
    public NoiseColumn getBaseColumn(int pX, int pZ, LevelHeightAccessor pLevel) {
        return new NoiseColumn(pLevel.getMinBuildHeight(), (BlockState[])this.settings.getLayers().stream().limit(pLevel.getHeight()).map(p_204549_ -> p_204549_ == null ? Blocks.AIR.defaultBlockState() : p_204549_).toArray(BlockState[]::new));
    }

    @Override
    public void addDebugScreenInfo(List<String> p_209102_, BlockPos p_209103_) {
    }

    @Override
    public Climate.Sampler climateSampler() {
        return Climate.empty();
    }

    @Override
    public void applyCarvers(WorldGenRegion p_188547_, long p_188548_, BiomeManager p_188549_, StructureFeatureManager p_188550_, ChunkAccess p_188551_, GenerationStep.Carving p_188552_) {
    }

    @Override
    public void spawnOriginalMobs(WorldGenRegion pLevel) {
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getGenDepth() {
        return 384;
    }

    @Override
    public int getSeaLevel() {
        return -63;
    }
}

