/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;

public class GenerationStep {

    public static enum Carving implements StringRepresentable
    {
        AIR("air"),
        LIQUID("liquid");

        public static final Codec<Carving> CODEC;
        private static final Map<String, Carving> BY_NAME;
        private final String name;

        static {
            CODEC = StringRepresentable.fromEnum(Carving::values, Carving::byName);
            BY_NAME = Arrays.stream(Carving.values()).collect(Collectors.toMap(Carving::getName, p_64205_ -> p_64205_));
        }

        private Carving(String p_64202_) {
            this.name = p_64202_;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static Carving byName(String p_64207_) {
            return BY_NAME.get(p_64207_);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum Decoration {
        RAW_GENERATION,
        LAKES,
        LOCAL_MODIFICATIONS,
        UNDERGROUND_STRUCTURES,
        SURFACE_STRUCTURES,
        STRONGHOLDS,
        UNDERGROUND_ORES,
        UNDERGROUND_DECORATION,
        FLUID_SPRINGS,
        VEGETAL_DECORATION,
        TOP_LAYER_MODIFICATION;

    }
}

