/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.slf4j.Logger;

public class Heightmap {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Predicate<BlockState> NOT_AIR = p_64263_ -> !p_64263_.isAir();
    static final Predicate<BlockState> MATERIAL_MOTION_BLOCKING = p_64255_ -> p_64255_.getMaterial().blocksMotion();
    private final BitStorage data;
    private final Predicate<BlockState> isOpaque;
    private final ChunkAccess chunk;

    public Heightmap(ChunkAccess pChunk, Types pType) {
        this.isOpaque = pType.isOpaque();
        this.chunk = pChunk;
        int i = Mth.ceillog2(pChunk.getHeight() + 1);
        this.data = new SimpleBitStorage(i, 256);
    }

    public static void primeHeightmaps(ChunkAccess pChunk, Set<Types> pTypes) {
        int i = pTypes.size();
        ObjectArrayList objectlist = new ObjectArrayList(i);
        ObjectListIterator objectlistiterator = objectlist.iterator();
        int j = pChunk.getHighestSectionPosition() + 16;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k = 0;
        while (k < 16) {
            int l = 0;
            while (l < 16) {
                for (Types heightmap$types : pTypes) {
                    objectlist.add((Object)pChunk.getOrCreateHeightmapUnprimed(heightmap$types));
                }
                int i1 = j - 1;
                while (i1 >= pChunk.getMinBuildHeight()) {
                    blockpos$mutableblockpos.set(k, i1, l);
                    BlockState blockstate = pChunk.getBlockState(blockpos$mutableblockpos);
                    if (!blockstate.is(Blocks.AIR)) {
                        while (objectlistiterator.hasNext()) {
                            Heightmap heightmap = (Heightmap)objectlistiterator.next();
                            if (!heightmap.isOpaque.test(blockstate)) continue;
                            heightmap.setHeight(k, l, i1 + 1);
                            objectlistiterator.remove();
                        }
                        if (objectlist.isEmpty()) break;
                        objectlistiterator.back(i);
                    }
                    --i1;
                }
                ++l;
            }
            ++k;
        }
    }

    public boolean update(int pX, int pY, int pZ, BlockState pState) {
        int i = this.getFirstAvailable(pX, pZ);
        if (pY <= i - 2) {
            return false;
        }
        if (this.isOpaque.test(pState)) {
            if (pY >= i) {
                this.setHeight(pX, pZ, pY + 1);
                return true;
            }
        } else if (i - 1 == pY) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int j = pY - 1;
            while (j >= this.chunk.getMinBuildHeight()) {
                blockpos$mutableblockpos.set(pX, j, pZ);
                if (this.isOpaque.test(this.chunk.getBlockState(blockpos$mutableblockpos))) {
                    this.setHeight(pX, pZ, j + 1);
                    return true;
                }
                --j;
            }
            this.setHeight(pX, pZ, this.chunk.getMinBuildHeight());
            return true;
        }
        return false;
    }

    public int getFirstAvailable(int pX, int pZ) {
        return this.getFirstAvailable(Heightmap.getIndex(pX, pZ));
    }

    public int getHighestTaken(int pX, int pZ) {
        return this.getFirstAvailable(Heightmap.getIndex(pX, pZ)) - 1;
    }

    private int getFirstAvailable(int pIndex) {
        return this.data.get(pIndex) + this.chunk.getMinBuildHeight();
    }

    private void setHeight(int pX, int pZ, int pValue) {
        this.data.set(Heightmap.getIndex(pX, pZ), pValue - this.chunk.getMinBuildHeight());
    }

    public void a(ChunkAccess p_158365_, Types p_158366_, long[] p_158367_) {
        long[] along = this.data.getRaw();
        if (along.length == p_158367_.length) {
            System.arraycopy(p_158367_, 0, along, 0, p_158367_.length);
        } else {
            LOGGER.warn("Ignoring heightmap data for chunk " + p_158365_.getPos() + ", size does not match; expected: " + along.length + ", got: " + p_158367_.length);
            Heightmap.primeHeightmaps(p_158365_, EnumSet.of(p_158366_));
        }
    }

    public long[] getRawData() {
        return this.data.getRaw();
    }

    private static int getIndex(int pX, int pZ) {
        return pX + pZ * 16;
    }

    public static enum Types implements StringRepresentable
    {
        WORLD_SURFACE_WG("WORLD_SURFACE_WG", Usage.WORLDGEN, NOT_AIR),
        WORLD_SURFACE("WORLD_SURFACE", Usage.CLIENT, NOT_AIR),
        OCEAN_FLOOR_WG("OCEAN_FLOOR_WG", Usage.WORLDGEN, MATERIAL_MOTION_BLOCKING),
        OCEAN_FLOOR("OCEAN_FLOOR", Usage.LIVE_WORLD, MATERIAL_MOTION_BLOCKING),
        MOTION_BLOCKING("MOTION_BLOCKING", Usage.CLIENT, p_64296_ -> p_64296_.getMaterial().blocksMotion() || !p_64296_.getFluidState().isEmpty()),
        MOTION_BLOCKING_NO_LEAVES("MOTION_BLOCKING_NO_LEAVES", Usage.LIVE_WORLD, p_64289_ -> (p_64289_.getMaterial().blocksMotion() || !p_64289_.getFluidState().isEmpty()) && !(p_64289_.getBlock() instanceof LeavesBlock));

        public static final Codec<Types> CODEC;
        private final String serializationKey;
        private final Usage usage;
        private final Predicate<BlockState> isOpaque;
        private static final Map<String, Types> REVERSE_LOOKUP;

        static {
            CODEC = StringRepresentable.fromEnum(Types::values, Types::getFromKey);
            REVERSE_LOOKUP = Util.make(Maps.newHashMap(), p_64293_ -> {
                Types[] typesArray = Types.values();
                int n = typesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Types heightmap$types = typesArray[n2];
                    p_64293_.put(heightmap$types.serializationKey, heightmap$types);
                    ++n2;
                }
            });
        }

        private Types(String p_64284_, Usage p_64285_, Predicate<BlockState> p_64286_) {
            this.serializationKey = p_64284_;
            this.usage = p_64285_;
            this.isOpaque = p_64286_;
        }

        public String getSerializationKey() {
            return this.serializationKey;
        }

        public boolean sendToClient() {
            return this.usage == Usage.CLIENT;
        }

        public boolean keepAfterWorldgen() {
            return this.usage != Usage.WORLDGEN;
        }

        @Nullable
        public static Types getFromKey(String p_64291_) {
            return REVERSE_LOOKUP.get(p_64291_);
        }

        public Predicate<BlockState> isOpaque() {
            return this.isOpaque;
        }

        @Override
        public String getSerializedName() {
            return this.serializationKey;
        }
    }

    public static enum Usage {
        WORLDGEN,
        LIVE_WORLD,
        CLIENT;

    }
}

