/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.util.Mth;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;

public class LegacyRandomSource
implements BitRandomSource {
    private static final int MODULUS_BITS = 48;
    private static final long MODULUS_MASK = 0xFFFFFFFFFFFFL;
    private static final long MULTIPLIER = 25214903917L;
    private static final long INCREMENT = 11L;
    private final AtomicLong seed = new AtomicLong();
    private final MarsagliaPolarGaussian gaussianSource = new MarsagliaPolarGaussian(this);

    public LegacyRandomSource(long p_188578_) {
        this.setSeed(p_188578_);
    }

    @Override
    public RandomSource fork() {
        return new LegacyRandomSource(this.nextLong());
    }

    @Override
    public PositionalRandomFactory forkPositional() {
        return new LegacyPositionalRandomFactory(this.nextLong());
    }

    @Override
    public void setSeed(long p_188585_) {
        if (!this.seed.compareAndSet(this.seed.get(), (p_188585_ ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.makeThreadingException("LegacyRandomSource", null);
        }
        this.gaussianSource.reset();
    }

    @Override
    public int next(int p_188581_) {
        long j;
        long i = this.seed.get();
        if (!this.seed.compareAndSet(i, j = i * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.makeThreadingException("LegacyRandomSource", null);
        }
        return (int)(j >> 48 - p_188581_);
    }

    @Override
    public double nextGaussian() {
        return this.gaussianSource.nextGaussian();
    }

    public static class LegacyPositionalRandomFactory
    implements PositionalRandomFactory {
        private final long seed;

        public LegacyPositionalRandomFactory(long p_188588_) {
            this.seed = p_188588_;
        }

        @Override
        public RandomSource at(int p_188590_, int p_188591_, int p_188592_) {
            long i = Mth.getSeed(p_188590_, p_188591_, p_188592_);
            long j = i ^ this.seed;
            return new LegacyRandomSource(j);
        }

        @Override
        public RandomSource fromHashOf(String p_188594_) {
            int i = p_188594_.hashCode();
            return new LegacyRandomSource((long)i ^ this.seed);
        }

        @Override
        @VisibleForTesting
        public void parityConfigString(StringBuilder p_188596_) {
            p_188596_.append("LegacyPositionalRandomFactory{").append(this.seed).append("}");
        }
    }
}

