/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterWithOnlyNoises;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseRouterData {
    private static final float ORE_THICKNESS = 0.08f;
    private static final double VEININESS_FREQUENCY = 1.5;
    private static final double NOODLE_SPACING_AND_STRAIGHTNESS = 1.5;
    private static final double SURFACE_DENSITY_THRESHOLD = 1.5625;
    private static final DensityFunction BLENDING_FACTOR = DensityFunctions.constant(10.0);
    private static final DensityFunction BLENDING_JAGGEDNESS = DensityFunctions.zero();
    private static final ResourceKey<DensityFunction> ZERO = NoiseRouterData.createKey("zero");
    private static final ResourceKey<DensityFunction> Y = NoiseRouterData.createKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = NoiseRouterData.createKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = NoiseRouterData.createKey("shift_z");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE = NoiseRouterData.createKey("overworld/base_3d_noise");
    private static final ResourceKey<DensityFunction> CONTINENTS = NoiseRouterData.createKey("overworld/continents");
    private static final ResourceKey<DensityFunction> EROSION = NoiseRouterData.createKey("overworld/erosion");
    private static final ResourceKey<DensityFunction> RIDGES = NoiseRouterData.createKey("overworld/ridges");
    private static final ResourceKey<DensityFunction> FACTOR = NoiseRouterData.createKey("overworld/factor");
    private static final ResourceKey<DensityFunction> DEPTH = NoiseRouterData.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE = NoiseRouterData.createKey("overworld/sloped_cheese");
    private static final ResourceKey<DensityFunction> CONTINENTS_LARGE = NoiseRouterData.createKey("overworld_large_biomes/continents");
    private static final ResourceKey<DensityFunction> EROSION_LARGE = NoiseRouterData.createKey("overworld_large_biomes/erosion");
    private static final ResourceKey<DensityFunction> FACTOR_LARGE = NoiseRouterData.createKey("overworld_large_biomes/factor");
    private static final ResourceKey<DensityFunction> DEPTH_LARGE = NoiseRouterData.createKey("overworld_large_biomes/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_LARGE = NoiseRouterData.createKey("overworld_large_biomes/sloped_cheese");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_END = NoiseRouterData.createKey("end/sloped_cheese");
    private static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = NoiseRouterData.createKey("overworld/caves/spaghetti_roughness_function");
    private static final ResourceKey<DensityFunction> ENTRANCES = NoiseRouterData.createKey("overworld/caves/entrances");
    private static final ResourceKey<DensityFunction> NOODLE = NoiseRouterData.createKey("overworld/caves/noodle");
    private static final ResourceKey<DensityFunction> PILLARS = NoiseRouterData.createKey("overworld/caves/pillars");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D_THICKNESS_MODULATOR = NoiseRouterData.createKey("overworld/caves/spaghetti_2d_thickness_modulator");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = NoiseRouterData.createKey("overworld/caves/spaghetti_2d");

    protected static NoiseRouterWithOnlyNoises overworld(NoiseSettings p_212278_, boolean p_212279_) {
        return NoiseRouterData.overworldWithNewCaves(p_212278_, p_212279_);
    }

    private static ResourceKey<DensityFunction> createKey(String p_209537_) {
        return ResourceKey.create(Registry.DENSITY_FUNCTION_REGISTRY, new ResourceLocation(p_209537_));
    }

    public static Holder<? extends DensityFunction> bootstrap() {
        NoiseRouterData.register(ZERO, DensityFunctions.zero());
        int i = DimensionType.MIN_Y * 2;
        int j = DimensionType.MAX_Y * 2;
        NoiseRouterData.register(Y, DensityFunctions.yClampedGradient(i, j, i, j));
        DensityFunction densityfunction = NoiseRouterData.register(SHIFT_X, DensityFunctions.flatCache(DensityFunctions.cache2d(DensityFunctions.shiftA(NoiseRouterData.getNoise(Noises.SHIFT)))));
        DensityFunction densityfunction1 = NoiseRouterData.register(SHIFT_Z, DensityFunctions.flatCache(DensityFunctions.cache2d(DensityFunctions.shiftB(NoiseRouterData.getNoise(Noises.SHIFT)))));
        NoiseRouterData.register(BASE_3D_NOISE, BlendedNoise.UNSEEDED);
        DensityFunction densityfunction2 = NoiseRouterData.register(CONTINENTS, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(densityfunction, densityfunction1, 0.25, NoiseRouterData.getNoise(Noises.CONTINENTALNESS))));
        DensityFunction densityfunction3 = NoiseRouterData.register(EROSION, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(densityfunction, densityfunction1, 0.25, NoiseRouterData.getNoise(Noises.EROSION))));
        DensityFunction densityfunction4 = NoiseRouterData.register(RIDGES, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(densityfunction, densityfunction1, 0.25, NoiseRouterData.getNoise(Noises.RIDGE))));
        DensityFunction densityfunction5 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.JAGGED), 1500.0, 0.0);
        DensityFunction densityfunction6 = NoiseRouterData.splineWithBlending(densityfunction2, densityfunction3, densityfunction4, DensityFunctions.TerrainShaperSpline.SplineType.OFFSET, -0.81, 2.5, DensityFunctions.blendOffset());
        DensityFunction densityfunction7 = NoiseRouterData.register(FACTOR, NoiseRouterData.splineWithBlending(densityfunction2, densityfunction3, densityfunction4, DensityFunctions.TerrainShaperSpline.SplineType.FACTOR, 0.0, 8.0, BLENDING_FACTOR));
        DensityFunction densityfunction8 = NoiseRouterData.register(DEPTH, DensityFunctions.add(DensityFunctions.yClampedGradient(-64, 320, 1.5, -1.5), densityfunction6));
        NoiseRouterData.register(SLOPED_CHEESE, NoiseRouterData.slopedCheese(densityfunction2, densityfunction3, densityfunction4, densityfunction7, densityfunction8, densityfunction5));
        DensityFunction densityfunction9 = NoiseRouterData.register(CONTINENTS_LARGE, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(densityfunction, densityfunction1, 0.25, NoiseRouterData.getNoise(Noises.CONTINENTALNESS_LARGE))));
        DensityFunction densityfunction10 = NoiseRouterData.register(EROSION_LARGE, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(densityfunction, densityfunction1, 0.25, NoiseRouterData.getNoise(Noises.EROSION_LARGE))));
        DensityFunction densityfunction11 = NoiseRouterData.splineWithBlending(densityfunction9, densityfunction10, densityfunction4, DensityFunctions.TerrainShaperSpline.SplineType.OFFSET, -0.81, 2.5, DensityFunctions.blendOffset());
        DensityFunction densityfunction12 = NoiseRouterData.register(FACTOR_LARGE, NoiseRouterData.splineWithBlending(densityfunction9, densityfunction10, densityfunction4, DensityFunctions.TerrainShaperSpline.SplineType.FACTOR, 0.0, 8.0, BLENDING_FACTOR));
        DensityFunction densityfunction13 = NoiseRouterData.register(DEPTH_LARGE, DensityFunctions.add(DensityFunctions.yClampedGradient(-64, 320, 1.5, -1.5), densityfunction11));
        NoiseRouterData.register(SLOPED_CHEESE_LARGE, NoiseRouterData.slopedCheese(densityfunction9, densityfunction10, densityfunction4, densityfunction12, densityfunction13, densityfunction5));
        NoiseRouterData.register(SLOPED_CHEESE_END, DensityFunctions.add(DensityFunctions.endIslands(0L), NoiseRouterData.getFunction(BASE_3D_NOISE)));
        NoiseRouterData.register(SPAGHETTI_ROUGHNESS_FUNCTION, NoiseRouterData.spaghettiRoughnessFunction());
        NoiseRouterData.register(SPAGHETTI_2D_THICKNESS_MODULATOR, DensityFunctions.cacheOnce(DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.SPAGHETTI_2D_THICKNESS), 2.0, 1.0, -0.6, -1.3)));
        NoiseRouterData.register(SPAGHETTI_2D, NoiseRouterData.spaghetti2D());
        NoiseRouterData.register(ENTRANCES, NoiseRouterData.entrances());
        NoiseRouterData.register(NOODLE, NoiseRouterData.noodle());
        NoiseRouterData.register(PILLARS, NoiseRouterData.pillars());
        return (Holder)BuiltinRegistries.DENSITY_FUNCTION.holders().iterator().next();
    }

    private static DensityFunction register(ResourceKey<DensityFunction> p_209545_, DensityFunction p_209546_) {
        return new DensityFunctions.HolderHolder(BuiltinRegistries.register(BuiltinRegistries.DENSITY_FUNCTION, p_209545_, p_209546_));
    }

    private static Holder<NormalNoise.NoiseParameters> getNoise(ResourceKey<NormalNoise.NoiseParameters> p_209543_) {
        return BuiltinRegistries.NOISE.getHolderOrThrow(p_209543_);
    }

    private static DensityFunction getFunction(ResourceKey<DensityFunction> p_209553_) {
        return new DensityFunctions.HolderHolder(BuiltinRegistries.DENSITY_FUNCTION.getHolderOrThrow(p_209553_));
    }

    private static DensityFunction slopedCheese(DensityFunction p_209482_, DensityFunction p_209483_, DensityFunction p_209484_, DensityFunction p_209485_, DensityFunction p_209486_, DensityFunction p_209487_) {
        DensityFunction densityfunction = NoiseRouterData.splineWithBlending(p_209482_, p_209483_, p_209484_, DensityFunctions.TerrainShaperSpline.SplineType.JAGGEDNESS, 0.0, 1.28, BLENDING_JAGGEDNESS);
        DensityFunction densityfunction1 = DensityFunctions.mul(densityfunction, p_209487_.halfNegative());
        DensityFunction densityfunction2 = NoiseRouterData.noiseGradientDensity(p_209485_, DensityFunctions.add(p_209486_, densityfunction1));
        return DensityFunctions.add(densityfunction2, NoiseRouterData.getFunction(BASE_3D_NOISE));
    }

    private static DensityFunction spaghettiRoughnessFunction() {
        DensityFunction densityfunction = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.SPAGHETTI_ROUGHNESS));
        DensityFunction densityfunction1 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.SPAGHETTI_ROUGHNESS_MODULATOR), 0.0, -0.1);
        return DensityFunctions.cacheOnce(DensityFunctions.mul(densityfunction1, DensityFunctions.add(densityfunction.abs(), DensityFunctions.constant(-0.4))));
    }

    private static DensityFunction entrances() {
        DensityFunction densityfunction = DensityFunctions.cacheOnce(DensityFunctions.noise(NoiseRouterData.getNoise(Noises.SPAGHETTI_3D_RARITY), 2.0, 1.0));
        DensityFunction densityfunction1 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.SPAGHETTI_3D_THICKNESS), -0.065, -0.088);
        DensityFunction densityfunction2 = DensityFunctions.weirdScaledSampler(densityfunction, NoiseRouterData.getNoise(Noises.SPAGHETTI_3D_1), DensityFunctions.WeirdScaledSampler.RarityValueMapper.TYPE1);
        DensityFunction densityfunction3 = DensityFunctions.weirdScaledSampler(densityfunction, NoiseRouterData.getNoise(Noises.SPAGHETTI_3D_2), DensityFunctions.WeirdScaledSampler.RarityValueMapper.TYPE1);
        DensityFunction densityfunction4 = DensityFunctions.add(DensityFunctions.max(densityfunction2, densityfunction3), densityfunction1).clamp(-1.0, 1.0);
        DensityFunction densityfunction5 = NoiseRouterData.getFunction(SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityfunction6 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.CAVE_ENTRANCE), 0.75, 0.5);
        DensityFunction densityfunction7 = DensityFunctions.add(DensityFunctions.add(densityfunction6, DensityFunctions.constant(0.37)), DensityFunctions.yClampedGradient(-10, 30, 0.3, 0.0));
        return DensityFunctions.cacheOnce(DensityFunctions.min(densityfunction7, DensityFunctions.add(densityfunction5, densityfunction4)));
    }

    private static DensityFunction noodle() {
        DensityFunction densityfunction = NoiseRouterData.getFunction(Y);
        int i = -64;
        int j = -60;
        int k = 320;
        DensityFunction densityfunction1 = NoiseRouterData.yLimitedInterpolatable(densityfunction, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.NOODLE), 1.0, 1.0), -60, 320, -1);
        DensityFunction densityfunction2 = NoiseRouterData.yLimitedInterpolatable(densityfunction, DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.NOODLE_THICKNESS), 1.0, 1.0, -0.05, -0.1), -60, 320, 0);
        double d0 = 2.6666666666666665;
        DensityFunction densityfunction3 = NoiseRouterData.yLimitedInterpolatable(densityfunction, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.NOODLE_RIDGE_A), 2.6666666666666665, 2.6666666666666665), -60, 320, 0);
        DensityFunction densityfunction4 = NoiseRouterData.yLimitedInterpolatable(densityfunction, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.NOODLE_RIDGE_B), 2.6666666666666665, 2.6666666666666665), -60, 320, 0);
        DensityFunction densityfunction5 = DensityFunctions.mul(DensityFunctions.constant(1.5), DensityFunctions.max(densityfunction3.abs(), densityfunction4.abs()));
        return DensityFunctions.rangeChoice(densityfunction1, -1000000.0, 0.0, DensityFunctions.constant(64.0), DensityFunctions.add(densityfunction2, densityfunction5));
    }

    private static DensityFunction pillars() {
        double d0 = 25.0;
        double d1 = 0.3;
        DensityFunction densityfunction = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.PILLAR), 25.0, 0.3);
        DensityFunction densityfunction1 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.PILLAR_RARENESS), 0.0, -2.0);
        DensityFunction densityfunction2 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.PILLAR_THICKNESS), 0.0, 1.1);
        DensityFunction densityfunction3 = DensityFunctions.add(DensityFunctions.mul(densityfunction, DensityFunctions.constant(2.0)), densityfunction1);
        return DensityFunctions.cacheOnce(DensityFunctions.mul(densityfunction3, densityfunction2.cube()));
    }

    private static DensityFunction spaghetti2D() {
        DensityFunction densityfunction = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.SPAGHETTI_2D_MODULATOR), 2.0, 1.0);
        DensityFunction densityfunction1 = DensityFunctions.weirdScaledSampler(densityfunction, NoiseRouterData.getNoise(Noises.SPAGHETTI_2D), DensityFunctions.WeirdScaledSampler.RarityValueMapper.TYPE2);
        DensityFunction densityfunction2 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.SPAGHETTI_2D_ELEVATION), 0.0, Math.floorDiv(-64, 8), 8.0);
        DensityFunction densityfunction3 = NoiseRouterData.getFunction(SPAGHETTI_2D_THICKNESS_MODULATOR);
        DensityFunction densityfunction4 = DensityFunctions.add(densityfunction2, DensityFunctions.yClampedGradient(-64, 320, 8.0, -40.0)).abs();
        DensityFunction densityfunction5 = DensityFunctions.add(densityfunction4, densityfunction3).cube();
        double d0 = 0.083;
        DensityFunction densityfunction6 = DensityFunctions.add(densityfunction1, DensityFunctions.mul(DensityFunctions.constant(0.083), densityfunction3));
        return DensityFunctions.max(densityfunction6, densityfunction5).clamp(-1.0, 1.0);
    }

    private static DensityFunction underground(DensityFunction p_209470_) {
        DensityFunction densityfunction = NoiseRouterData.getFunction(SPAGHETTI_2D);
        DensityFunction densityfunction1 = NoiseRouterData.getFunction(SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityfunction2 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.CAVE_LAYER), 8.0);
        DensityFunction densityfunction3 = DensityFunctions.mul(DensityFunctions.constant(4.0), densityfunction2.square());
        DensityFunction densityfunction4 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.CAVE_CHEESE), 0.6666666666666666);
        DensityFunction densityfunction5 = DensityFunctions.add(DensityFunctions.add(DensityFunctions.constant(0.27), densityfunction4).clamp(-1.0, 1.0), DensityFunctions.add(DensityFunctions.constant(1.5), DensityFunctions.mul(DensityFunctions.constant(-0.64), p_209470_)).clamp(0.0, 0.5));
        DensityFunction densityfunction6 = DensityFunctions.add(densityfunction3, densityfunction5);
        DensityFunction densityfunction7 = DensityFunctions.min(DensityFunctions.min(densityfunction6, NoiseRouterData.getFunction(ENTRANCES)), DensityFunctions.add(densityfunction, densityfunction1));
        DensityFunction densityfunction8 = NoiseRouterData.getFunction(PILLARS);
        DensityFunction densityfunction9 = DensityFunctions.rangeChoice(densityfunction8, -1000000.0, 0.03, DensityFunctions.constant(-1000000.0), densityfunction8);
        return DensityFunctions.max(densityfunction7, densityfunction9);
    }

    private static DensityFunction postProcess(NoiseSettings p_212275_, DensityFunction p_212276_) {
        DensityFunction densityfunction = DensityFunctions.slide(p_212275_, p_212276_);
        DensityFunction densityfunction1 = DensityFunctions.blendDensity(densityfunction);
        return DensityFunctions.mul(DensityFunctions.interpolated(densityfunction1), DensityFunctions.constant(0.64)).squeeze();
    }

    private static NoiseRouterWithOnlyNoises overworldWithNewCaves(NoiseSettings p_212283_, boolean p_212284_) {
        DensityFunction densityfunction = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.AQUIFER_BARRIER), 0.5);
        DensityFunction densityfunction1 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS), 0.67);
        DensityFunction densityfunction2 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.AQUIFER_FLUID_LEVEL_SPREAD), 0.7142857142857143);
        DensityFunction densityfunction3 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.AQUIFER_LAVA));
        DensityFunction densityfunction4 = NoiseRouterData.getFunction(SHIFT_X);
        DensityFunction densityfunction5 = NoiseRouterData.getFunction(SHIFT_Z);
        DensityFunction densityfunction6 = DensityFunctions.shiftedNoise2d(densityfunction4, densityfunction5, 0.25, NoiseRouterData.getNoise(p_212284_ ? Noises.TEMPERATURE_LARGE : Noises.TEMPERATURE));
        DensityFunction densityfunction7 = DensityFunctions.shiftedNoise2d(densityfunction4, densityfunction5, 0.25, NoiseRouterData.getNoise(p_212284_ ? Noises.VEGETATION_LARGE : Noises.VEGETATION));
        DensityFunction densityfunction8 = NoiseRouterData.getFunction(p_212284_ ? FACTOR_LARGE : FACTOR);
        DensityFunction densityfunction9 = NoiseRouterData.getFunction(p_212284_ ? DEPTH_LARGE : DEPTH);
        DensityFunction densityfunction10 = NoiseRouterData.noiseGradientDensity(DensityFunctions.cache2d(densityfunction8), densityfunction9);
        DensityFunction densityfunction11 = NoiseRouterData.getFunction(p_212284_ ? SLOPED_CHEESE_LARGE : SLOPED_CHEESE);
        DensityFunction densityfunction12 = DensityFunctions.min(densityfunction11, DensityFunctions.mul(DensityFunctions.constant(5.0), NoiseRouterData.getFunction(ENTRANCES)));
        DensityFunction densityfunction13 = DensityFunctions.rangeChoice(densityfunction11, -1000000.0, 1.5625, densityfunction12, NoiseRouterData.underground(densityfunction11));
        DensityFunction densityfunction14 = DensityFunctions.min(NoiseRouterData.postProcess(p_212283_, densityfunction13), NoiseRouterData.getFunction(NOODLE));
        DensityFunction densityfunction15 = NoiseRouterData.getFunction(Y);
        int i = p_212283_.minY();
        int j = Stream.of(OreVeinifier.VeinType.values()).mapToInt(p_212286_ -> p_212286_.minY).min().orElse(i);
        int k = Stream.of(OreVeinifier.VeinType.values()).mapToInt(p_212281_ -> p_212281_.maxY).max().orElse(i);
        DensityFunction densityfunction16 = NoiseRouterData.yLimitedInterpolatable(densityfunction15, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.ORE_VEININESS), 1.5, 1.5), j, k, 0);
        float f = 4.0f;
        DensityFunction densityfunction17 = NoiseRouterData.yLimitedInterpolatable(densityfunction15, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.ORE_VEIN_A), 4.0, 4.0), j, k, 0).abs();
        DensityFunction densityfunction18 = NoiseRouterData.yLimitedInterpolatable(densityfunction15, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.ORE_VEIN_B), 4.0, 4.0), j, k, 0).abs();
        DensityFunction densityfunction19 = DensityFunctions.add(DensityFunctions.constant(-0.08f), DensityFunctions.max(densityfunction17, densityfunction18));
        DensityFunction densityfunction20 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.ORE_GAP));
        return new NoiseRouterWithOnlyNoises(densityfunction, densityfunction1, densityfunction2, densityfunction3, densityfunction6, densityfunction7, NoiseRouterData.getFunction(p_212284_ ? CONTINENTS_LARGE : CONTINENTS), NoiseRouterData.getFunction(p_212284_ ? EROSION_LARGE : EROSION), NoiseRouterData.getFunction(p_212284_ ? DEPTH_LARGE : DEPTH), NoiseRouterData.getFunction(RIDGES), densityfunction10, densityfunction14, densityfunction16, densityfunction19, densityfunction20);
    }

    private static NoiseRouterWithOnlyNoises noNewCaves(NoiseSettings p_212288_) {
        DensityFunction densityfunction = NoiseRouterData.getFunction(SHIFT_X);
        DensityFunction densityfunction1 = NoiseRouterData.getFunction(SHIFT_Z);
        DensityFunction densityfunction2 = DensityFunctions.shiftedNoise2d(densityfunction, densityfunction1, 0.25, NoiseRouterData.getNoise(Noises.TEMPERATURE));
        DensityFunction densityfunction3 = DensityFunctions.shiftedNoise2d(densityfunction, densityfunction1, 0.25, NoiseRouterData.getNoise(Noises.VEGETATION));
        DensityFunction densityfunction4 = NoiseRouterData.noiseGradientDensity(DensityFunctions.cache2d(NoiseRouterData.getFunction(FACTOR)), NoiseRouterData.getFunction(DEPTH));
        DensityFunction densityfunction5 = NoiseRouterData.postProcess(p_212288_, NoiseRouterData.getFunction(SLOPED_CHEESE));
        return new NoiseRouterWithOnlyNoises(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), densityfunction2, densityfunction3, NoiseRouterData.getFunction(CONTINENTS), NoiseRouterData.getFunction(EROSION), NoiseRouterData.getFunction(DEPTH), NoiseRouterData.getFunction(RIDGES), densityfunction4, densityfunction5, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    protected static NoiseRouterWithOnlyNoises overworldWithoutCaves(NoiseSettings p_209549_) {
        return NoiseRouterData.noNewCaves(p_209549_);
    }

    protected static NoiseRouterWithOnlyNoises nether(NoiseSettings p_209556_) {
        return NoiseRouterData.noNewCaves(p_209556_);
    }

    protected static NoiseRouterWithOnlyNoises end(NoiseSettings p_209559_) {
        DensityFunction densityfunction = DensityFunctions.cache2d(DensityFunctions.endIslands(0L));
        DensityFunction densityfunction1 = NoiseRouterData.postProcess(p_209559_, NoiseRouterData.getFunction(SLOPED_CHEESE_END));
        return new NoiseRouterWithOnlyNoises(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), densityfunction, densityfunction1, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    private static NormalNoise seedNoise(PositionalRandomFactory p_209525_, Registry<NormalNoise.NoiseParameters> p_209526_, Holder<NormalNoise.NoiseParameters> p_209527_) {
        return Noises.instantiate(p_209525_, p_209527_.unwrapKey().flatMap(p_209526_::getHolder).orElse(p_209527_));
    }

    public static NoiseRouter createNoiseRouter(NoiseSettings p_209503_, long p_209504_, Registry<NormalNoise.NoiseParameters> p_209505_, WorldgenRandom.Algorithm p_209506_, NoiseRouterWithOnlyNoises p_209507_) {
        boolean flag = p_209506_ == WorldgenRandom.Algorithm.LEGACY;
        PositionalRandomFactory positionalrandomfactory = p_209506_.newInstance(p_209504_).forkPositional();
        HashMap map = new HashMap();
        DensityFunction.Visitor densityfunction$visitor = p_209535_ -> {
            if (p_209535_ instanceof DensityFunctions.Noise) {
                DensityFunctions.Noise densityfunctions$noise = (DensityFunctions.Noise)p_209535_;
                Holder<NormalNoise.NoiseParameters> holder2 = densityfunctions$noise.noiseData();
                return new DensityFunctions.Noise(holder2, NoiseRouterData.seedNoise(positionalrandomfactory, p_209505_, holder2), densityfunctions$noise.xzScale(), densityfunctions$noise.yScale());
            }
            if (p_209535_ instanceof DensityFunctions.ShiftNoise) {
                DensityFunctions.ShiftNoise densityfunctions$shiftnoise = (DensityFunctions.ShiftNoise)p_209535_;
                Holder<NormalNoise.NoiseParameters> holder3 = densityfunctions$shiftnoise.noiseData();
                NormalNoise normalnoise1 = flag ? NormalNoise.create(positionalrandomfactory.fromHashOf(Noises.SHIFT.location()), new NormalNoise.NoiseParameters(0, 0.0, new double[0])) : NoiseRouterData.seedNoise(positionalrandomfactory, p_209505_, holder3);
                return densityfunctions$shiftnoise.withNewNoise(normalnoise1);
            }
            if (p_209535_ instanceof DensityFunctions.ShiftedNoise) {
                DensityFunctions.ShiftedNoise densityfunctions$shiftednoise = (DensityFunctions.ShiftedNoise)p_209535_;
                if (flag) {
                    Holder<NormalNoise.NoiseParameters> holder = densityfunctions$shiftednoise.noiseData();
                    if (Objects.equals(holder.unwrapKey(), Optional.of(Noises.TEMPERATURE))) {
                        NormalNoise normalnoise2 = NormalNoise.createLegacyNetherBiome(p_209506_.newInstance(p_209504_), new NormalNoise.NoiseParameters(-7, 1.0, 1.0));
                        return new DensityFunctions.ShiftedNoise(densityfunctions$shiftednoise.shiftX(), densityfunctions$shiftednoise.shiftY(), densityfunctions$shiftednoise.shiftZ(), densityfunctions$shiftednoise.xzScale(), densityfunctions$shiftednoise.yScale(), holder, normalnoise2);
                    }
                    if (Objects.equals(holder.unwrapKey(), Optional.of(Noises.VEGETATION))) {
                        NormalNoise normalnoise = NormalNoise.createLegacyNetherBiome(p_209506_.newInstance(p_209504_ + 1L), new NormalNoise.NoiseParameters(-7, 1.0, 1.0));
                        return new DensityFunctions.ShiftedNoise(densityfunctions$shiftednoise.shiftX(), densityfunctions$shiftednoise.shiftY(), densityfunctions$shiftednoise.shiftZ(), densityfunctions$shiftednoise.xzScale(), densityfunctions$shiftednoise.yScale(), holder, normalnoise);
                    }
                }
                Holder<NormalNoise.NoiseParameters> holder1 = densityfunctions$shiftednoise.noiseData();
                return new DensityFunctions.ShiftedNoise(densityfunctions$shiftednoise.shiftX(), densityfunctions$shiftednoise.shiftY(), densityfunctions$shiftednoise.shiftZ(), densityfunctions$shiftednoise.xzScale(), densityfunctions$shiftednoise.yScale(), holder1, NoiseRouterData.seedNoise(positionalrandomfactory, p_209505_, holder1));
            }
            if (p_209535_ instanceof DensityFunctions.WeirdScaledSampler) {
                DensityFunctions.WeirdScaledSampler densityfunctions$weirdscaledsampler = (DensityFunctions.WeirdScaledSampler)p_209535_;
                return new DensityFunctions.WeirdScaledSampler(densityfunctions$weirdscaledsampler.input(), densityfunctions$weirdscaledsampler.noiseData(), NoiseRouterData.seedNoise(positionalrandomfactory, p_209505_, densityfunctions$weirdscaledsampler.noiseData()), densityfunctions$weirdscaledsampler.rarityValueMapper());
            }
            if (p_209535_ instanceof BlendedNoise) {
                return flag ? new BlendedNoise(p_209506_.newInstance(p_209504_), p_209503_.noiseSamplingSettings(), p_209503_.getCellWidth(), p_209503_.getCellHeight()) : new BlendedNoise(positionalrandomfactory.fromHashOf(new ResourceLocation("terrain")), p_209503_.noiseSamplingSettings(), p_209503_.getCellWidth(), p_209503_.getCellHeight());
            }
            if (p_209535_ instanceof DensityFunctions.EndIslandDensityFunction) {
                return new DensityFunctions.EndIslandDensityFunction(p_209504_);
            }
            if (p_209535_ instanceof DensityFunctions.TerrainShaperSpline) {
                DensityFunctions.TerrainShaperSpline densityfunctions$terrainshaperspline = (DensityFunctions.TerrainShaperSpline)p_209535_;
                TerrainShaper terrainshaper = p_209503_.terrainShaper();
                return new DensityFunctions.TerrainShaperSpline(densityfunctions$terrainshaperspline.continentalness(), densityfunctions$terrainshaperspline.erosion(), densityfunctions$terrainshaperspline.weirdness(), terrainshaper, densityfunctions$terrainshaperspline.spline(), densityfunctions$terrainshaperspline.minValue(), densityfunctions$terrainshaperspline.maxValue());
            }
            if (p_209535_ instanceof DensityFunctions.Slide) {
                DensityFunctions.Slide densityfunctions$slide = (DensityFunctions.Slide)p_209535_;
                return new DensityFunctions.Slide(p_209503_, densityfunctions$slide.input());
            }
            return p_209535_;
        };
        DensityFunction.Visitor densityfunction$visitor1 = p_209541_ -> map.computeIfAbsent(p_209541_, densityfunction$visitor);
        NoiseRouterWithOnlyNoises noiserouterwithonlynoises = p_209507_.mapAll(densityfunction$visitor1);
        PositionalRandomFactory positionalrandomfactory1 = positionalrandomfactory.fromHashOf(new ResourceLocation("aquifer")).forkPositional();
        PositionalRandomFactory positionalrandomfactory2 = positionalrandomfactory.fromHashOf(new ResourceLocation("ore")).forkPositional();
        return new NoiseRouter(noiserouterwithonlynoises.barrierNoise(), noiserouterwithonlynoises.fluidLevelFloodednessNoise(), noiserouterwithonlynoises.fluidLevelSpreadNoise(), noiserouterwithonlynoises.lavaNoise(), positionalrandomfactory1, positionalrandomfactory2, noiserouterwithonlynoises.temperature(), noiserouterwithonlynoises.vegetation(), noiserouterwithonlynoises.continents(), noiserouterwithonlynoises.erosion(), noiserouterwithonlynoises.depth(), noiserouterwithonlynoises.ridges(), noiserouterwithonlynoises.initialDensityWithoutJaggedness(), noiserouterwithonlynoises.finalDensity(), noiserouterwithonlynoises.veinToggle(), noiserouterwithonlynoises.veinRidged(), noiserouterwithonlynoises.veinGap(), new OverworldBiomeBuilder().spawnTarget());
    }

    private static DensityFunction splineWithBlending(DensityFunction p_209489_, DensityFunction p_209490_, DensityFunction p_209491_, DensityFunctions.TerrainShaperSpline.SplineType p_209492_, double p_209493_, double p_209494_, DensityFunction p_209495_) {
        DensityFunction densityfunction = DensityFunctions.terrainShaperSpline(p_209489_, p_209490_, p_209491_, p_209492_, p_209493_, p_209494_);
        DensityFunction densityfunction1 = DensityFunctions.lerp(DensityFunctions.blendAlpha(), p_209495_, densityfunction);
        return DensityFunctions.flatCache(DensityFunctions.cache2d(densityfunction1));
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction densityfunction = DensityFunctions.mul(p_212273_, p_212272_);
        return DensityFunctions.mul(DensityFunctions.constant(4.0), densityfunction.quarterNegative());
    }

    private static DensityFunction yLimitedInterpolatable(DensityFunction p_209472_, DensityFunction p_209473_, int p_209474_, int p_209475_, int p_209476_) {
        return DensityFunctions.interpolated(DensityFunctions.rangeChoice(p_209472_, p_209474_, p_209475_ + 1, p_209473_, DensityFunctions.constant(p_209476_)));
    }

    protected static double applySlide(NoiseSettings p_209499_, double p_209500_, double p_209501_) {
        double d0 = (int)p_209501_ / p_209499_.getCellHeight() - p_209499_.getMinCellY();
        p_209500_ = p_209499_.topSlideSettings().applySlide(p_209500_, (double)p_209499_.getCellCountY() - d0);
        return p_209499_.bottomSlideSettings().applySlide(p_209500_, d0);
    }

    protected static double computePreliminarySurfaceLevelScanning(NoiseSettings p_209509_, DensityFunction p_209510_, int p_209511_, int p_209512_) {
        int i = p_209509_.getMinCellY() + p_209509_.getCellCountY();
        while (i >= p_209509_.getMinCellY()) {
            int j = i * p_209509_.getCellHeight();
            double d0 = -0.703125;
            double d1 = p_209510_.compute(new DensityFunction.SinglePointContext(p_209511_, j, p_209512_)) + -0.703125;
            double d2 = Mth.clamp(d1, -64.0, 64.0);
            if ((d2 = NoiseRouterData.applySlide(p_209509_, d2, j)) > 0.390625) {
                return j;
            }
            --i;
        }
        return 2.147483647E9;
    }

    protected static final class QuantizedSpaghettiRarity {
        protected QuantizedSpaghettiRarity() {
        }

        protected static double getSphaghettiRarity2D(double p_209564_) {
            if (p_209564_ < -0.75) {
                return 0.5;
            }
            if (p_209564_ < -0.5) {
                return 0.75;
            }
            if (p_209564_ < 0.5) {
                return 1.0;
            }
            return p_209564_ < 0.75 ? 2.0 : 3.0;
        }

        protected static double getSpaghettiRarity3D(double p_209566_) {
            if (p_209566_ < -0.5) {
                return 0.75;
            }
            if (p_209566_ < 0.0) {
                return 1.0;
            }
            return p_209566_ < 0.5 ? 1.5 : 2.0;
        }
    }
}

