/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Material;

public class SurfaceSystem {
    private static final BlockState WHITE_TERRACOTTA = Blocks.WHITE_TERRACOTTA.defaultBlockState();
    private static final BlockState ORANGE_TERRACOTTA = Blocks.ORANGE_TERRACOTTA.defaultBlockState();
    private static final BlockState TERRACOTTA = Blocks.TERRACOTTA.defaultBlockState();
    private static final BlockState YELLOW_TERRACOTTA = Blocks.YELLOW_TERRACOTTA.defaultBlockState();
    private static final BlockState BROWN_TERRACOTTA = Blocks.BROWN_TERRACOTTA.defaultBlockState();
    private static final BlockState RED_TERRACOTTA = Blocks.RED_TERRACOTTA.defaultBlockState();
    private static final BlockState LIGHT_GRAY_TERRACOTTA = Blocks.LIGHT_GRAY_TERRACOTTA.defaultBlockState();
    private static final BlockState PACKED_ICE = Blocks.PACKED_ICE.defaultBlockState();
    private static final BlockState SNOW_BLOCK = Blocks.SNOW_BLOCK.defaultBlockState();
    private final BlockState defaultBlock;
    private final int seaLevel;
    private final BlockState[] clayBands;
    private final NormalNoise clayBandsOffsetNoise;
    private final NormalNoise badlandsPillarNoise;
    private final NormalNoise badlandsPillarRoofNoise;
    private final NormalNoise badlandsSurfaceNoise;
    private final NormalNoise icebergPillarNoise;
    private final NormalNoise icebergPillarRoofNoise;
    private final NormalNoise icebergSurfaceNoise;
    private final Registry<NormalNoise.NoiseParameters> noises;
    private final Map<ResourceKey<NormalNoise.NoiseParameters>, NormalNoise> noiseIntances = new ConcurrentHashMap<ResourceKey<NormalNoise.NoiseParameters>, NormalNoise>();
    private final Map<ResourceLocation, PositionalRandomFactory> positionalRandoms = new ConcurrentHashMap<ResourceLocation, PositionalRandomFactory>();
    private final PositionalRandomFactory randomFactory;
    private final NormalNoise surfaceNoise;
    private final NormalNoise surfaceSecondaryNoise;

    public SurfaceSystem(Registry<NormalNoise.NoiseParameters> p_198285_, BlockState p_198286_, int p_198287_, long p_198288_, WorldgenRandom.Algorithm p_198289_) {
        this.noises = p_198285_;
        this.defaultBlock = p_198286_;
        this.seaLevel = p_198287_;
        this.randomFactory = p_198289_.newInstance(p_198288_).forkPositional();
        this.clayBandsOffsetNoise = Noises.instantiate(p_198285_, this.randomFactory, Noises.CLAY_BANDS_OFFSET);
        this.clayBands = SurfaceSystem.generateBands(this.randomFactory.fromHashOf(new ResourceLocation("clay_bands")));
        this.surfaceNoise = Noises.instantiate(p_198285_, this.randomFactory, Noises.SURFACE);
        this.surfaceSecondaryNoise = Noises.instantiate(p_198285_, this.randomFactory, Noises.SURFACE_SECONDARY);
        this.badlandsPillarNoise = Noises.instantiate(p_198285_, this.randomFactory, Noises.BADLANDS_PILLAR);
        this.badlandsPillarRoofNoise = Noises.instantiate(p_198285_, this.randomFactory, Noises.BADLANDS_PILLAR_ROOF);
        this.badlandsSurfaceNoise = Noises.instantiate(p_198285_, this.randomFactory, Noises.BADLANDS_SURFACE);
        this.icebergPillarNoise = Noises.instantiate(p_198285_, this.randomFactory, Noises.ICEBERG_PILLAR);
        this.icebergPillarRoofNoise = Noises.instantiate(p_198285_, this.randomFactory, Noises.ICEBERG_PILLAR_ROOF);
        this.icebergSurfaceNoise = Noises.instantiate(p_198285_, this.randomFactory, Noises.ICEBERG_SURFACE);
    }

    protected NormalNoise getOrCreateNoise(ResourceKey<NormalNoise.NoiseParameters> p_189984_) {
        return this.noiseIntances.computeIfAbsent(p_189984_, p_189987_ -> Noises.instantiate(this.noises, this.randomFactory, p_189984_));
    }

    protected PositionalRandomFactory getOrCreateRandomFactory(ResourceLocation p_189989_) {
        return this.positionalRandoms.computeIfAbsent(p_189989_, p_189992_ -> this.randomFactory.fromHashOf(p_189989_).forkPositional());
    }

    public void buildSurface(BiomeManager p_189945_, Registry<Biome> p_189946_, boolean p_189947_, WorldGenerationContext p_189948_, ChunkAccess p_189949_, NoiseChunk p_189950_, SurfaceRules.RuleSource p_189951_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ChunkPos chunkpos = p_189949_.getPos();
        int i = chunkpos.getMinBlockX();
        int j = chunkpos.getMinBlockZ();
        BlockColumn blockcolumn = new BlockColumn(){

            @Override
            public BlockState getBlock(int p_190006_) {
                return p_189949_.getBlockState(blockpos$mutableblockpos.setY(p_190006_));
            }

            @Override
            public void setBlock(int p_190008_, BlockState p_190009_) {
                LevelHeightAccessor levelheightaccessor = p_189949_.getHeightAccessorForGeneration();
                if (p_190008_ >= levelheightaccessor.getMinBuildHeight() && p_190008_ < levelheightaccessor.getMaxBuildHeight()) {
                    p_189949_.setBlockState(blockpos$mutableblockpos.setY(p_190008_), p_190009_, false);
                    if (!p_190009_.getFluidState().isEmpty()) {
                        p_189949_.markPosForPostprocessing(blockpos$mutableblockpos);
                    }
                }
            }

            public String toString() {
                return "ChunkBlockColumn " + chunkpos;
            }
        };
        SurfaceRules.Context surfacerules$context = new SurfaceRules.Context(this, p_189949_, p_189950_, p_189945_::getBiome, p_189946_, p_189948_);
        SurfaceRules.SurfaceRule surfacerules$surfacerule = (SurfaceRules.SurfaceRule)p_189951_.apply(surfacerules$context);
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
        int k = 0;
        while (k < 16) {
            int l = 0;
            while (l < 16) {
                int i1 = i + k;
                int j1 = j + l;
                int k1 = p_189949_.getHeight(Heightmap.Types.WORLD_SURFACE_WG, k, l) + 1;
                blockpos$mutableblockpos.setX(i1).setZ(j1);
                Holder<Biome> holder = p_189945_.getBiome(blockpos$mutableblockpos1.set(i1, p_189947_ ? 0 : k1, j1));
                if (holder.is(Biomes.ERODED_BADLANDS)) {
                    this.erodedBadlandsExtension(blockcolumn, i1, j1, k1, p_189949_);
                }
                int l1 = p_189949_.getHeight(Heightmap.Types.WORLD_SURFACE_WG, k, l) + 1;
                surfacerules$context.updateXZ(i1, j1);
                int i2 = 0;
                int j2 = Integer.MIN_VALUE;
                int k2 = Integer.MAX_VALUE;
                int l2 = p_189949_.getMinBuildHeight();
                int i3 = l1;
                while (i3 >= l2) {
                    BlockState blockstate = blockcolumn.getBlock(i3);
                    if (blockstate.isAir()) {
                        i2 = 0;
                        j2 = Integer.MIN_VALUE;
                    } else if (!blockstate.getFluidState().isEmpty()) {
                        if (j2 == Integer.MIN_VALUE) {
                            j2 = i3 + 1;
                        }
                    } else {
                        BlockState blockstate2;
                        if (k2 >= i3) {
                            k2 = DimensionType.WAY_BELOW_MIN_Y;
                            int j3 = i3 - 1;
                            while (j3 >= l2 - 1) {
                                BlockState blockstate1 = blockcolumn.getBlock(j3);
                                if (!this.isStone(blockstate1)) {
                                    k2 = j3 + 1;
                                    break;
                                }
                                --j3;
                            }
                        }
                        int k3 = i3 - k2 + 1;
                        surfacerules$context.updateY(++i2, k3, j2, i1, i3, j1);
                        if (blockstate == this.defaultBlock && (blockstate2 = surfacerules$surfacerule.tryApply(i1, i3, j1)) != null) {
                            blockcolumn.setBlock(i3, blockstate2);
                        }
                    }
                    --i3;
                }
                if (holder.is(Biomes.FROZEN_OCEAN) || holder.is(Biomes.DEEP_FROZEN_OCEAN)) {
                    this.frozenOceanExtension(surfacerules$context.getMinSurfaceLevel(), holder.value(), blockcolumn, blockpos$mutableblockpos1, i1, j1, k1);
                }
                ++l;
            }
            ++k;
        }
    }

    protected int getSurfaceDepth(int p_189928_, int p_189929_) {
        double d0 = this.surfaceNoise.getValue(p_189928_, 0.0, p_189929_);
        return (int)(d0 * 2.75 + 3.0 + this.randomFactory.at(p_189928_, 0, p_189929_).nextDouble() * 0.25);
    }

    protected double getSurfaceSecondary(int p_202190_, int p_202191_) {
        return this.surfaceSecondaryNoise.getValue(p_202190_, 0.0, p_202191_);
    }

    private boolean isStone(BlockState p_189953_) {
        return !p_189953_.isAir() && p_189953_.getFluidState().isEmpty();
    }

    @Deprecated
    public Optional<BlockState> topMaterial(SurfaceRules.RuleSource p_189972_, CarvingContext p_189973_, Function<BlockPos, Holder<Biome>> p_189974_, ChunkAccess p_189975_, NoiseChunk p_189976_, BlockPos p_189977_, boolean p_189978_) {
        SurfaceRules.Context surfacerules$context = new SurfaceRules.Context(this, p_189975_, p_189976_, p_189974_, p_189973_.registryAccess().registryOrThrow(Registry.BIOME_REGISTRY), p_189973_);
        SurfaceRules.SurfaceRule surfacerules$surfacerule = (SurfaceRules.SurfaceRule)p_189972_.apply(surfacerules$context);
        int i = p_189977_.getX();
        int j = p_189977_.getY();
        int k = p_189977_.getZ();
        surfacerules$context.updateXZ(i, k);
        surfacerules$context.updateY(1, 1, p_189978_ ? j + 1 : Integer.MIN_VALUE, i, j, k);
        BlockState blockstate = surfacerules$surfacerule.tryApply(i, j, k);
        return Optional.ofNullable(blockstate);
    }

    private void erodedBadlandsExtension(BlockColumn p_189955_, int p_189956_, int p_189957_, int p_189958_, LevelHeightAccessor p_189959_) {
        double d0 = 0.2;
        double d1 = Math.min(Math.abs(this.badlandsSurfaceNoise.getValue(p_189956_, 0.0, p_189957_) * 8.25), this.badlandsPillarNoise.getValue((double)p_189956_ * 0.2, 0.0, (double)p_189957_ * 0.2) * 15.0);
        if (!(d1 <= 0.0)) {
            double d2 = 0.75;
            double d3 = 1.5;
            double d4 = Math.abs(this.badlandsPillarRoofNoise.getValue((double)p_189956_ * 0.75, 0.0, (double)p_189957_ * 0.75) * 1.5);
            double d5 = 64.0 + Math.min(d1 * d1 * 2.5, Math.ceil(d4 * 50.0) + 24.0);
            int i = Mth.floor(d5);
            if (p_189958_ <= i) {
                int j = i;
                while (j >= p_189959_.getMinBuildHeight()) {
                    BlockState blockstate = p_189955_.getBlock(j);
                    if (blockstate.is(this.defaultBlock.getBlock())) break;
                    if (blockstate.is(Blocks.WATER)) {
                        return;
                    }
                    --j;
                }
                int k = i;
                while (k >= p_189959_.getMinBuildHeight() && p_189955_.getBlock(k).isAir()) {
                    p_189955_.setBlock(k, this.defaultBlock);
                    --k;
                }
            }
        }
    }

    private void frozenOceanExtension(int p_189935_, Biome p_189936_, BlockColumn p_189937_, BlockPos.MutableBlockPos p_189938_, int p_189939_, int p_189940_, int p_189941_) {
        double d0 = 1.28;
        double d1 = Math.min(Math.abs(this.icebergSurfaceNoise.getValue(p_189939_, 0.0, p_189940_) * 8.25), this.icebergPillarNoise.getValue((double)p_189939_ * 1.28, 0.0, (double)p_189940_ * 1.28) * 15.0);
        if (!(d1 <= 1.8)) {
            double d2;
            double d3 = 1.17;
            double d4 = 1.5;
            double d5 = Math.abs(this.icebergPillarRoofNoise.getValue((double)p_189939_ * 1.17, 0.0, (double)p_189940_ * 1.17) * 1.5);
            double d6 = Math.min(d1 * d1 * 1.2, Math.ceil(d5 * 40.0) + 14.0);
            if (p_189936_.shouldMeltFrozenOceanIcebergSlightly(p_189938_.set(p_189939_, 63, p_189940_))) {
                d6 -= 2.0;
            }
            if (d6 > 2.0) {
                d2 = (double)this.seaLevel - d6 - 7.0;
                d6 += (double)this.seaLevel;
            } else {
                d6 = 0.0;
                d2 = 0.0;
            }
            double d7 = d6;
            RandomSource randomsource = this.randomFactory.at(p_189939_, 0, p_189940_);
            int i = 2 + randomsource.nextInt(4);
            int j = this.seaLevel + 18 + randomsource.nextInt(10);
            int k = 0;
            int l = Math.max(p_189941_, (int)d6 + 1);
            while (l >= p_189935_) {
                if (p_189937_.getBlock(l).isAir() && l < (int)d7 && randomsource.nextDouble() > 0.01 || p_189937_.getBlock(l).getMaterial() == Material.WATER && l > (int)d2 && l < this.seaLevel && d2 != 0.0 && randomsource.nextDouble() > 0.15) {
                    if (k <= i && l > j) {
                        p_189937_.setBlock(l, SNOW_BLOCK);
                        ++k;
                    } else {
                        p_189937_.setBlock(l, PACKED_ICE);
                    }
                }
                --l;
            }
        }
    }

    private static BlockState[] generateBands(RandomSource p_189965_) {
        Object[] ablockstate = new BlockState[192];
        Arrays.fill(ablockstate, TERRACOTTA);
        int k = 0;
        while (k < ablockstate.length) {
            if ((k += p_189965_.nextInt(5) + 1) < ablockstate.length) {
                ablockstate[k] = ORANGE_TERRACOTTA;
            }
            ++k;
        }
        SurfaceSystem.a(p_189965_, (BlockState[])ablockstate, 1, YELLOW_TERRACOTTA);
        SurfaceSystem.a(p_189965_, (BlockState[])ablockstate, 2, BROWN_TERRACOTTA);
        SurfaceSystem.a(p_189965_, (BlockState[])ablockstate, 1, RED_TERRACOTTA);
        int l = p_189965_.nextIntBetweenInclusive(9, 15);
        int i = 0;
        int j = 0;
        while (i < l && j < ablockstate.length) {
            ablockstate[j] = WHITE_TERRACOTTA;
            if (j - 1 > 0 && p_189965_.nextBoolean()) {
                ablockstate[j - 1] = LIGHT_GRAY_TERRACOTTA;
            }
            if (j + 1 < ablockstate.length && p_189965_.nextBoolean()) {
                ablockstate[j + 1] = LIGHT_GRAY_TERRACOTTA;
            }
            ++i;
            j += p_189965_.nextInt(16) + 4;
        }
        return ablockstate;
    }

    private static void a(RandomSource p_189967_, BlockState[] p_189968_, int p_189969_, BlockState p_189970_) {
        int i = p_189967_.nextIntBetweenInclusive(6, 15);
        int j = 0;
        while (j < i) {
            int k = p_189969_ + p_189967_.nextInt(3);
            int l = p_189967_.nextInt(p_189968_.length);
            int i1 = 0;
            while (l + i1 < p_189968_.length && i1 < k) {
                p_189968_[l + i1] = p_189970_;
                ++i1;
            }
            ++j;
        }
    }

    protected BlockState getBand(int p_189931_, int p_189932_, int p_189933_) {
        int i = (int)Math.round(this.clayBandsOffsetNoise.getValue(p_189931_, 0.0, p_189933_) * 4.0);
        return this.clayBands[(p_189932_ + i + this.clayBands.length) % this.clayBands.length];
    }
}

