/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class WorldGenSettings {
    public static final Codec<WorldGenSettings> CODEC = RecordCodecBuilder.create(p_64626_ -> p_64626_.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(WorldGenSettings::seed), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(WorldGenSettings::generateFeatures), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(WorldGenSettings::generateBonusChest), (App)RegistryCodecs.dataPackAwareCodec(Registry.LEVEL_STEM_REGISTRY, Lifecycle.stable(), LevelStem.CODEC).xmap(LevelStem::sortMap, Function.identity()).fieldOf("dimensions").forGetter(WorldGenSettings::dimensions), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(p_158959_ -> p_158959_.legacyCustomOptions)).apply((Applicative)p_64626_, p_64626_.stable(WorldGenSettings::new))).comapFlatMap(WorldGenSettings::guardExperimental, Function.identity());
    private static final Logger LOGGER = LogUtils.getLogger();
    private final long seed;
    private final boolean generateFeatures;
    private final boolean generateBonusChest;
    private final Registry<LevelStem> dimensions;
    private final Optional<String> legacyCustomOptions;

    private DataResult<WorldGenSettings> guardExperimental() {
        LevelStem levelstem = this.dimensions.get(LevelStem.OVERWORLD);
        if (levelstem == null) {
            return DataResult.error((String)"Overworld settings missing");
        }
        return this.stable() ? DataResult.success((Object)this, (Lifecycle)Lifecycle.stable()) : DataResult.success((Object)this);
    }

    private boolean stable() {
        return LevelStem.stable(this.seed, this.dimensions);
    }

    public WorldGenSettings(long pSeed, boolean p_204634_, boolean pGenerateFeatures, Registry<LevelStem> pGenerateBonusChest) {
        this(pSeed, p_204634_, pGenerateFeatures, pGenerateBonusChest, Optional.empty());
        LevelStem levelstem = pGenerateBonusChest.get(LevelStem.OVERWORLD);
        if (levelstem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    private WorldGenSettings(long p_204638_, boolean p_204639_, boolean p_204640_, Registry<LevelStem> p_204641_, Optional<String> p_204642_) {
        this.seed = p_204638_;
        this.generateFeatures = p_204639_;
        this.generateBonusChest = p_204640_;
        this.dimensions = p_204641_;
        this.legacyCustomOptions = p_204642_;
    }

    public static WorldGenSettings demoSettings(RegistryAccess pRegistryAccess) {
        int i = "North Carolina".hashCode();
        return new WorldGenSettings(i, true, true, WorldGenSettings.withOverworld(pRegistryAccess.registryOrThrow(Registry.DIMENSION_TYPE_REGISTRY), DimensionType.defaultDimensions(pRegistryAccess, i), (ChunkGenerator)WorldGenSettings.makeDefaultOverworld(pRegistryAccess, i)));
    }

    public static WorldGenSettings makeDefault(RegistryAccess p_190051_) {
        long i = new Random().nextLong();
        return new WorldGenSettings(i, true, false, WorldGenSettings.withOverworld(p_190051_.registryOrThrow(Registry.DIMENSION_TYPE_REGISTRY), DimensionType.defaultDimensions(p_190051_, i), (ChunkGenerator)WorldGenSettings.makeDefaultOverworld(p_190051_, i)));
    }

    public static NoiseBasedChunkGenerator makeDefaultOverworld(RegistryAccess p_190028_, long p_190029_) {
        return WorldGenSettings.makeDefaultOverworld(p_190028_, p_190029_, true);
    }

    public static NoiseBasedChunkGenerator makeDefaultOverworld(RegistryAccess p_190040_, long p_190041_, boolean p_190042_) {
        return WorldGenSettings.makeOverworld(p_190040_, p_190041_, NoiseGeneratorSettings.OVERWORLD, p_190042_);
    }

    public static NoiseBasedChunkGenerator makeOverworld(RegistryAccess p_190031_, long p_190032_, ResourceKey<NoiseGeneratorSettings> p_190033_) {
        return WorldGenSettings.makeOverworld(p_190031_, p_190032_, p_190033_, true);
    }

    public static NoiseBasedChunkGenerator makeOverworld(RegistryAccess p_190035_, long p_190036_, ResourceKey<NoiseGeneratorSettings> p_190037_, boolean p_190038_) {
        Registry<Biome> registry = p_190035_.registryOrThrow(Registry.BIOME_REGISTRY);
        Registry<StructureSet> registry1 = p_190035_.registryOrThrow(Registry.STRUCTURE_SET_REGISTRY);
        Registry<NoiseGeneratorSettings> registry2 = p_190035_.registryOrThrow(Registry.NOISE_GENERATOR_SETTINGS_REGISTRY);
        Registry<NormalNoise.NoiseParameters> registry3 = p_190035_.registryOrThrow(Registry.NOISE_REGISTRY);
        return new NoiseBasedChunkGenerator(registry1, registry3, (BiomeSource)MultiNoiseBiomeSource.Preset.OVERWORLD.biomeSource(registry, p_190038_), p_190036_, registry2.getOrCreateHolder(p_190037_));
    }

    public long seed() {
        return this.seed;
    }

    public boolean generateFeatures() {
        return this.generateFeatures;
    }

    public boolean generateBonusChest() {
        return this.generateBonusChest;
    }

    public static Registry<LevelStem> withOverworld(Registry<DimensionType> pDimensions, Registry<LevelStem> pDimensionTypes, ChunkGenerator pChunkGenerator) {
        LevelStem levelstem = pDimensionTypes.get(LevelStem.OVERWORLD);
        Holder<DimensionType> holder = levelstem == null ? pDimensions.getOrCreateHolder(DimensionType.OVERWORLD_LOCATION) : levelstem.typeHolder();
        return WorldGenSettings.withOverworld(pDimensionTypes, holder, pChunkGenerator);
    }

    public static Registry<LevelStem> withOverworld(Registry<LevelStem> pDimensions, Holder<DimensionType> pDimensionTypes, ChunkGenerator pChunkGenerator) {
        MappedRegistry<LevelStem> writableregistry = new MappedRegistry<LevelStem>(Registry.LEVEL_STEM_REGISTRY, Lifecycle.experimental(), null);
        ((WritableRegistry)writableregistry).register(LevelStem.OVERWORLD, new LevelStem(pDimensionTypes, pChunkGenerator), Lifecycle.stable());
        for (Map.Entry<ResourceKey<LevelStem>, LevelStem> entry : pDimensions.entrySet()) {
            ResourceKey<LevelStem> resourcekey = entry.getKey();
            if (resourcekey == LevelStem.OVERWORLD) continue;
            ((WritableRegistry)writableregistry).register(resourcekey, entry.getValue(), pDimensions.lifecycle(entry.getValue()));
        }
        return writableregistry;
    }

    public Registry<LevelStem> dimensions() {
        return this.dimensions;
    }

    public ChunkGenerator overworld() {
        LevelStem levelstem = this.dimensions.get(LevelStem.OVERWORLD);
        if (levelstem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return levelstem.generator();
    }

    public ImmutableSet<ResourceKey<Level>> levels() {
        return (ImmutableSet)this.dimensions().entrySet().stream().map(Map.Entry::getKey).map(WorldGenSettings::levelStemToLevel).collect(ImmutableSet.toImmutableSet());
    }

    public static ResourceKey<Level> levelStemToLevel(ResourceKey<LevelStem> p_190049_) {
        return ResourceKey.create(Registry.DIMENSION_REGISTRY, p_190049_.location());
    }

    public static ResourceKey<LevelStem> levelToLevelStem(ResourceKey<Level> p_190053_) {
        return ResourceKey.create(Registry.LEVEL_STEM_REGISTRY, p_190053_.location());
    }

    public boolean isDebug() {
        return this.overworld() instanceof DebugLevelSource;
    }

    public boolean isFlatWorld() {
        return this.overworld() instanceof FlatLevelSource;
    }

    public boolean isOldCustomizedWorld() {
        return this.legacyCustomOptions.isPresent();
    }

    public WorldGenSettings withBonusChest() {
        return new WorldGenSettings(this.seed, this.generateFeatures, true, this.dimensions, this.legacyCustomOptions);
    }

    public WorldGenSettings withFeaturesToggled() {
        return new WorldGenSettings(this.seed, !this.generateFeatures, this.generateBonusChest, this.dimensions);
    }

    public WorldGenSettings withBonusChestToggled() {
        return new WorldGenSettings(this.seed, this.generateFeatures, !this.generateBonusChest, this.dimensions);
    }

    public static WorldGenSettings create(RegistryAccess pRegistryAccess, DedicatedServerProperties.WorldGenProperties pProperties) {
        String s;
        long i = WorldGenSettings.parseSeed(pProperties.levelSeed()).orElse(new Random().nextLong());
        Registry<DimensionType> registry = pRegistryAccess.registryOrThrow(Registry.DIMENSION_TYPE_REGISTRY);
        Registry<Biome> registry1 = pRegistryAccess.registryOrThrow(Registry.BIOME_REGISTRY);
        Registry<StructureSet> registry2 = pRegistryAccess.registryOrThrow(Registry.STRUCTURE_SET_REGISTRY);
        Registry<LevelStem> registry3 = DimensionType.defaultDimensions(pRegistryAccess, i);
        switch (s = pProperties.levelType()) {
            case "flat": {
                Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)pProperties.generatorSettings());
                return new WorldGenSettings(i, pProperties.generateStructures(), false, WorldGenSettings.withOverworld(registry, registry3, (ChunkGenerator)new FlatLevelSource(registry2, FlatLevelGeneratorSettings.CODEC.parse(dynamic).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(() -> FlatLevelGeneratorSettings.getDefault(registry1, registry2)))));
            }
            case "debug_all_block_states": {
                return new WorldGenSettings(i, pProperties.generateStructures(), false, WorldGenSettings.withOverworld(registry, registry3, (ChunkGenerator)new DebugLevelSource(registry2, registry1)));
            }
            case "amplified": {
                return new WorldGenSettings(i, pProperties.generateStructures(), false, WorldGenSettings.withOverworld(registry, registry3, (ChunkGenerator)WorldGenSettings.makeOverworld(pRegistryAccess, i, NoiseGeneratorSettings.AMPLIFIED)));
            }
            case "largebiomes": {
                return new WorldGenSettings(i, pProperties.generateStructures(), false, WorldGenSettings.withOverworld(registry, registry3, (ChunkGenerator)WorldGenSettings.makeOverworld(pRegistryAccess, i, NoiseGeneratorSettings.LARGE_BIOMES)));
            }
        }
        return new WorldGenSettings(i, pProperties.generateStructures(), false, WorldGenSettings.withOverworld(registry, registry3, (ChunkGenerator)WorldGenSettings.makeDefaultOverworld(pRegistryAccess, i)));
    }

    public WorldGenSettings withSeed(boolean pHardcore, OptionalLong pLevelSeed) {
        Registry<LevelStem> registry;
        long i = pLevelSeed.orElse(this.seed);
        if (pLevelSeed.isPresent()) {
            MappedRegistry<LevelStem> writableregistry = new MappedRegistry<LevelStem>(Registry.LEVEL_STEM_REGISTRY, Lifecycle.experimental(), null);
            long j = pLevelSeed.getAsLong();
            for (Map.Entry<ResourceKey<LevelStem>, LevelStem> entry : this.dimensions.entrySet()) {
                ResourceKey<LevelStem> resourcekey = entry.getKey();
                ((WritableRegistry)writableregistry).register(resourcekey, new LevelStem(entry.getValue().typeHolder(), entry.getValue().generator().withSeed(j)), this.dimensions.lifecycle(entry.getValue()));
            }
            registry = writableregistry;
        } else {
            registry = this.dimensions;
        }
        WorldGenSettings worldgensettings = this.isDebug() ? new WorldGenSettings(i, false, false, registry) : new WorldGenSettings(i, this.generateFeatures(), this.generateBonusChest() && !pHardcore, registry);
        return worldgensettings;
    }

    public static OptionalLong parseSeed(String p_202193_) {
        if (StringUtils.isEmpty((CharSequence)(p_202193_ = p_202193_.trim()))) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Long.parseLong(p_202193_));
        }
        catch (NumberFormatException numberformatexception) {
            return OptionalLong.of(p_202193_.hashCode());
        }
    }
}

