/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Longs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.Xoroshiro128PlusPlus;

public class XoroshiroRandomSource
implements RandomSource {
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private Xoroshiro128PlusPlus randomNumberGenerator;
    private final MarsagliaPolarGaussian gaussianSource = new MarsagliaPolarGaussian(this);

    public XoroshiroRandomSource(long p_190102_) {
        this.randomNumberGenerator = new Xoroshiro128PlusPlus(RandomSupport.upgradeSeedTo128bit(p_190102_));
    }

    public XoroshiroRandomSource(long p_190104_, long p_190105_) {
        this.randomNumberGenerator = new Xoroshiro128PlusPlus(p_190104_, p_190105_);
    }

    @Override
    public RandomSource fork() {
        return new XoroshiroRandomSource(this.randomNumberGenerator.nextLong(), this.randomNumberGenerator.nextLong());
    }

    @Override
    public PositionalRandomFactory forkPositional() {
        return new XoroshiroPositionalRandomFactory(this.randomNumberGenerator.nextLong(), this.randomNumberGenerator.nextLong());
    }

    @Override
    public void setSeed(long p_190121_) {
        this.randomNumberGenerator = new Xoroshiro128PlusPlus(RandomSupport.upgradeSeedTo128bit(p_190121_));
        this.gaussianSource.reset();
    }

    @Override
    public int nextInt() {
        return (int)this.randomNumberGenerator.nextLong();
    }

    @Override
    public int nextInt(int p_190118_) {
        if (p_190118_ <= 0) {
            throw new IllegalArgumentException("Bound must be positive");
        }
        long i = Integer.toUnsignedLong(this.nextInt());
        long j = i * (long)p_190118_;
        long k = j & 0xFFFFFFFFL;
        if (k < (long)p_190118_) {
            int l = Integer.remainderUnsigned(~p_190118_ + 1, p_190118_);
            while (k < (long)l) {
                i = Integer.toUnsignedLong(this.nextInt());
                j = i * (long)p_190118_;
                k = j & 0xFFFFFFFFL;
            }
        }
        long i1 = j >> 32;
        return (int)i1;
    }

    @Override
    public long nextLong() {
        return this.randomNumberGenerator.nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return (this.randomNumberGenerator.nextLong() & 1L) != 0L;
    }

    @Override
    public float nextFloat() {
        return (float)this.nextBits(24) * 5.9604645E-8f;
    }

    @Override
    public double nextDouble() {
        return (double)this.nextBits(53) * (double)1.110223E-16f;
    }

    @Override
    public double nextGaussian() {
        return this.gaussianSource.nextGaussian();
    }

    @Override
    public void consumeCount(int p_190111_) {
        int i = 0;
        while (i < p_190111_) {
            this.randomNumberGenerator.nextLong();
            ++i;
        }
    }

    private long nextBits(int p_190108_) {
        return this.randomNumberGenerator.nextLong() >>> 64 - p_190108_;
    }

    public static class XoroshiroPositionalRandomFactory
    implements PositionalRandomFactory {
        private static final HashFunction MD5_128 = Hashing.md5();
        private final long seedLo;
        private final long seedHi;

        public XoroshiroPositionalRandomFactory(long p_190127_, long p_190128_) {
            this.seedLo = p_190127_;
            this.seedHi = p_190128_;
        }

        @Override
        public RandomSource at(int p_190130_, int p_190131_, int p_190132_) {
            long i = Mth.getSeed(p_190130_, p_190131_, p_190132_);
            long j = i ^ this.seedLo;
            return new XoroshiroRandomSource(j, this.seedHi);
        }

        @Override
        public RandomSource fromHashOf(String p_190134_) {
            byte[] abyte = MD5_128.hashString((CharSequence)p_190134_, Charsets.UTF_8).asBytes();
            long i = Longs.fromBytes((byte)abyte[0], (byte)abyte[1], (byte)abyte[2], (byte)abyte[3], (byte)abyte[4], (byte)abyte[5], (byte)abyte[6], (byte)abyte[7]);
            long j = Longs.fromBytes((byte)abyte[8], (byte)abyte[9], (byte)abyte[10], (byte)abyte[11], (byte)abyte[12], (byte)abyte[13], (byte)abyte[14], (byte)abyte[15]);
            return new XoroshiroRandomSource(i ^ this.seedLo, j ^ this.seedHi);
        }

        @Override
        @VisibleForTesting
        public void parityConfigString(StringBuilder p_190136_) {
            p_190136_.append("seedLo: ").append(this.seedLo).append(", seedHi: ").append(this.seedHi);
        }
    }
}

