/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class Blender {
    private static final Blender EMPTY = new Blender(new Long2ObjectOpenHashMap(), new Long2ObjectOpenHashMap()){

        @Override
        public BlendingOutput blendOffsetAndFactor(int p_209724_, int p_209725_) {
            return new BlendingOutput(1.0, 0.0);
        }

        @Override
        public double blendDensity(DensityFunction.FunctionContext p_209727_, double p_209728_) {
            return p_209728_;
        }

        @Override
        public BiomeResolver getBiomeResolver(BiomeResolver p_190232_) {
            return p_190232_;
        }
    };
    private static final NormalNoise SHIFT_NOISE = NormalNoise.create(new XoroshiroRandomSource(42L), BuiltinRegistries.NOISE.getOrThrow(Noises.SHIFT));
    private static final int HEIGHT_BLENDING_RANGE_CELLS = QuartPos.fromSection(7) - 1;
    private static final int HEIGHT_BLENDING_RANGE_CHUNKS = QuartPos.toSection(HEIGHT_BLENDING_RANGE_CELLS + 3);
    private static final int DENSITY_BLENDING_RANGE_CELLS = 2;
    private static final int DENSITY_BLENDING_RANGE_CHUNKS = QuartPos.toSection(5);
    private static final double OLD_CHUNK_Y_RADIUS = (double)BlendingData.AREA_WITH_OLD_GENERATION.getHeight() / 2.0;
    private static final double OLD_CHUNK_CENTER_Y = (double)BlendingData.AREA_WITH_OLD_GENERATION.getMinBuildHeight() + OLD_CHUNK_Y_RADIUS;
    private static final double OLD_CHUNK_XZ_RADIUS = 8.0;
    private final Long2ObjectOpenHashMap<BlendingData> blendingData;
    private final Long2ObjectOpenHashMap<BlendingData> blendingDataForDensityBlending;

    public static Blender empty() {
        return EMPTY;
    }

    public static Blender of(@Nullable WorldGenRegion p_190203_) {
        if (p_190203_ == null) {
            return EMPTY;
        }
        Long2ObjectOpenHashMap long2objectopenhashmap = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap long2objectopenhashmap1 = new Long2ObjectOpenHashMap();
        ChunkPos chunkpos = p_190203_.getCenter();
        int i = -HEIGHT_BLENDING_RANGE_CHUNKS;
        while (i <= HEIGHT_BLENDING_RANGE_CHUNKS) {
            int j = -HEIGHT_BLENDING_RANGE_CHUNKS;
            while (j <= HEIGHT_BLENDING_RANGE_CHUNKS) {
                int k = chunkpos.x + i;
                int l = chunkpos.z + j;
                BlendingData blendingdata = BlendingData.getOrUpdateBlendingData(p_190203_, k, l);
                if (blendingdata != null) {
                    long2objectopenhashmap.put(ChunkPos.asLong(k, l), (Object)blendingdata);
                    if (i >= -DENSITY_BLENDING_RANGE_CHUNKS && i <= DENSITY_BLENDING_RANGE_CHUNKS && j >= -DENSITY_BLENDING_RANGE_CHUNKS && j <= DENSITY_BLENDING_RANGE_CHUNKS) {
                        long2objectopenhashmap1.put(ChunkPos.asLong(k, l), (Object)blendingdata);
                    }
                }
                ++j;
            }
            ++i;
        }
        return long2objectopenhashmap.isEmpty() && long2objectopenhashmap1.isEmpty() ? EMPTY : new Blender((Long2ObjectOpenHashMap<BlendingData>)long2objectopenhashmap, (Long2ObjectOpenHashMap<BlendingData>)long2objectopenhashmap1);
    }

    Blender(Long2ObjectOpenHashMap<BlendingData> p_202197_, Long2ObjectOpenHashMap<BlendingData> p_202198_) {
        this.blendingData = p_202197_;
        this.blendingDataForDensityBlending = p_202198_;
    }

    public BlendingOutput blendOffsetAndFactor(int p_209719_, int p_209720_) {
        int j;
        int i = QuartPos.fromBlock(p_209719_);
        double d0 = this.getBlendingDataValue(i, 0, j = QuartPos.fromBlock(p_209720_), BlendingData::getHeight);
        if (d0 != Double.MAX_VALUE) {
            return new BlendingOutput(0.0, Blender.heightToOffset(d0));
        }
        MutableDouble mutabledouble = new MutableDouble(0.0);
        MutableDouble mutabledouble1 = new MutableDouble(0.0);
        MutableDouble mutabledouble2 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.blendingData.forEach((p_202243_5_, p_202243_6_) -> p_202243_6_.iterateHeights(QuartPos.fromSection(ChunkPos.getX(p_202243_5_)), QuartPos.fromSection(ChunkPos.getZ(p_202243_5_)), (p_190193_5_, p_190193_6_, p_190193_7_) -> {
            double d3 = Mth.length(i - p_190193_5_, j - p_190193_6_);
            if (!(d3 > (double)HEIGHT_BLENDING_RANGE_CELLS)) {
                if (d3 < mutabledouble2.doubleValue()) {
                    mutabledouble2.setValue(d3);
                }
                double d4 = 1.0 / (d3 * d3 * d3 * d3);
                mutabledouble1.add(p_190193_7_ * d4);
                mutabledouble.add(d4);
            }
        }));
        if (mutabledouble2.doubleValue() == Double.POSITIVE_INFINITY) {
            return new BlendingOutput(1.0, 0.0);
        }
        double d1 = mutabledouble1.doubleValue() / mutabledouble.doubleValue();
        double d2 = Mth.clamp(mutabledouble2.doubleValue() / (double)(HEIGHT_BLENDING_RANGE_CELLS + 1), 0.0, 1.0);
        d2 = 3.0 * d2 * d2 - 2.0 * d2 * d2 * d2;
        return new BlendingOutput(d2, Blender.heightToOffset(d1));
    }

    private static double heightToOffset(double p_190155_) {
        double d0 = 1.0;
        double d1 = p_190155_ + 0.5;
        double d2 = Mth.positiveModulo(d1, 8.0);
        return 1.0 * (32.0 * (d1 - 128.0) - 3.0 * (d1 - 120.0) * d2 + 3.0 * d2 * d2) / (128.0 * (32.0 - 3.0 * d2));
    }

    public double blendDensity(DensityFunction.FunctionContext p_209721_, double p_209722_) {
        int k;
        int j;
        int i = QuartPos.fromBlock(p_209721_.blockX());
        double d0 = this.getBlendingDataValue(i, j = p_209721_.blockY() / 8, k = QuartPos.fromBlock(p_209721_.blockZ()), BlendingData::getDensity);
        if (d0 != Double.MAX_VALUE) {
            return d0;
        }
        MutableDouble mutabledouble = new MutableDouble(0.0);
        MutableDouble mutabledouble1 = new MutableDouble(0.0);
        MutableDouble mutabledouble2 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.blendingDataForDensityBlending.forEach((p_202234_6_, p_202234_7_) -> p_202234_7_.iterateDensities(QuartPos.fromSection(ChunkPos.getX(p_202234_6_)), QuartPos.fromSection(ChunkPos.getZ(p_202234_6_)), j - 1, j + 1, (p_202223_6_, p_202223_7_, p_202223_8_, p_202223_9_) -> {
            double d3 = Mth.length(i - p_202223_6_, (j - p_202223_7_) * 2, k - p_202223_8_);
            if (!(d3 > 2.0)) {
                if (d3 < mutabledouble2.doubleValue()) {
                    mutabledouble2.setValue(d3);
                }
                double d4 = 1.0 / (d3 * d3 * d3 * d3);
                mutabledouble1.add(p_202223_9_ * d4);
                mutabledouble.add(d4);
            }
        }));
        if (mutabledouble2.doubleValue() == Double.POSITIVE_INFINITY) {
            return p_209722_;
        }
        double d1 = mutabledouble1.doubleValue() / mutabledouble.doubleValue();
        double d2 = Mth.clamp(mutabledouble2.doubleValue() / 3.0, 0.0, 1.0);
        return Mth.lerp(d2, d1, p_209722_);
    }

    private double getBlendingDataValue(int p_190175_, int p_190176_, int p_190177_, CellValueGetter p_190178_) {
        int i = QuartPos.toSection(p_190175_);
        int j = QuartPos.toSection(p_190177_);
        boolean flag = (p_190175_ & 3) == 0;
        boolean flag1 = (p_190177_ & 3) == 0;
        double d0 = this.getBlendingDataValue(p_190178_, i, j, p_190175_, p_190176_, p_190177_);
        if (d0 == Double.MAX_VALUE) {
            if (flag && flag1) {
                d0 = this.getBlendingDataValue(p_190178_, i - 1, j - 1, p_190175_, p_190176_, p_190177_);
            }
            if (d0 == Double.MAX_VALUE) {
                if (flag) {
                    d0 = this.getBlendingDataValue(p_190178_, i - 1, j, p_190175_, p_190176_, p_190177_);
                }
                if (d0 == Double.MAX_VALUE && flag1) {
                    d0 = this.getBlendingDataValue(p_190178_, i, j - 1, p_190175_, p_190176_, p_190177_);
                }
            }
        }
        return d0;
    }

    private double getBlendingDataValue(CellValueGetter p_190212_, int p_190213_, int p_190214_, int p_190215_, int p_190216_, int p_190217_) {
        BlendingData blendingdata = (BlendingData)this.blendingData.get(ChunkPos.asLong(p_190213_, p_190214_));
        return blendingdata != null ? p_190212_.get(blendingdata, p_190215_ - QuartPos.fromSection(p_190213_), p_190216_, p_190217_ - QuartPos.fromSection(p_190214_)) : Double.MAX_VALUE;
    }

    public BiomeResolver getBiomeResolver(BiomeResolver p_190204_) {
        return (p_204667_2_, p_204667_3_, p_204667_4_, p_204667_5_) -> {
            Holder<Biome> holder = this.blendBiome(p_204667_2_, p_204667_4_);
            return holder == null ? p_190204_.getNoiseBiome(p_204667_2_, p_204667_3_, p_204667_4_, p_204667_5_) : holder;
        };
    }

    @Nullable
    private Holder<Biome> blendBiome(int p_204665_, int p_204666_) {
        double d0 = (double)p_204665_ + SHIFT_NOISE.getValue(p_204665_, 0.0, p_204666_) * 12.0;
        double d1 = (double)p_204666_ + SHIFT_NOISE.getValue(p_204666_, p_204665_, 0.0) * 12.0;
        MutableDouble mutabledouble = new MutableDouble(Double.POSITIVE_INFINITY);
        MutableObject mutableobject = new MutableObject();
        this.blendingData.forEach((p_202213_6_, p_202213_7_) -> p_202213_7_.iterateBiomes(QuartPos.fromSection(ChunkPos.getX(p_202213_6_)), QuartPos.fromSection(ChunkPos.getZ(p_202213_6_)), (p_204656_6_, p_204656_7_, p_204656_8_) -> {
            double d3 = Mth.length(d0 - (double)p_204656_6_, d1 - (double)p_204656_7_);
            if (!(d3 > (double)HEIGHT_BLENDING_RANGE_CELLS) && d3 < mutabledouble.doubleValue()) {
                mutableobject.setValue((Object)p_204656_8_);
                mutabledouble.setValue(d3);
            }
        }));
        if (mutabledouble.doubleValue() == Double.POSITIVE_INFINITY) {
            return null;
        }
        double d2 = Mth.clamp(mutabledouble.doubleValue() / (double)(HEIGHT_BLENDING_RANGE_CELLS + 1), 0.0, 1.0);
        return d2 > 0.5 ? null : (Holder)mutableobject.getValue();
    }

    public static void generateBorderTicks(WorldGenRegion p_197032_, ChunkAccess p_197033_) {
        ChunkPos chunkpos = p_197033_.getPos();
        boolean flag = p_197033_.isOldNoiseGeneration();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockPos blockpos = new BlockPos(chunkpos.getMinBlockX(), 0, chunkpos.getMinBlockZ());
        int i = BlendingData.AREA_WITH_OLD_GENERATION.getMinBuildHeight();
        int j = BlendingData.AREA_WITH_OLD_GENERATION.getMaxBuildHeight() - 1;
        if (flag) {
            int k = 0;
            while (k < 16) {
                int l = 0;
                while (l < 16) {
                    Blender.generateBorderTick(p_197033_, blockpos$mutableblockpos.setWithOffset(blockpos, k, i - 1, l));
                    Blender.generateBorderTick(p_197033_, blockpos$mutableblockpos.setWithOffset(blockpos, k, i, l));
                    Blender.generateBorderTick(p_197033_, blockpos$mutableblockpos.setWithOffset(blockpos, k, j, l));
                    Blender.generateBorderTick(p_197033_, blockpos$mutableblockpos.setWithOffset(blockpos, k, j + 1, l));
                    ++l;
                }
                ++k;
            }
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (p_197032_.getChunk(chunkpos.x + direction.getStepX(), chunkpos.z + direction.getStepZ()).isOldNoiseGeneration() == flag) continue;
            int i1 = direction == Direction.EAST ? 15 : 0;
            int j1 = direction == Direction.WEST ? 0 : 15;
            int k1 = direction == Direction.SOUTH ? 15 : 0;
            int l1 = direction == Direction.NORTH ? 0 : 15;
            int i2 = i1;
            while (i2 <= j1) {
                int j2 = k1;
                while (j2 <= l1) {
                    int k2 = Math.min(j, p_197033_.getHeight(Heightmap.Types.MOTION_BLOCKING, i2, j2)) + 1;
                    int l2 = i;
                    while (l2 < k2) {
                        Blender.generateBorderTick(p_197033_, blockpos$mutableblockpos.setWithOffset(blockpos, i2, l2, j2));
                        ++l2;
                    }
                    ++j2;
                }
                ++i2;
            }
        }
    }

    private static void generateBorderTick(ChunkAccess p_197041_, BlockPos p_197042_) {
        FluidState fluidstate;
        BlockState blockstate = p_197041_.getBlockState(p_197042_);
        if (blockstate.is(BlockTags.LEAVES)) {
            p_197041_.markPosForPostprocessing(p_197042_);
        }
        if (!(fluidstate = p_197041_.getFluidState(p_197042_)).isEmpty()) {
            p_197041_.markPosForPostprocessing(p_197042_);
        }
    }

    public static void addAroundOldChunksCarvingMaskFilter(WorldGenLevel p_197035_, ProtoChunk p_197036_) {
        ChunkPos chunkpos = p_197036_.getPos();
        DistanceGetter blender$distancegetter = Blender.makeOldChunkDistanceGetter(p_197036_.isOldNoiseGeneration(), BlendingData.sideByGenerationAge(p_197035_, chunkpos.x, chunkpos.z, true));
        if (blender$distancegetter != null) {
            CarvingMask.Mask carvingmask$mask = (p_202260_1_, p_202260_2_, p_202260_3_) -> {
                double d2;
                double d1;
                double d0 = (double)p_202260_1_ + 0.5 + SHIFT_NOISE.getValue(p_202260_1_, p_202260_2_, p_202260_3_) * 4.0;
                return blender$distancegetter.getDistance(d0, d1 = (double)p_202260_2_ + 0.5 + SHIFT_NOISE.getValue(p_202260_2_, p_202260_3_, p_202260_1_) * 4.0, d2 = (double)p_202260_3_ + 0.5 + SHIFT_NOISE.getValue(p_202260_3_, p_202260_1_, p_202260_2_) * 4.0) < 4.0;
            };
            Stream.of(GenerationStep.Carving.values()).map(p_197036_::getOrCreateCarvingMask).forEach(p_202257_1_ -> p_202257_1_.setAdditionalMask(carvingmask$mask));
        }
    }

    @Nullable
    public static DistanceGetter makeOldChunkDistanceGetter(boolean p_197059_, Set<Direction8> p_197060_) {
        if (!p_197059_ && p_197060_.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        if (p_197059_) {
            list.add(Blender.makeOffsetOldChunkDistanceGetter(null));
        }
        p_197060_.forEach(p_202270_1_ -> list.add(Blender.makeOffsetOldChunkDistanceGetter(p_202270_1_)));
        return (p_202265_1_, p_202265_3_, p_202265_5_) -> {
            double d0 = Double.POSITIVE_INFINITY;
            for (DistanceGetter blender$distancegetter : list) {
                double d1 = blender$distancegetter.getDistance(p_202265_1_, p_202265_3_, p_202265_5_);
                if (!(d1 < d0)) continue;
                d0 = d1;
            }
            return d0;
        };
    }

    private static DistanceGetter makeOffsetOldChunkDistanceGetter(@Nullable Direction8 p_197049_) {
        double d0 = 0.0;
        double d1 = 0.0;
        if (p_197049_ != null) {
            for (Direction direction : p_197049_.getDirections()) {
                d0 += (double)(direction.getStepX() * 16);
                d1 += (double)(direction.getStepZ() * 16);
            }
        }
        double d3 = d0;
        double d2 = d1;
        return (p_202199_4_, p_202199_6_, p_202199_8_) -> Blender.distanceToCube(p_202199_4_ - 8.0 - d3, p_202199_6_ - OLD_CHUNK_CENTER_Y, p_202199_8_ - 8.0 - d2, 8.0, OLD_CHUNK_Y_RADIUS, 8.0);
    }

    private static double distanceToCube(double p_197025_, double p_197026_, double p_197027_, double p_197028_, double p_197029_, double p_197030_) {
        double d0 = Math.abs(p_197025_) - p_197028_;
        double d1 = Math.abs(p_197026_) - p_197029_;
        double d2 = Math.abs(p_197027_) - p_197030_;
        return Mth.length(Math.max(0.0, d0), Math.max(0.0, d1), Math.max(0.0, d2));
    }

    public record BlendingOutput(double alpha, double blendingOffset) {
    }

    static interface CellValueGetter {
        public double get(BlendingData var1, int var2, int var3, int var4);
    }

    public static interface DistanceGetter {
        public double getDistance(double var1, double var3, double var5);
    }
}

