/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public abstract class AbstractHugeMushroomFeature
extends Feature<HugeMushroomFeatureConfiguration> {
    public AbstractHugeMushroomFeature(Codec<HugeMushroomFeatureConfiguration> p_65093_) {
        super(p_65093_);
    }

    protected void placeTrunk(LevelAccessor pLevel, Random pRandom, BlockPos pPos, HugeMushroomFeatureConfiguration pConfig, int pMaxHeight, BlockPos.MutableBlockPos pMutablePos) {
        int i = 0;
        while (i < pMaxHeight) {
            pMutablePos.set(pPos).move(Direction.UP, i);
            if (!pLevel.getBlockState(pMutablePos).isSolidRender(pLevel, pMutablePos)) {
                this.setBlock(pLevel, pMutablePos, pConfig.stemProvider.getState(pRandom, pPos));
            }
            ++i;
        }
    }

    protected int getTreeHeight(Random pRandom) {
        int i = pRandom.nextInt(3) + 4;
        if (pRandom.nextInt(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected boolean isValidPosition(LevelAccessor pLevel, BlockPos pPos, int pMaxHeight, BlockPos.MutableBlockPos pMutablePos, HugeMushroomFeatureConfiguration pConfig) {
        int i = pPos.getY();
        if (i >= pLevel.getMinBuildHeight() + 1 && i + pMaxHeight + 1 < pLevel.getMaxBuildHeight()) {
            BlockState blockstate = pLevel.getBlockState(pPos.below());
            if (!AbstractHugeMushroomFeature.isDirt(blockstate) && !blockstate.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
                return false;
            }
            int j = 0;
            while (j <= pMaxHeight) {
                int k = this.getTreeRadiusForHeight(-1, -1, pConfig.foliageRadius, j);
                int l = -k;
                while (l <= k) {
                    int i1 = -k;
                    while (i1 <= k) {
                        BlockState blockstate1 = pLevel.getBlockState(pMutablePos.setWithOffset(pPos, l, j, i1));
                        if (!blockstate1.isAir() && !blockstate1.is(BlockTags.LEAVES)) {
                            return false;
                        }
                        ++i1;
                    }
                    ++l;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean place(FeaturePlaceContext<HugeMushroomFeatureConfiguration> pContext) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos;
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        Random random = pContext.random();
        HugeMushroomFeatureConfiguration hugemushroomfeatureconfiguration = pContext.config();
        int i = this.getTreeHeight(random);
        if (!this.isValidPosition(worldgenlevel, blockpos, i, blockpos$mutableblockpos = new BlockPos.MutableBlockPos(), hugemushroomfeatureconfiguration)) {
            return false;
        }
        this.makeCap(worldgenlevel, random, blockpos, i, blockpos$mutableblockpos, hugemushroomfeatureconfiguration);
        this.placeTrunk(worldgenlevel, random, blockpos, hugemushroomfeatureconfiguration, i, blockpos$mutableblockpos);
        return true;
    }

    protected abstract int getTreeRadiusForHeight(int var1, int var2, int var3, int var4);

    protected abstract void makeCap(LevelAccessor var1, Random var2, BlockPos var3, int var4, BlockPos.MutableBlockPos var5, HugeMushroomFeatureConfiguration var6);
}

