/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;

public class BasaltColumnsFeature
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.LAVA, (Object)Blocks.BEDROCK, (Object)Blocks.MAGMA_BLOCK, (Object)Blocks.SOUL_SAND, (Object)Blocks.NETHER_BRICKS, (Object)Blocks.NETHER_BRICK_FENCE, (Object)Blocks.NETHER_BRICK_STAIRS, (Object)Blocks.NETHER_WART, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER);
    private static final int CLUSTERED_REACH = 5;
    private static final int CLUSTERED_SIZE = 50;
    private static final int UNCLUSTERED_REACH = 8;
    private static final int UNCLUSTERED_SIZE = 15;

    public BasaltColumnsFeature(Codec<ColumnFeatureConfiguration> p_65153_) {
        super(p_65153_);
    }

    @Override
    public boolean place(FeaturePlaceContext<ColumnFeatureConfiguration> pContext) {
        int i = pContext.chunkGenerator().getSeaLevel();
        BlockPos blockpos = pContext.origin();
        WorldGenLevel worldgenlevel = pContext.level();
        Random random = pContext.random();
        ColumnFeatureConfiguration columnfeatureconfiguration = pContext.config();
        if (!BasaltColumnsFeature.canPlaceAt(worldgenlevel, i, blockpos.mutable())) {
            return false;
        }
        int j = columnfeatureconfiguration.height().sample(random);
        boolean flag = random.nextFloat() < 0.9f;
        int k = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockpos1 : BlockPos.randomBetweenClosed(random, l, blockpos.getX() - k, blockpos.getY(), blockpos.getZ() - k, blockpos.getX() + k, blockpos.getY(), blockpos.getZ() + k)) {
            int i1 = j - blockpos1.distManhattan(blockpos);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn(worldgenlevel, i, blockpos1, i1, columnfeatureconfiguration.reach().sample(random));
        }
        return flag1;
    }

    private boolean placeColumn(LevelAccessor pLevel, int pSeaLevel, BlockPos pPos, int pDistance, int pReach) {
        boolean flag = false;
        block0: for (BlockPos blockpos : BlockPos.betweenClosed(pPos.getX() - pReach, pPos.getY(), pPos.getZ() - pReach, pPos.getX() + pReach, pPos.getY(), pPos.getZ() + pReach)) {
            BlockPos blockpos1;
            int i = blockpos.distManhattan(pPos);
            BlockPos blockPos = blockpos1 = BasaltColumnsFeature.isAirOrLavaOcean(pLevel, pSeaLevel, blockpos) ? BasaltColumnsFeature.findSurface(pLevel, pSeaLevel, blockpos.mutable(), i) : BasaltColumnsFeature.findAir(pLevel, blockpos.mutable(), i);
            if (blockpos1 == null) continue;
            int j = pDistance - i / 2;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos1.mutable();
            while (j >= 0) {
                if (BasaltColumnsFeature.isAirOrLavaOcean(pLevel, pSeaLevel, blockpos$mutableblockpos)) {
                    this.setBlock(pLevel, blockpos$mutableblockpos, Blocks.BASALT.defaultBlockState());
                    blockpos$mutableblockpos.move(Direction.UP);
                    flag = true;
                } else {
                    if (!pLevel.getBlockState(blockpos$mutableblockpos).is(Blocks.BASALT)) continue block0;
                    blockpos$mutableblockpos.move(Direction.UP);
                }
                --j;
            }
        }
        return flag;
    }

    @Nullable
    private static BlockPos findSurface(LevelAccessor pLevel, int pSeaLevel, BlockPos.MutableBlockPos pPos, int pDistance) {
        while (pPos.getY() > pLevel.getMinBuildHeight() + 1 && pDistance > 0) {
            --pDistance;
            if (BasaltColumnsFeature.canPlaceAt(pLevel, pSeaLevel, pPos)) {
                return pPos;
            }
            pPos.move(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor pLevel, int pSeaLevel, BlockPos.MutableBlockPos pPos) {
        if (!BasaltColumnsFeature.isAirOrLavaOcean(pLevel, pSeaLevel, pPos)) {
            return false;
        }
        BlockState blockstate = pLevel.getBlockState(pPos.move(Direction.DOWN));
        pPos.move(Direction.UP);
        return !blockstate.isAir() && !CANNOT_PLACE_ON.contains((Object)blockstate.getBlock());
    }

    @Nullable
    private static BlockPos findAir(LevelAccessor pLevel, BlockPos.MutableBlockPos pPos, int pDistance) {
        while (pPos.getY() < pLevel.getMaxBuildHeight() && pDistance > 0) {
            --pDistance;
            BlockState blockstate = pLevel.getBlockState(pPos);
            if (CANNOT_PLACE_ON.contains((Object)blockstate.getBlock())) {
                return null;
            }
            if (blockstate.isAir()) {
                return pPos;
            }
            pPos.move(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(LevelAccessor pLevel, int pSeaLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        return blockstate.isAir() || blockstate.is(Blocks.LAVA) && pPos.getY() <= pSeaLevel;
    }
}

