/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;

public class DeltaFeature
extends Feature<DeltaFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_REPLACE = ImmutableList.of((Object)Blocks.BEDROCK, (Object)Blocks.NETHER_BRICKS, (Object)Blocks.NETHER_BRICK_FENCE, (Object)Blocks.NETHER_BRICK_STAIRS, (Object)Blocks.NETHER_WART, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER);
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final double RIM_SPAWN_CHANCE = 0.9;

    public DeltaFeature(Codec<DeltaFeatureConfiguration> p_65550_) {
        super(p_65550_);
    }

    @Override
    public boolean place(FeaturePlaceContext<DeltaFeatureConfiguration> pContext) {
        boolean flag = false;
        Random random = pContext.random();
        WorldGenLevel worldgenlevel = pContext.level();
        DeltaFeatureConfiguration deltafeatureconfiguration = pContext.config();
        BlockPos blockpos = pContext.origin();
        boolean flag1 = random.nextDouble() < 0.9;
        int i = flag1 ? deltafeatureconfiguration.rimSize().sample(random) : 0;
        int j = flag1 ? deltafeatureconfiguration.rimSize().sample(random) : 0;
        boolean flag2 = flag1 && i != 0 && j != 0;
        int k = deltafeatureconfiguration.size().sample(random);
        int l = deltafeatureconfiguration.size().sample(random);
        int i1 = Math.max(k, l);
        for (BlockPos blockpos1 : BlockPos.withinManhattan(blockpos, k, 0, l)) {
            BlockPos blockpos2;
            if (blockpos1.distManhattan(blockpos) > i1) break;
            if (!DeltaFeature.isClear(worldgenlevel, blockpos1, deltafeatureconfiguration)) continue;
            if (flag2) {
                flag = true;
                this.setBlock(worldgenlevel, blockpos1, deltafeatureconfiguration.rim());
            }
            if (!DeltaFeature.isClear(worldgenlevel, blockpos2 = blockpos1.offset(i, 0, j), deltafeatureconfiguration)) continue;
            flag = true;
            this.setBlock(worldgenlevel, blockpos2, deltafeatureconfiguration.contents());
        }
        return flag;
    }

    private static boolean isClear(LevelAccessor pLevel, BlockPos pPos, DeltaFeatureConfiguration pConfig) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (blockstate.is(pConfig.contents().getBlock())) {
            return false;
        }
        if (CANNOT_REPLACE.contains((Object)blockstate.getBlock())) {
            return false;
        }
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            boolean flag = pLevel.getBlockState(pPos.relative(direction)).isAir();
            if (flag && direction != Direction.UP || !flag && direction == Direction.UP) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

