/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DesertWellFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockStatePredicate IS_SAND = BlockStatePredicate.forBlock(Blocks.SAND);
    private final BlockState sandSlab = Blocks.SANDSTONE_SLAB.defaultBlockState();
    private final BlockState sandstone = Blocks.SANDSTONE.defaultBlockState();
    private final BlockState water = Blocks.WATER.defaultBlockState();

    public DesertWellFeature(Codec<NoneFeatureConfiguration> p_65599_) {
        super(p_65599_);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> p_159571_) {
        WorldGenLevel worldgenlevel = p_159571_.level();
        BlockPos blockpos = p_159571_.origin();
        blockpos = blockpos.above();
        while (worldgenlevel.isEmptyBlock(blockpos) && blockpos.getY() > worldgenlevel.getMinBuildHeight() + 2) {
            blockpos = blockpos.below();
        }
        if (!IS_SAND.test(worldgenlevel.getBlockState(blockpos))) {
            return false;
        }
        int i = -2;
        while (i <= 2) {
            int j = -2;
            while (j <= 2) {
                if (worldgenlevel.isEmptyBlock(blockpos.offset(i, -1, j)) && worldgenlevel.isEmptyBlock(blockpos.offset(i, -2, j))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        int l = -1;
        while (l <= 0) {
            int l1 = -2;
            while (l1 <= 2) {
                int k = -2;
                while (k <= 2) {
                    worldgenlevel.setBlock(blockpos.offset(l1, l, k), this.sandstone, 2);
                    ++k;
                }
                ++l1;
            }
            ++l;
        }
        worldgenlevel.setBlock(blockpos, this.water, 2);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            worldgenlevel.setBlock(blockpos.relative(direction), this.water, 2);
        }
        int i1 = -2;
        while (i1 <= 2) {
            int i2 = -2;
            while (i2 <= 2) {
                if (i1 == -2 || i1 == 2 || i2 == -2 || i2 == 2) {
                    worldgenlevel.setBlock(blockpos.offset(i1, 1, i2), this.sandstone, 2);
                }
                ++i2;
            }
            ++i1;
        }
        worldgenlevel.setBlock(blockpos.offset(2, 1, 0), this.sandSlab, 2);
        worldgenlevel.setBlock(blockpos.offset(-2, 1, 0), this.sandSlab, 2);
        worldgenlevel.setBlock(blockpos.offset(0, 1, 2), this.sandSlab, 2);
        worldgenlevel.setBlock(blockpos.offset(0, 1, -2), this.sandSlab, 2);
        int j1 = -1;
        while (j1 <= 1) {
            int j2 = -1;
            while (j2 <= 1) {
                if (j1 == 0 && j2 == 0) {
                    worldgenlevel.setBlock(blockpos.offset(j1, 4, j2), this.sandstone, 2);
                } else {
                    worldgenlevel.setBlock(blockpos.offset(j1, 4, j2), this.sandSlab, 2);
                }
                ++j2;
            }
            ++j1;
        }
        int k1 = 1;
        while (k1 <= 3) {
            worldgenlevel.setBlock(blockpos.offset(-1, k1, -1), this.sandstone, 2);
            worldgenlevel.setBlock(blockpos.offset(-1, k1, 1), this.sandstone, 2);
            worldgenlevel.setBlock(blockpos.offset(1, k1, -1), this.sandstone, 2);
            worldgenlevel.setBlock(blockpos.offset(1, k1, 1), this.sandstone, 2);
            ++k1;
        }
        return true;
    }
}

