/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class DripstoneClusterFeature
extends Feature<DripstoneClusterConfiguration> {
    public DripstoneClusterFeature(Codec<DripstoneClusterConfiguration> p_159575_) {
        super(p_159575_);
    }

    @Override
    public boolean place(FeaturePlaceContext<DripstoneClusterConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        DripstoneClusterConfiguration dripstoneclusterconfiguration = pContext.config();
        Random random = pContext.random();
        if (!DripstoneUtils.isEmptyOrWater(worldgenlevel, blockpos)) {
            return false;
        }
        int i = dripstoneclusterconfiguration.height.sample(random);
        float f = dripstoneclusterconfiguration.wetness.sample(random);
        float f1 = dripstoneclusterconfiguration.density.sample(random);
        int j = dripstoneclusterconfiguration.radius.sample(random);
        int k = dripstoneclusterconfiguration.radius.sample(random);
        int l = -j;
        while (l <= j) {
            int i1 = -k;
            while (i1 <= k) {
                double d0 = this.getChanceOfStalagmiteOrStalactite(j, k, l, i1, dripstoneclusterconfiguration);
                BlockPos blockpos1 = blockpos.offset(l, 0, i1);
                this.placeColumn(worldgenlevel, random, blockpos1, l, i1, f, d0, i, f1, dripstoneclusterconfiguration);
                ++i1;
            }
            ++l;
        }
        return true;
    }

    private void placeColumn(WorldGenLevel pLevel, Random pRandom, BlockPos pPos, int pX, int pZ, float pWetness, double pChance, int p_159601_, float pHeight, DripstoneClusterConfiguration pDensity) {
        Optional<Column> optional = Column.scan(pLevel, pPos, pDensity.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isNeitherEmptyNorWater);
        if (optional.isPresent()) {
            OptionalInt optionalint = optional.get().getCeiling();
            OptionalInt optionalint1 = optional.get().getFloor();
            if (optionalint.isPresent() || optionalint1.isPresent()) {
                boolean flag3;
                int j1;
                int j3;
                int i3;
                boolean flag2;
                int j;
                boolean flag1;
                Column column;
                boolean flag;
                boolean bl = flag = pRandom.nextFloat() < pWetness;
                if (flag && optionalint1.isPresent() && this.canPlacePool(pLevel, pPos.atY(optionalint1.getAsInt()))) {
                    int i = optionalint1.getAsInt();
                    column = optional.get().withFloor(OptionalInt.of(i - 1));
                    pLevel.setBlock(pPos.atY(i), Blocks.WATER.defaultBlockState(), 2);
                } else {
                    column = optional.get();
                }
                OptionalInt optionalint2 = column.getFloor();
                boolean bl2 = flag1 = pRandom.nextDouble() < pChance;
                if (optionalint.isPresent() && flag1 && !this.isLava(pLevel, pPos.atY(optionalint.getAsInt()))) {
                    int k = pDensity.dripstoneBlockLayerThickness.sample(pRandom);
                    this.replaceBlocksWithDripstoneBlocks(pLevel, pPos.atY(optionalint.getAsInt()), k, Direction.UP);
                    int l = optionalint2.isPresent() ? Math.min(p_159601_, optionalint.getAsInt() - optionalint2.getAsInt()) : p_159601_;
                    j = this.getDripstoneHeight(pRandom, pX, pZ, pHeight, l, pDensity);
                } else {
                    j = 0;
                }
                boolean bl3 = flag2 = pRandom.nextDouble() < pChance;
                if (optionalint2.isPresent() && flag2 && !this.isLava(pLevel, pPos.atY(optionalint2.getAsInt()))) {
                    int i1 = pDensity.dripstoneBlockLayerThickness.sample(pRandom);
                    this.replaceBlocksWithDripstoneBlocks(pLevel, pPos.atY(optionalint2.getAsInt()), i1, Direction.DOWN);
                    i3 = optionalint.isPresent() ? Math.max(0, j + Mth.randomBetweenInclusive(pRandom, -pDensity.maxStalagmiteStalactiteHeightDiff, pDensity.maxStalagmiteStalactiteHeightDiff)) : this.getDripstoneHeight(pRandom, pX, pZ, pHeight, p_159601_, pDensity);
                } else {
                    i3 = 0;
                }
                if (optionalint.isPresent() && optionalint2.isPresent() && optionalint.getAsInt() - j <= optionalint2.getAsInt() + i3) {
                    int k1 = optionalint2.getAsInt();
                    int l1 = optionalint.getAsInt();
                    int i2 = Math.max(l1 - j, k1 + 1);
                    int j2 = Math.min(k1 + i3, l1 - 1);
                    int k2 = Mth.randomBetweenInclusive(pRandom, i2, j2 + 1);
                    int l2 = k2 - 1;
                    j3 = l1 - k2;
                    j1 = l2 - k1;
                } else {
                    j3 = j;
                    j1 = i3;
                }
                boolean bl4 = flag3 = pRandom.nextBoolean() && j3 > 0 && j1 > 0 && column.getHeight().isPresent() && j3 + j1 == column.getHeight().getAsInt();
                if (optionalint.isPresent()) {
                    DripstoneUtils.growPointedDripstone(pLevel, pPos.atY(optionalint.getAsInt() - 1), Direction.DOWN, j3, flag3);
                }
                if (optionalint2.isPresent()) {
                    DripstoneUtils.growPointedDripstone(pLevel, pPos.atY(optionalint2.getAsInt() + 1), Direction.UP, j1, flag3);
                }
            }
        }
    }

    private boolean isLava(LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos).is(Blocks.LAVA);
    }

    private int getDripstoneHeight(Random pRandom, int pX, int pZ, float pChance, int pHeight, DripstoneClusterConfiguration pConfig) {
        if (pRandom.nextFloat() > pChance) {
            return 0;
        }
        int i = Math.abs(pX) + Math.abs(pZ);
        float f = (float)Mth.clampedMap((double)i, 0.0, (double)pConfig.maxDistanceFromCenterAffectingHeightBias, (double)pHeight / 2.0, 0.0);
        return (int)DripstoneClusterFeature.randomBetweenBiased(pRandom, 0.0f, pHeight, f, pConfig.heightDeviation);
    }

    private boolean canPlacePool(WorldGenLevel pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (!(blockstate.is(Blocks.WATER) || blockstate.is(Blocks.DRIPSTONE_BLOCK) || blockstate.is(Blocks.POINTED_DRIPSTONE))) {
            if (pLevel.getBlockState(pPos.above()).getFluidState().is(FluidTags.WATER)) {
                return false;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.canBeAdjacentToWater(pLevel, pPos.relative(direction))) continue;
                return false;
            }
            return this.canBeAdjacentToWater(pLevel, pPos.below());
        }
        return false;
    }

    private boolean canBeAdjacentToWater(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        return blockstate.is(BlockTags.BASE_STONE_OVERWORLD) || blockstate.getFluidState().is(FluidTags.WATER);
    }

    private void replaceBlocksWithDripstoneBlocks(WorldGenLevel pLevel, BlockPos pPos, int pThickness, Direction pDirection) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        int i = 0;
        while (i < pThickness) {
            if (!DripstoneUtils.placeDripstoneBlockIfPossible(pLevel, blockpos$mutableblockpos)) {
                return;
            }
            blockpos$mutableblockpos.move(pDirection);
            ++i;
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int pXRadius, int pZRadius, int pX, int pZ, DripstoneClusterConfiguration pConfig) {
        int i = pXRadius - Math.abs(pX);
        int j = pZRadius - Math.abs(pZ);
        int k = Math.min(i, j);
        return Mth.clampedMap(k, 0.0f, pConfig.maxDistanceFromEdgeAffectingChanceOfDripstoneColumn, pConfig.chanceOfDripstoneColumnAtMaxDistanceFromCenter, 1.0f);
    }

    private static float randomBetweenBiased(Random pRandom, float pMin, float pMax, float pMean, float pDeviation) {
        return ClampedNormalFloat.sample(pRandom, pMean, pDeviation, pMin, pMax);
    }
}

