/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;

public class DripstoneUtils {
    protected static double getDripstoneHeight(double pRadius, double p_159625_, double pMaxRadius, double p_159627_) {
        if (pRadius < p_159627_) {
            pRadius = p_159627_;
        }
        double d0 = 0.384;
        double d1 = pRadius / p_159625_ * 0.384;
        double d2 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = pMaxRadius * (d2 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * p_159625_;
    }

    protected static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel pLevel, BlockPos pPos, int pRadius) {
        if (DripstoneUtils.isEmptyOrWaterOrLava(pLevel, pPos)) {
            return false;
        }
        float f = 6.0f;
        float f1 = 6.0f / (float)pRadius;
        float f2 = 0.0f;
        while (f2 < (float)Math.PI * 2) {
            int j;
            int i = (int)(Mth.cos(f2) * (float)pRadius);
            if (DripstoneUtils.isEmptyOrWaterOrLava(pLevel, pPos.offset(i, 0, j = (int)(Mth.sin(f2) * (float)pRadius)))) {
                return false;
            }
            f2 += f1;
        }
        return true;
    }

    protected static boolean isEmptyOrWater(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, DripstoneUtils::isEmptyOrWater);
    }

    protected static boolean isEmptyOrWaterOrLava(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, DripstoneUtils::isEmptyOrWaterOrLava);
    }

    protected static void buildBaseToTipColumn(Direction pDirection, int pHeight, boolean pMergeTip, Consumer<BlockState> pBlockSetter) {
        if (pHeight >= 3) {
            pBlockSetter.accept(DripstoneUtils.createPointedDripstone(pDirection, DripstoneThickness.BASE));
            int i = 0;
            while (i < pHeight - 3) {
                pBlockSetter.accept(DripstoneUtils.createPointedDripstone(pDirection, DripstoneThickness.MIDDLE));
                ++i;
            }
        }
        if (pHeight >= 2) {
            pBlockSetter.accept(DripstoneUtils.createPointedDripstone(pDirection, DripstoneThickness.FRUSTUM));
        }
        if (pHeight >= 1) {
            pBlockSetter.accept(DripstoneUtils.createPointedDripstone(pDirection, pMergeTip ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void growPointedDripstone(LevelAccessor p_190848_, BlockPos p_190849_, Direction p_190850_, int p_190851_, boolean p_190852_) {
        if (DripstoneUtils.isDripstoneBase(p_190848_.getBlockState(p_190849_.relative(p_190850_.getOpposite())))) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_190849_.mutable();
            DripstoneUtils.buildBaseToTipColumn(p_190850_, p_190851_, p_190852_, p_190846_ -> {
                if (p_190846_.is(Blocks.POINTED_DRIPSTONE)) {
                    p_190846_ = (BlockState)p_190846_.setValue(PointedDripstoneBlock.WATERLOGGED, p_190848_.isWaterAt(blockpos$mutableblockpos));
                }
                p_190848_.setBlock(blockpos$mutableblockpos, (BlockState)p_190846_, 2);
                blockpos$mutableblockpos.move(p_190850_);
            });
        }
    }

    protected static boolean placeDripstoneBlockIfPossible(LevelAccessor p_190854_, BlockPos p_190855_) {
        BlockState blockstate = p_190854_.getBlockState(p_190855_);
        if (blockstate.is(BlockTags.DRIPSTONE_REPLACEABLE)) {
            p_190854_.setBlock(p_190855_, Blocks.DRIPSTONE_BLOCK.defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    private static BlockState createPointedDripstone(Direction pDirection, DripstoneThickness pDripstoneThickness) {
        return (BlockState)((BlockState)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue(PointedDripstoneBlock.TIP_DIRECTION, pDirection)).setValue(PointedDripstoneBlock.THICKNESS, pDripstoneThickness);
    }

    public static boolean isDripstoneBaseOrLava(BlockState pState) {
        return DripstoneUtils.isDripstoneBase(pState) || pState.is(Blocks.LAVA);
    }

    public static boolean isDripstoneBase(BlockState pState) {
        return pState.is(Blocks.DRIPSTONE_BLOCK) || pState.is(BlockTags.DRIPSTONE_REPLACEABLE);
    }

    public static boolean isEmptyOrWater(BlockState p_159665_) {
        return p_159665_.isAir() || p_159665_.is(Blocks.WATER);
    }

    public static boolean isNeitherEmptyNorWater(BlockState p_203131_) {
        return !p_203131_.isAir() && !p_203131_.is(Blocks.WATER);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState p_159667_) {
        return p_159667_.isAir() || p_159667_.is(Blocks.WATER) || p_159667_.is(Blocks.LAVA);
    }
}

