/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.mutable.MutableInt;

public class FossilFeature
extends Feature<FossilFeatureConfiguration> {
    public FossilFeature(Codec<FossilFeatureConfiguration> p_65851_) {
        super(p_65851_);
    }

    @Override
    public boolean place(FeaturePlaceContext<FossilFeatureConfiguration> pContext) {
        Random random = pContext.random();
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        Rotation rotation = Rotation.getRandom(random);
        FossilFeatureConfiguration fossilfeatureconfiguration = pContext.config();
        int i = random.nextInt(fossilfeatureconfiguration.fossilStructures.size());
        StructureManager structuremanager = worldgenlevel.getLevel().getServer().getStructureManager();
        StructureTemplate structuretemplate = structuremanager.getOrCreate(fossilfeatureconfiguration.fossilStructures.get(i));
        StructureTemplate structuretemplate1 = structuremanager.getOrCreate(fossilfeatureconfiguration.overlayStructures.get(i));
        ChunkPos chunkpos = new ChunkPos(blockpos);
        BoundingBox boundingbox = new BoundingBox(chunkpos.getMinBlockX() - 16, worldgenlevel.getMinBuildHeight(), chunkpos.getMinBlockZ() - 16, chunkpos.getMaxBlockX() + 16, worldgenlevel.getMaxBuildHeight(), chunkpos.getMaxBlockZ() + 16);
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().setRotation(rotation).setBoundingBox(boundingbox).setRandom(random);
        Vec3i vec3i = structuretemplate.getSize(rotation);
        BlockPos blockpos1 = blockpos.offset(-vec3i.getX() / 2, 0, -vec3i.getZ() / 2);
        int j = blockpos.getY();
        int k = 0;
        while (k < vec3i.getX()) {
            int l = 0;
            while (l < vec3i.getZ()) {
                j = Math.min(j, worldgenlevel.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, blockpos1.getX() + k, blockpos1.getZ() + l));
                ++l;
            }
            ++k;
        }
        int i1 = Math.max(j - 15 - random.nextInt(10), worldgenlevel.getMinBuildHeight() + 10);
        BlockPos blockpos2 = structuretemplate.getZeroPositionWithTransform(blockpos1.atY(i1), Mirror.NONE, rotation);
        if (FossilFeature.countEmptyCorners(worldgenlevel, structuretemplate.getBoundingBox(structureplacesettings, blockpos2)) > fossilfeatureconfiguration.maxEmptyCornersAllowed) {
            return false;
        }
        structureplacesettings.clearProcessors();
        fossilfeatureconfiguration.fossilProcessors.value().list().forEach(structureplacesettings::addProcessor);
        structuretemplate.placeInWorld(worldgenlevel, blockpos2, blockpos2, structureplacesettings, random, 4);
        structureplacesettings.clearProcessors();
        fossilfeatureconfiguration.overlayProcessors.value().list().forEach(structureplacesettings::addProcessor);
        structuretemplate1.placeInWorld(worldgenlevel, blockpos2, blockpos2, structureplacesettings, random, 4);
        return true;
    }

    private static int countEmptyCorners(WorldGenLevel pLevel, BoundingBox pBoundingBox) {
        MutableInt mutableint = new MutableInt(0);
        pBoundingBox.forAllCorners(p_204749_ -> {
            BlockState blockstate = pLevel.getBlockState((BlockPos)p_204749_);
            if (blockstate.isAir() || blockstate.is(Blocks.LAVA) || blockstate.is(Blocks.WATER)) {
                mutableint.add(1);
            }
        });
        return mutableint.getValue();
    }
}

