/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.GlowLichenConfiguration;

public class GlowLichenFeature
extends Feature<GlowLichenConfiguration> {
    public GlowLichenFeature(Codec<GlowLichenConfiguration> p_159838_) {
        super(p_159838_);
    }

    @Override
    public boolean place(FeaturePlaceContext<GlowLichenConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        Random random = pContext.random();
        GlowLichenConfiguration glowlichenconfiguration = pContext.config();
        if (!GlowLichenFeature.isAirOrWater(worldgenlevel.getBlockState(blockpos))) {
            return false;
        }
        List<Direction> list = GlowLichenFeature.getShuffledDirections(glowlichenconfiguration, random);
        if (GlowLichenFeature.placeGlowLichenIfPossible(worldgenlevel, blockpos, worldgenlevel.getBlockState(blockpos), glowlichenconfiguration, random, list)) {
            return true;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos.mutable();
        block0: for (Direction direction : list) {
            blockpos$mutableblockpos.set(blockpos);
            List<Direction> list1 = GlowLichenFeature.getShuffledDirectionsExcept(glowlichenconfiguration, random, direction.getOpposite());
            int i = 0;
            while (i < glowlichenconfiguration.searchRange) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, direction);
                BlockState blockstate = worldgenlevel.getBlockState(blockpos$mutableblockpos);
                if (!GlowLichenFeature.isAirOrWater(blockstate) && !blockstate.is(Blocks.GLOW_LICHEN)) continue block0;
                if (GlowLichenFeature.placeGlowLichenIfPossible(worldgenlevel, blockpos$mutableblockpos, blockstate, glowlichenconfiguration, random, list1)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean placeGlowLichenIfPossible(WorldGenLevel pLevel, BlockPos pPos, BlockState pState, GlowLichenConfiguration pConfig, Random pRandom, List<Direction> pDirections) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        for (Direction direction : pDirections) {
            BlockState blockstate = pLevel.getBlockState(blockpos$mutableblockpos.setWithOffset((Vec3i)pPos, direction));
            if (!blockstate.is(pConfig.canBePlacedOn)) continue;
            GlowLichenBlock glowlichenblock = (GlowLichenBlock)Blocks.GLOW_LICHEN;
            BlockState blockstate1 = glowlichenblock.getStateForPlacement(pState, pLevel, pPos, direction);
            if (blockstate1 == null) {
                return false;
            }
            pLevel.setBlock(pPos, blockstate1, 3);
            pLevel.getChunk(pPos).markPosForPostprocessing(pPos);
            if (pRandom.nextFloat() < pConfig.chanceOfSpreading) {
                glowlichenblock.spreadFromFaceTowardRandomDirection(blockstate1, pLevel, pPos, direction, pRandom, true);
            }
            return true;
        }
        return false;
    }

    public static List<Direction> getShuffledDirections(GlowLichenConfiguration pConfig, Random pRandom) {
        ArrayList list = Lists.newArrayList(pConfig.validDirections);
        Collections.shuffle(list, pRandom);
        return list;
    }

    public static List<Direction> getShuffledDirectionsExcept(GlowLichenConfiguration pConfig, Random pRandom, Direction pExcludedDirection) {
        List<Direction> list = pConfig.validDirections.stream().filter(p_159857_ -> p_159857_ != pExcludedDirection).collect(Collectors.toList());
        Collections.shuffle(list, pRandom);
        return list;
    }

    private static boolean isAirOrWater(BlockState pState) {
        return pState.isAir() || pState.is(Blocks.WATER);
    }
}

